/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSsl;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.internal.ReflectionUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;

public abstract class SslMasterKeyHandler
extends ChannelInboundHandlerAdapter {
    private static final InternalLogger logger;
    private static final Class<?> SSL_SESSIONIMPL_CLASS;
    private static final Field SSL_SESSIONIMPL_MASTER_SECRET_FIELD;
    public static final String SYSTEM_PROP_KEY = "io.netty.ssl.masterKeyHandler";
    private static final Throwable UNAVAILABILITY_CAUSE;

    protected SslMasterKeyHandler() {
    }

    public static void ensureSunSslEngineAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw new IllegalStateException("Failed to find SSLSessionImpl on classpath", UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable sunSslEngineUnavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    public static boolean isSunSslEngineAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    protected abstract void accept(SecretKey var1, SSLSession var2);

    public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object == SslHandshakeCompletionEvent.SUCCESS && this.masterKeyHandlerEnabled()) {
            SslHandler sslHandler = (SslHandler)channelHandlerContext.pipeline().get(SslHandler.class);
            SSLEngine sSLEngine = sslHandler.engine();
            SSLSession sSLSession = sSLEngine.getSession();
            if (SslMasterKeyHandler.isSunSslEngineAvailable() && sSLSession.getClass().equals(SSL_SESSIONIMPL_CLASS)) {
                SecretKey secretKey;
                try {
                    secretKey = (SecretKey)SSL_SESSIONIMPL_MASTER_SECRET_FIELD.get(sSLSession);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Failed to access the field 'masterSecret' via reflection.", illegalAccessException);
                }
                this.accept(secretKey, sSLSession);
            } else if (OpenSsl.isAvailable() && sSLEngine instanceof ReferenceCountedOpenSslEngine) {
                SecretKeySpec secretKeySpec = ((ReferenceCountedOpenSslEngine)sSLEngine).masterKey();
                this.accept(secretKeySpec, sSLSession);
            }
        }
        channelHandlerContext.fireUserEventTriggered(object);
    }

    protected boolean masterKeyHandlerEnabled() {
        return SystemPropertyUtil.getBoolean((String)SYSTEM_PROP_KEY, (boolean)false);
    }

    public static SslMasterKeyHandler newWireSharkSslMasterKeyHandler() {
        return new WiresharkSslMasterKeyHandler();
    }

    static {
        Throwable throwable;
        logger = InternalLoggerFactory.getInstance(SslMasterKeyHandler.class);
        Class<?> clazz = null;
        Field field = null;
        try {
            clazz = Class.forName("sun.security.ssl.SSLSessionImpl");
            field = clazz.getDeclaredField("masterSecret");
            throwable = ReflectionUtil.trySetAccessible((AccessibleObject)field, (boolean)true);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            if (logger.isTraceEnabled()) {
                logger.debug("sun.security.ssl.SSLSessionImpl is unavailable.", throwable2);
            }
            logger.debug("sun.security.ssl.SSLSessionImpl is unavailable: {}", (Object)throwable2.getMessage());
        }
        UNAVAILABILITY_CAUSE = throwable;
        SSL_SESSIONIMPL_CLASS = clazz;
        SSL_SESSIONIMPL_MASTER_SECRET_FIELD = field;
    }

    static final class WiresharkSslMasterKeyHandler
    extends SslMasterKeyHandler {
        private static final InternalLogger wireshark_logger = InternalLoggerFactory.getInstance((String)"io.netty.wireshark");

        private WiresharkSslMasterKeyHandler() {
        }

        @Override
        protected void accept(SecretKey secretKey, SSLSession sSLSession) {
            if (secretKey.getEncoded().length != 48) {
                throw new IllegalArgumentException("An invalid length master key was provided.");
            }
            byte[] byArray = sSLSession.getId();
            wireshark_logger.warn("RSA Session-ID:{} Master-Key:{}", (Object)ByteBufUtil.hexDump((byte[])byArray).toLowerCase(), (Object)ByteBufUtil.hexDump((byte[])secretKey.getEncoded()).toLowerCase());
        }
    }
}

