/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ApplicationProtocolConfig;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.CipherSuiteFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSsl;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslEngineMap;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslServerSessionContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSessionTicketKey;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContextOption;
import io.netty.buffer.ByteBufAllocator;
import io.netty.internal.tcnative.CertificateCallback;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SniHostNameMatcher;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslServerContext
extends ReferenceCountedOpenSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslServerContext.class);
    private static final byte[] ID = new byte[]{110, 101, 116, 116, 121};
    private final OpenSslServerSessionContext sessionContext;

    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, String string2, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, ReferenceCountedOpenSslServerContext.toNegotiator(applicationProtocolConfig), l2, l3, clientAuth, stringArray, bl2, bl3, string2, entryArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l2, long l3, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, String string2, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, 1, x509CertificateArray2, clientAuth, stringArray, bl2, bl3, true, entryArray);
        boolean bl4 = false;
        try {
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l2, l3);
            if (SERVER_ENABLE_SESSION_TICKET) {
                this.sessionContext.setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            bl4 = true;
        }
        finally {
            if (!bl4) {
                this.release();
            }
        }
    }

    @Override
    public OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpenSslServerSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, OpenSslEngineMap openSslEngineMap, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2, long l3, long l4) throws SSLException {
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object;
            Object object2;
            try {
                SSLContext.setVerify((long)l2, (int)0, (int)10);
                if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    ObjectUtil.checkNotNull((Object)x509CertificateArray2, (String)"keyCertChain");
                    ReferenceCountedOpenSslServerContext.setKeyMaterial(l2, x509CertificateArray2, privateKey, string);
                } else {
                    if (keyManagerFactory == null) {
                        object2 = ReferenceCountedOpenSslServerContext.keyStorePassword(string);
                        object = ReferenceCountedOpenSslServerContext.buildKeyStore(x509CertificateArray2, privateKey, object2, string2);
                        keyManagerFactory = object.aliases().hasMoreElements() ? new OpenSslX509KeyManagerFactory() : new OpenSslCachingX509KeyManagerFactory(KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm()));
                        keyManagerFactory.init((KeyStore)object, (char[])object2);
                    }
                    openSslKeyMaterialProvider = ReferenceCountedOpenSslServerContext.providerFor(keyManagerFactory, string);
                    SSLContext.setCertificateCallback((long)l2, (CertificateCallback)new OpenSslServerCertificateCallback(openSslEngineMap, new OpenSslKeyMaterialManager(openSslKeyMaterialProvider)));
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslServerContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object2 = ReferenceCountedOpenSslServerContext.chooseTrustManager(trustManagerFactory.getTrustManagers());
                ReferenceCountedOpenSslServerContext.setVerifyCallback(l2, openSslEngineMap, (X509TrustManager)object2);
                object = object2.getAcceptedIssuers();
                if (object != null && ((X509Certificate[])object).length > 0) {
                    long l5 = 0L;
                    try {
                        l5 = ReferenceCountedOpenSslServerContext.toBIO(ByteBufAllocator.DEFAULT, object);
                        if (!SSLContext.setCACertificateBio((long)l2, (long)l5)) {
                            throw new SSLException("unable to setup accepted issuers for trustmanager " + object2);
                        }
                    }
                    finally {
                        ReferenceCountedOpenSslServerContext.freeBio(l5);
                    }
                }
                if (PlatformDependent.javaVersion() >= 8) {
                    SSLContext.setSniHostnameMatcher((long)l2, (SniHostNameMatcher)new OpenSslSniHostnameMatcher(openSslEngineMap));
                }
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object2 = new OpenSslServerSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            object2.setSessionIdContext(ID);
            object2.setSessionCacheEnabled(SERVER_ENABLE_SESSION_CACHE);
            if (l3 > 0L) {
                object2.setSessionCacheSize((int)Math.min(l3, Integer.MAX_VALUE));
            }
            if (l4 > 0L) {
                object2.setSessionTimeout((int)Math.min(l4, Integer.MAX_VALUE));
            }
            openSslKeyMaterialProvider = null;
            object = object2;
            return object;
        }
        finally {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
        }
    }

    private static void setVerifyCallback(long l2, OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslServerContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(openSslEngineMap, (X509ExtendedTrustManager)x509TrustManager));
        } else {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new TrustManagerVerifyCallback(openSslEngineMap, x509TrustManager));
        }
    }

    static final class OpenSslSniHostnameMatcher
    implements SniHostNameMatcher {
        private final OpenSslEngineMap engineMap;

        OpenSslSniHostnameMatcher(OpenSslEngineMap openSslEngineMap) {
            this.engineMap = openSslEngineMap;
        }

        public boolean match(long l2, String string) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
            if (referenceCountedOpenSslEngine != null) {
                return referenceCountedOpenSslEngine.checkSniHostnameMatch(string.getBytes(CharsetUtil.UTF_8));
            }
            logger.warn("No ReferenceCountedOpenSslEngine found for SSL pointer: {}", (Object)l2);
            return false;
        }
    }

    static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(openSslEngineMap);
            this.manager = x509ExtendedTrustManager;
        }

        @Override
        void verify(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, X509Certificate[] x509CertificateArray, String string) throws Exception {
            this.manager.checkClientTrusted(x509CertificateArray, string, referenceCountedOpenSslEngine);
        }
    }

    static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap openSslEngineMap, X509TrustManager x509TrustManager) {
            super(openSslEngineMap);
            this.manager = x509TrustManager;
        }

        @Override
        void verify(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, X509Certificate[] x509CertificateArray, String string) throws Exception {
            this.manager.checkClientTrusted(x509CertificateArray, string);
        }
    }

    static final class OpenSslServerCertificateCallback
    implements CertificateCallback {
        private final OpenSslEngineMap engineMap;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslServerCertificateCallback(OpenSslEngineMap openSslEngineMap, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engineMap = openSslEngineMap;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }

        public void handle(long l2, byte[] byArray, byte[][] byArray2) throws Exception {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
            if (referenceCountedOpenSslEngine == null) {
                return;
            }
            try {
                this.keyManagerHolder.setKeyMaterialServerSide(referenceCountedOpenSslEngine);
            }
            catch (Throwable throwable) {
                referenceCountedOpenSslEngine.initHandshakeException(throwable);
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new SSLException(throwable);
            }
        }
    }
}

