/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ApplicationProtocolConfig;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.CipherSuiteConverter;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.CipherSuiteFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.EnhancingX509ExtendedTrustManager;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSsl;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslAsyncPrivateKeyMethod;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslCertificateCompressionAlgorithm;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslCertificateException;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslContextOption;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslEngineMap;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSessionContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslSessionStats;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslX509TrustManagerWrapper;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.PemEncoded;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.PemPrivateKey;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.PemX509Certificate;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContextOption;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslHandler;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslUtils;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.util.LazyX509Certificate;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.internal.tcnative.AsyncSSLPrivateKeyMethod;
import io.netty.internal.tcnative.CertificateCompressionAlgo;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.ResultCallback;
import io.netty.internal.tcnative.SSL;
import io.netty.internal.tcnative.SSLContext;
import io.netty.internal.tcnative.SSLPrivateKeyMethod;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = Math.max(1, SystemPropertyUtil.getInt((String)"XdepsXdatabricksX240X9088.io.netty.handler.ssl.openssl.bioNonApplicationBufferSize", (int)2048));
    static final boolean USE_TASKS = SystemPropertyUtil.getBoolean((String)"XdepsXdatabricksX240X9088.io.netty.handler.ssl.openssl.useTasks", (boolean)true);
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected static final int VERIFY_DEPTH = 10;
    static final boolean CLIENT_ENABLE_SESSION_TICKET;
    static final boolean CLIENT_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_TICKET;
    static final boolean SERVER_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_CACHE;
    static final boolean CLIENT_ENABLE_SESSION_CACHE;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new AbstractReferenceCounted(){

        public ReferenceCounted touch(Object object) {
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                ReferenceCountedOpenSslContext.this.leak.record(object);
            }
            return ReferenceCountedOpenSslContext.this;
        }

        protected void deallocate() {
            ReferenceCountedOpenSslContext.this.destroy();
            if (ReferenceCountedOpenSslContext.this.leak != null) {
                boolean bl2 = ReferenceCountedOpenSslContext.this.leak.close((Object)ReferenceCountedOpenSslContext.this);
                assert (bl2);
            }
        }
    };
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final boolean hasTLSv13Cipher;
    final boolean enableOcsp;
    final OpenSslEngineMap engineMap = new DefaultOpenSslEngineMap();
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;
    final boolean tlsFalseStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, int n2, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl2, boolean bl3, boolean bl4, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        super(bl2);
        OpenSsl.ensureAvailability();
        if (bl3 && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        boolean bl5 = false;
        boolean bl6 = USE_TASKS;
        OpenSslPrivateKeyMethod openSslPrivateKeyMethod = null;
        OpenSslAsyncPrivateKeyMethod openSslAsyncPrivateKeyMethod = null;
        OpenSslCertificateCompressionConfig openSslCertificateCompressionConfig = null;
        Integer n3 = null;
        if (entryArray != null) {
            for (Map.Entry<SslContextOption<?>, Object> entry : entryArray) {
                SslContextOption<?> sslContextOption = entry.getKey();
                if (sslContextOption == OpenSslContextOption.TLS_FALSE_START) {
                    bl5 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.USE_TASKS) {
                    bl6 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.PRIVATE_KEY_METHOD) {
                    openSslPrivateKeyMethod = (OpenSslPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.ASYNC_PRIVATE_KEY_METHOD) {
                    openSslAsyncPrivateKeyMethod = (OpenSslAsyncPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS) {
                    openSslCertificateCompressionConfig = (OpenSslCertificateCompressionConfig)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES) {
                    n3 = (Integer)entry.getValue();
                    continue;
                }
                logger.debug("Skipping unsupported " + SslContextOption.class.getSimpleName() + ": " + entry.getKey());
            }
        }
        if (openSslPrivateKeyMethod != null && openSslAsyncPrivateKeyMethod != null) {
            throw new IllegalArgumentException("You can either only use " + OpenSslAsyncPrivateKeyMethod.class.getSimpleName() + " or " + OpenSslPrivateKeyMethod.class.getSimpleName());
        }
        this.tlsFalseStart = bl5;
        this.leak = bl4 ? leakDetector.track((Object)this) : null;
        this.mode = n2;
        ClientAuth clientAuth2 = this.clientAuth = this.isServer() ? (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)((Object)clientAuth), (String)"clientAuth")) : ClientAuth.NONE;
        this.protocols = stringArray == null ? OpenSsl.defaultProtocols(n2 == 0) : stringArray;
        this.enableOcsp = bl3;
        this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        Object[] objectArray = ((CipherSuiteFilter)ObjectUtil.checkNotNull((Object)cipherSuiteFilter, (String)"cipherFilter")).filterCipherSuites(iterable, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites());
        LinkedHashSet linkedHashSet = new LinkedHashSet(objectArray.length);
        Collections.addAll(linkedHashSet, objectArray);
        this.unmodifiableCiphers = new ArrayList<String>(linkedHashSet);
        this.apn = (OpenSslApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)openSslApplicationProtocolNegotiator, (String)"apn");
        int n4 = 0;
        try {
            List<String> list;
            boolean bl7 = OpenSsl.isTlsv13Supported();
            boolean bl8 = false;
            try {
                int n5 = 30;
                if (bl7) {
                    n5 |= 0x20;
                }
                this.ctx = SSLContext.make((int)n5, (int)n2);
            }
            catch (Exception exception) {
                throw new SSLException("failed to create an SSL_CTX", exception);
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            try {
                if (this.unmodifiableCiphers.isEmpty()) {
                    SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)false);
                    if (bl7) {
                        SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)true);
                    }
                } else {
                    CipherSuiteConverter.convertToCipherStrings(this.unmodifiableCiphers, stringBuilder, stringBuilder2, OpenSsl.isBoringSSL());
                    SSLContext.setCipherSuite((long)this.ctx, (String)stringBuilder.toString(), (boolean)false);
                    if (bl7) {
                        String string = OpenSsl.checkTls13Ciphers(logger, stringBuilder2.toString());
                        SSLContext.setCipherSuite((long)this.ctx, (String)string, (boolean)true);
                        if (!string.isEmpty()) {
                            bl8 = true;
                        }
                    }
                }
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
            }
            int n6 = SSLContext.getOptions((long)this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET;
            if (stringBuilder.length() == 0) {
                n6 |= SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2;
            }
            if (!bl7) {
                n6 |= SSL.SSL_OP_NO_TLSv1_3;
            }
            this.hasTLSv13Cipher = bl8;
            SSLContext.setOptions((long)this.ctx, (int)n6);
            SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER));
            if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
            }
            if (!(list = openSslApplicationProtocolNegotiator.protocols()).isEmpty()) {
                String[] stringArray2 = list.toArray(EmptyArrays.EMPTY_STRINGS);
                int n7 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                switch (openSslApplicationProtocolNegotiator.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray2, (int)n7);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray2, (int)n7);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray2, (int)n7);
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray2, (int)n7);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (bl3) {
                SSLContext.enableOcsp((long)this.ctx, (boolean)this.isClient());
            }
            SSLContext.setUseTasks((long)this.ctx, (boolean)bl6);
            if (openSslPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new PrivateKeyMethod(this.engineMap, openSslPrivateKeyMethod));
            }
            if (openSslAsyncPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (AsyncSSLPrivateKeyMethod)new AsyncPrivateKeyMethod(this.engineMap, openSslAsyncPrivateKeyMethod));
            }
            if (openSslCertificateCompressionConfig != null) {
                block19: for (OpenSslCertificateCompressionConfig.AlgorithmConfig algorithmConfig : openSslCertificateCompressionConfig) {
                    CompressionAlgorithm compressionAlgorithm = new CompressionAlgorithm(this.engineMap, algorithmConfig.algorithm());
                    switch (algorithmConfig.mode()) {
                        case Decompress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_DECOMPRESS, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block19;
                        }
                        case Compress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_COMPRESS, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block19;
                        }
                        case Both: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_BOTH, (CertificateCompressionAlgo)compressionAlgorithm);
                            continue block19;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (n3 != null) {
                SSLContext.setMaxCertList((long)this.ctx, (int)n3);
            }
            SSLContext.setCurvesList((long)this.ctx, (String[])OpenSsl.NAMED_GROUPS);
            n4 = 1;
        }
        finally {
            if (n4 == 0) {
                this.release();
            }
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior) {
        switch (selectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.newEngine0(byteBufAllocator, string, n2, true);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl2) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl2);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n2, false), bl2);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl2, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl2, executor);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n2, false), executor);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n2, boolean bl2) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n2, bl2, true);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.newEngine(byteBufAllocator, null, -1);
    }

    public final long context() {
        return this.sslCtxPointer();
    }

    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    public void setRejectRemoteInitiatedRenegotiation(boolean bl2) {
        if (!bl2) {
            throw new UnsupportedOperationException("Renegotiation is not supported");
        }
    }

    public boolean getRejectRemoteInitiatedRenegotiation() {
        return true;
    }

    public void setBioNonApplicationBufferSize(int n2) {
        this.bioNonApplicationBufferSize = ObjectUtil.checkPositiveOrZero((int)n2, (String)"bioNonApplicationBufferSize");
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    public final void setTicketKeys(byte[] byArray) {
        this.sessionContext().setTicketKeys(byArray);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long sslCtxPointer() {
        Lock lock = this.ctxLock.readLock();
        lock.lock();
        try {
            long l2 = SSLContext.getSslCtx((long)this.ctx);
            return l2;
        }
        finally {
            lock.unlock();
        }
    }

    public final void setPrivateKeyMethod(OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
        ObjectUtil.checkNotNull((Object)openSslPrivateKeyMethod, (String)"method");
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new PrivateKeyMethod(this.engineMap, openSslPrivateKeyMethod));
        }
        finally {
            lock.unlock();
        }
    }

    public final void setUseTasks(boolean bl2) {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setUseTasks((long)this.ctx, (boolean)bl2);
        }
        finally {
            lock.unlock();
        }
    }

    private void destroy() {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp((long)this.ctx);
                }
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
                OpenSslSessionContext openSslSessionContext = this.sessionContext();
                if (openSslSessionContext != null) {
                    openSslSessionContext.destroy();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            x509CertificateArray[i2] = new LazyX509Certificate(byArray[i2]);
        }
        return x509CertificateArray;
    }

    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            if (PlatformDependent.javaVersion() >= 7 && ReferenceCountedOpenSslContext.useExtendedTrustManager(x509TrustManager = OpenSslX509TrustManagerWrapper.wrapIfNeeded((X509TrustManager)trustManager))) {
                x509TrustManager = new EnhancingX509ExtendedTrustManager(x509TrustManager);
            }
            return x509TrustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    public final ReferenceCounted retain(int n2) {
        this.refCnt.retain(n2);
        return this;
    }

    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    public final boolean release() {
        return this.refCnt.release();
    }

    public final boolean release(int n2) {
        return this.refCnt.release(n2);
    }

    static void setKeyMaterial(long l2, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) throws SSLException {
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l5 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, privateKey);
            }
            SSLContext.setCertificateBio((long)l2, (long)l4, (long)l3, (String)(string == null ? "" : string));
            SSLContext.setCertificateChainBio((long)l2, (long)l5, (boolean)true);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        finally {
            ReferenceCountedOpenSslContext.freeBio(l3);
            ReferenceCountedOpenSslContext.freeBio(l4);
            ReferenceCountedOpenSslContext.freeBio(l5);
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    static void freeBio(long l2) {
        if (l2 != 0L) {
            SSL.freeBIO((long)l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PrivateKey privateKey) throws Exception {
        if (privateKey == null) {
            return 0L;
        }
        PemEncoded pemEncoded = PemPrivateKey.toPEM(byteBufAllocator, true, privateKey);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, X509Certificate ... x509CertificateArray) throws Exception {
        if (x509CertificateArray == null) {
            return 0L;
        }
        ObjectUtil.checkNonEmpty((Object[])x509CertificateArray, (String)"certChain");
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        try {
            long l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) throws Exception {
        try {
            long l2;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l3 = ReferenceCountedOpenSslContext.newBIO(byteBuf.retainedSlice());
                return l3;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                l2 = ReferenceCountedOpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l2;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf byteBuf) throws Exception {
        try {
            long l2 = SSL.newMemBIO();
            int n2 = byteBuf.readableBytes();
            if (SSL.bioWrite((long)l2, (long)(OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex()), (int)n2) != n2) {
                SSL.freeBIO((long)l2);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l3 = l2;
            return l3;
        }
        finally {
            byteBuf.release();
        }
    }

    static OpenSslKeyMaterialProvider providerFor(KeyManagerFactory keyManagerFactory, String string) {
        if (keyManagerFactory instanceof OpenSslX509KeyManagerFactory) {
            return ((OpenSslX509KeyManagerFactory)keyManagerFactory).newProvider();
        }
        if (keyManagerFactory instanceof OpenSslCachingX509KeyManagerFactory) {
            return ((OpenSslCachingX509KeyManagerFactory)keyManagerFactory).newProvider(string);
        }
        return new OpenSslKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()), string);
    }

    private static ReferenceCountedOpenSslEngine retrieveEngine(OpenSslEngineMap openSslEngineMap, long l2) throws SSLException {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = openSslEngineMap.get(l2);
        if (referenceCountedOpenSslEngine == null) {
            throw new SSLException("Could not find a " + StringUtil.simpleClassName(ReferenceCountedOpenSslEngine.class) + " for sslPointer " + l2);
        }
        return referenceCountedOpenSslEngine;
    }

    private static byte[] verifyResult(byte[] byArray) throws SignatureException {
        if (byArray == null) {
            throw new SignatureException();
        }
        return byArray;
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        CLIENT_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean((String)"jdk.tls.client.enableSessionTicketExtension", (boolean)false);
        CLIENT_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean((String)"jdk.tls.client.enableSessionTicketExtension", (boolean)true);
        SERVER_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean((String)"jdk.tls.server.enableSessionTicketExtension", (boolean)false);
        SERVER_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean((String)"jdk.tls.server.enableSessionTicketExtension", (boolean)true);
        SERVER_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean((String)"XdepsXdatabricksX240X9088.io.netty.handler.ssl.openssl.sessionCacheServer", (boolean)true);
        CLIENT_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean((String)"XdepsXdatabricksX240X9088.io.netty.handler.ssl.openssl.sessionCacheClient", (boolean)true);
        NONE_PROTOCOL_NEGOTIATOR = new OpenSslApplicationProtocolNegotiator(){

            @Override
            public ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NONE;
            }

            @Override
            public List<String> protocols() {
                return Collections.emptyList();
            }

            @Override
            public ApplicationProtocolConfig.SelectorFailureBehavior selectorFailureBehavior() {
                return ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL;
            }

            @Override
            public ApplicationProtocolConfig.SelectedListenerFailureBehavior selectedListenerFailureBehavior() {
                return ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
        };
        Integer n2 = null;
        try {
            String string = SystemPropertyUtil.get((String)"jdk.tls.ephemeralDHKeySize");
            if (string != null) {
                try {
                    n2 = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = n2;
    }

    static final class CompressionAlgorithm
    implements CertificateCompressionAlgo {
        private final OpenSslEngineMap engineMap;
        private final OpenSslCertificateCompressionAlgorithm compressionAlgorithm;

        CompressionAlgorithm(OpenSslEngineMap openSslEngineMap, OpenSslCertificateCompressionAlgorithm openSslCertificateCompressionAlgorithm) {
            this.engineMap = openSslEngineMap;
            this.compressionAlgorithm = openSslCertificateCompressionAlgorithm;
        }

        public byte[] compress(long l2, byte[] byArray) throws Exception {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l2);
            return this.compressionAlgorithm.compress(referenceCountedOpenSslEngine, byArray);
        }

        public byte[] decompress(long l2, int n2, byte[] byArray) throws Exception {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l2);
            return this.compressionAlgorithm.decompress(referenceCountedOpenSslEngine, n2, byArray);
        }

        public int algorithmId() {
            return this.compressionAlgorithm.algorithmId();
        }
    }

    static final class AsyncPrivateKeyMethod
    implements AsyncSSLPrivateKeyMethod {
        private final OpenSslEngineMap engineMap;
        private final OpenSslAsyncPrivateKeyMethod keyMethod;

        AsyncPrivateKeyMethod(OpenSslEngineMap openSslEngineMap, OpenSslAsyncPrivateKeyMethod openSslAsyncPrivateKeyMethod) {
            this.engineMap = openSslEngineMap;
            this.keyMethod = openSslAsyncPrivateKeyMethod;
        }

        public void sign(long l2, int n2, byte[] byArray, ResultCallback<byte[]> resultCallback) {
            try {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l2);
                this.keyMethod.sign(referenceCountedOpenSslEngine, n2, byArray).addListener((GenericFutureListener)new ResultCallbackListener(referenceCountedOpenSslEngine, l2, resultCallback));
            }
            catch (SSLException sSLException) {
                resultCallback.onError(l2, (Throwable)sSLException);
            }
        }

        public void decrypt(long l2, byte[] byArray, ResultCallback<byte[]> resultCallback) {
            try {
                ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l2);
                this.keyMethod.decrypt(referenceCountedOpenSslEngine, byArray).addListener((GenericFutureListener)new ResultCallbackListener(referenceCountedOpenSslEngine, l2, resultCallback));
            }
            catch (SSLException sSLException) {
                resultCallback.onError(l2, (Throwable)sSLException);
            }
        }

        static final class ResultCallbackListener
        implements FutureListener<byte[]> {
            private final ReferenceCountedOpenSslEngine engine;
            private final long ssl;
            private final ResultCallback<byte[]> resultCallback;

            ResultCallbackListener(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, long l2, ResultCallback<byte[]> resultCallback) {
                this.engine = referenceCountedOpenSslEngine;
                this.ssl = l2;
                this.resultCallback = resultCallback;
            }

            public void operationComplete(Future<byte[]> future) {
                Throwable throwable = future.cause();
                if (throwable == null) {
                    try {
                        byte[] byArray = ReferenceCountedOpenSslContext.verifyResult((byte[])future.getNow());
                        this.resultCallback.onSuccess(this.ssl, (Object)byArray);
                        return;
                    }
                    catch (SignatureException signatureException) {
                        throwable = signatureException;
                        this.engine.initHandshakeException(signatureException);
                    }
                }
                this.resultCallback.onError(this.ssl, throwable);
            }
        }
    }

    static final class PrivateKeyMethod
    implements SSLPrivateKeyMethod {
        private final OpenSslEngineMap engineMap;
        private final OpenSslPrivateKeyMethod keyMethod;

        PrivateKeyMethod(OpenSslEngineMap openSslEngineMap, OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
            this.engineMap = openSslEngineMap;
            this.keyMethod = openSslPrivateKeyMethod;
        }

        public byte[] sign(long l2, int n2, byte[] byArray) throws Exception {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l2);
            try {
                return ReferenceCountedOpenSslContext.verifyResult(this.keyMethod.sign(referenceCountedOpenSslEngine, n2, byArray));
            }
            catch (Exception exception) {
                referenceCountedOpenSslEngine.initHandshakeException(exception);
                throw exception;
            }
        }

        public byte[] decrypt(long l2, byte[] byArray) throws Exception {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = ReferenceCountedOpenSslContext.retrieveEngine(this.engineMap, l2);
            try {
                return ReferenceCountedOpenSslContext.verifyResult(this.keyMethod.decrypt(referenceCountedOpenSslEngine, byArray));
            }
            catch (Exception exception) {
                referenceCountedOpenSslEngine.initHandshakeException(exception);
                throw exception;
            }
        }
    }

    static final class DefaultOpenSslEngineMap
    implements OpenSslEngineMap {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines = PlatformDependent.newConcurrentHashMap();

        private DefaultOpenSslEngineMap() {
        }

        @Override
        public ReferenceCountedOpenSslEngine remove(long l2) {
            return this.engines.remove(l2);
        }

        @Override
        public void add(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
            this.engines.put(referenceCountedOpenSslEngine.sslPointer(), referenceCountedOpenSslEngine);
        }

        @Override
        public ReferenceCountedOpenSslEngine get(long l2) {
            return this.engines.get(l2);
        }
    }

    static abstract class AbstractCertificateVerifier
    extends CertificateVerifier {
        private final OpenSslEngineMap engineMap;

        AbstractCertificateVerifier(OpenSslEngineMap openSslEngineMap) {
            this.engineMap = openSslEngineMap;
        }

        public final int verify(long l2, byte[][] byArray, String string) {
            ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l2);
            if (referenceCountedOpenSslEngine == null) {
                return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
            }
            X509Certificate[] x509CertificateArray = ReferenceCountedOpenSslContext.certificates(byArray);
            try {
                this.verify(referenceCountedOpenSslEngine, x509CertificateArray, string);
                return CertificateVerifier.X509_V_OK;
            }
            catch (Throwable throwable) {
                logger.debug("verification of certificate failed", throwable);
                referenceCountedOpenSslEngine.initHandshakeException(throwable);
                if (throwable instanceof OpenSslCertificateException) {
                    return ((OpenSslCertificateException)throwable).errorCode();
                }
                if (throwable instanceof CertificateExpiredException) {
                    return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
                }
                if (throwable instanceof CertificateNotYetValidException) {
                    return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
                }
                if (PlatformDependent.javaVersion() >= 7) {
                    return AbstractCertificateVerifier.translateToError(throwable);
                }
                return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
            }
        }

        private static int translateToError(Throwable throwable) {
            if (throwable instanceof CertificateRevokedException) {
                return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
            }
            for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                if (!(throwable2 instanceof CertPathValidatorException)) continue;
                CertPathValidatorException certPathValidatorException = (CertPathValidatorException)throwable2;
                CertPathValidatorException.Reason reason = certPathValidatorException.getReason();
                if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                    return CertificateVerifier.X509_V_ERR_CERT_HAS_EXPIRED;
                }
                if (reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                    return CertificateVerifier.X509_V_ERR_CERT_NOT_YET_VALID;
                }
                if (reason != CertPathValidatorException.BasicReason.REVOKED) continue;
                return CertificateVerifier.X509_V_ERR_CERT_REVOKED;
            }
            return CertificateVerifier.X509_V_ERR_UNSPECIFIED;
        }

        abstract void verify(ReferenceCountedOpenSslEngine var1, X509Certificate[] var2, String var3) throws Exception;
    }
}

