/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.DefaultOpenSslKeyMaterial;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslKeyMaterial;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.OpenSslPrivateKey;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.PemEncoded;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.PemX509Certificate;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.internal.tcnative.SSL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509KeyManager;

class OpenSslKeyMaterialProvider {
    private final X509KeyManager keyManager;
    private final String password;

    OpenSslKeyMaterialProvider(X509KeyManager x509KeyManager, String string) {
        this.keyManager = x509KeyManager;
        this.password = string;
    }

    static void validateKeyMaterialSupported(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) throws SSLException {
        OpenSslKeyMaterialProvider.validateSupported(x509CertificateArray);
        OpenSslKeyMaterialProvider.validateSupported(privateKey, string);
    }

    private static void validateSupported(PrivateKey privateKey, String string) throws SSLException {
        if (privateKey == null) {
            return;
        }
        long l2 = 0L;
        long l3 = 0L;
        try {
            l2 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, privateKey);
            l3 = SSL.parsePrivateKey((long)l2, (String)string);
        }
        catch (Exception exception) {
            throw new SSLException("PrivateKey type not supported " + privateKey.getFormat(), exception);
        }
        finally {
            SSL.freeBIO((long)l2);
            if (l3 != 0L) {
                SSL.freePrivateKey((long)l3);
            }
        }
    }

    private static void validateSupported(X509Certificate[] x509CertificateArray) throws SSLException {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return;
        }
        long l2 = 0L;
        long l3 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l2 = ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemEncoded.retain());
            l3 = SSL.parseX509Chain((long)l2);
        }
        catch (Exception exception) {
            throw new SSLException("Certificate type not supported", exception);
        }
        finally {
            SSL.freeBIO((long)l2);
            if (l3 != 0L) {
                SSL.freeX509Chain((long)l3);
            }
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    X509KeyManager keyManager() {
        return this.keyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator byteBufAllocator, String string) throws Exception {
        X509Certificate[] x509CertificateArray = this.keyManager.getCertificateChain(string);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return null;
        }
        PrivateKey privateKey = this.keyManager.getPrivateKey(string);
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        try {
            OpenSslKeyMaterial openSslKeyMaterial;
            l2 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            l4 = SSL.parseX509Chain((long)l2);
            if (privateKey instanceof OpenSslPrivateKey) {
                openSslKeyMaterial = ((OpenSslPrivateKey)privateKey).newKeyMaterial(l4, x509CertificateArray);
            } else {
                l3 = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, privateKey);
                l5 = privateKey == null ? 0L : SSL.parsePrivateKey((long)l3, (String)this.password);
                openSslKeyMaterial = new DefaultOpenSslKeyMaterial(l4, l5, x509CertificateArray);
            }
            l4 = 0L;
            l5 = 0L;
            OpenSslKeyMaterial openSslKeyMaterial2 = openSslKeyMaterial;
            return openSslKeyMaterial2;
        }
        finally {
            SSL.freeBIO((long)l2);
            SSL.freeBIO((long)l3);
            if (l4 != 0L) {
                SSL.freeX509Chain((long)l4);
            }
            if (l5 != 0L) {
                SSL.freePrivateKey((long)l5);
            }
            pemEncoded.release();
        }
    }

    void destroy() {
    }
}

