/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ApplicationProtocolConfig;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.CipherSuiteFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ClientAuth;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkDefaultApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkNpnApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslContext;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.SslUtils;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;

public class JdkSslContext
extends SslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkSslContext.class);
    static final String PROTOCOL = "TLS";
    private static final String[] DEFAULT_PROTOCOLS;
    private static final List<String> DEFAULT_CIPHERS;
    private static final List<String> DEFAULT_CIPHERS_NON_TLSV13;
    private static final Set<String> SUPPORTED_CIPHERS;
    private static final Set<String> SUPPORTED_CIPHERS_NON_TLSV13;
    private static final Provider DEFAULT_PROVIDER;
    private final String[] protocols;
    private final String[] cipherSuites;
    private final List<String> unmodifiableCipherSuites;
    private final JdkApplicationProtocolNegotiator apn;
    private final ClientAuth clientAuth;
    private final SSLContext sslContext;
    private final boolean isClient;

    private static String[] defaultProtocols(SSLContext sSLContext, SSLEngine sSLEngine) {
        String[] stringArray = sSLContext.getDefaultSSLParameters().getProtocols();
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        Collections.addAll(hashSet, stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(hashSet, arrayList, "TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1");
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
        }
        return sSLEngine.getEnabledProtocols();
    }

    private static Set<String> supportedCiphers(SSLEngine sSLEngine) {
        String[] stringArray = sSLEngine.getSupportedCipherSuites();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            linkedHashSet.add(string);
            if (!string.startsWith("SSL_")) continue;
            String string2 = "TLS_" + string.substring("SSL_".length());
            try {
                sSLEngine.setEnabledCipherSuites(new String[]{string2});
                linkedHashSet.add(string2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return linkedHashSet;
    }

    private static List<String> defaultCiphers(SSLEngine sSLEngine, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SslUtils.addIfSupported(set, arrayList, SslUtils.DEFAULT_CIPHER_SUITES);
        SslUtils.useFallbackCiphersIfDefaultIsEmpty(arrayList, sSLEngine.getEnabledCipherSuites());
        return arrayList;
    }

    private static boolean isTlsV13Supported(String[] stringArray) {
        for (String string : stringArray) {
            if (!"TLSv1.3".equals(string)) continue;
            return true;
        }
        return false;
    }

    public JdkSslContext(SSLContext sSLContext, boolean bl2, ClientAuth clientAuth) {
        this(sSLContext, bl2, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, JdkDefaultApplicationProtocolNegotiator.INSTANCE, clientAuth, null, false);
    }

    public JdkSslContext(SSLContext sSLContext, boolean bl2, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth) {
        this(sSLContext, bl2, iterable, cipherSuiteFilter, applicationProtocolConfig, clientAuth, null, false);
    }

    public JdkSslContext(SSLContext sSLContext, boolean bl2, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, ClientAuth clientAuth, String[] stringArray, boolean bl3) {
        this(sSLContext, bl2, iterable, cipherSuiteFilter, JdkSslContext.toNegotiator(applicationProtocolConfig, !bl2), clientAuth, stringArray == null ? null : (String[])stringArray.clone(), bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JdkSslContext(SSLContext sSLContext, boolean bl2, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, ClientAuth clientAuth, String[] stringArray, boolean bl3) {
        super(bl3);
        List<String> list;
        Set<String> set;
        this.apn = (JdkApplicationProtocolNegotiator)ObjectUtil.checkNotNull((Object)jdkApplicationProtocolNegotiator, (String)"apn");
        this.clientAuth = (ClientAuth)((Object)ObjectUtil.checkNotNull((Object)((Object)clientAuth), (String)"clientAuth"));
        this.sslContext = (SSLContext)ObjectUtil.checkNotNull((Object)sSLContext, (String)"sslContext");
        if (DEFAULT_PROVIDER.equals(sSLContext.getProvider())) {
            String[] stringArray2 = this.protocols = stringArray == null ? DEFAULT_PROTOCOLS : stringArray;
            if (JdkSslContext.isTlsV13Supported(this.protocols)) {
                set = SUPPORTED_CIPHERS;
                list = DEFAULT_CIPHERS;
            } else {
                set = SUPPORTED_CIPHERS_NON_TLSV13;
                list = DEFAULT_CIPHERS_NON_TLSV13;
            }
        } else {
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            try {
                this.protocols = stringArray == null ? JdkSslContext.defaultProtocols(sSLContext, sSLEngine) : stringArray;
                set = JdkSslContext.supportedCiphers(sSLEngine);
                list = JdkSslContext.defaultCiphers(sSLEngine, set);
                if (!JdkSslContext.isTlsV13Supported(this.protocols)) {
                    for (String string : SslUtils.DEFAULT_TLSV13_CIPHER_SUITES) {
                        set.remove(string);
                        list.remove(string);
                    }
                }
            }
            finally {
                ReferenceCountUtil.release((Object)sSLEngine);
            }
        }
        this.cipherSuites = ((CipherSuiteFilter)ObjectUtil.checkNotNull((Object)cipherSuiteFilter, (String)"cipherFilter")).filterCipherSuites(iterable, list, set);
        this.unmodifiableCipherSuites = Collections.unmodifiableList(Arrays.asList(this.cipherSuites));
        this.isClient = bl2;
    }

    public final SSLContext context() {
        return this.sslContext;
    }

    @Override
    public final boolean isClient() {
        return this.isClient;
    }

    @Override
    public final SSLSessionContext sessionContext() {
        if (this.isServer()) {
            return this.context().getServerSessionContext();
        }
        return this.context().getClientSessionContext();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCipherSuites;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.configureAndWrapEngine(this.context().createSSLEngine(), byteBufAllocator);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n2) {
        return this.configureAndWrapEngine(this.context().createSSLEngine(string, n2), byteBufAllocator);
    }

    private SSLEngine configureAndWrapEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator) {
        JdkApplicationProtocolNegotiator.SslEngineWrapperFactory sslEngineWrapperFactory;
        sSLEngine.setEnabledCipherSuites(this.cipherSuites);
        sSLEngine.setEnabledProtocols(this.protocols);
        sSLEngine.setUseClientMode(this.isClient());
        if (this.isServer()) {
            switch (this.clientAuth) {
                case OPTIONAL: {
                    sSLEngine.setWantClientAuth(true);
                    break;
                }
                case REQUIRE: {
                    sSLEngine.setNeedClientAuth(true);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                }
            }
        }
        if ((sslEngineWrapperFactory = this.apn.wrapperFactory()) instanceof JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory) {
            return ((JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory)sslEngineWrapperFactory).wrapSslEngine(sSLEngine, byteBufAllocator, this.apn, this.isServer());
        }
        return sslEngineWrapperFactory.wrapSslEngine(sSLEngine, this.apn, this.isServer());
    }

    @Override
    public final JdkApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig, boolean bl2) {
        if (applicationProtocolConfig == null) {
            return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return JdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (bl2) {
                    switch (applicationProtocolConfig.selectorFailureBehavior()) {
                        case FATAL_ALERT: {
                            return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                        case NO_ADVERTISE: {
                            return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
            }
            case NPN: {
                if (bl2) {
                    switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                        case ACCEPT: {
                            return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                        }
                        case FATAL_ALERT: {
                            return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                        }
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " failure behavior");
                }
                switch (applicationProtocolConfig.selectorFailureBehavior()) {
                    case FATAL_ALERT: {
                        return new JdkNpnApplicationProtocolNegotiator(true, applicationProtocolConfig.supportedProtocols());
                    }
                    case NO_ADVERTISE: {
                        return new JdkNpnApplicationProtocolNegotiator(false, applicationProtocolConfig.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + (Object)((Object)applicationProtocolConfig.protocol()) + " protocol");
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory, String string2) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, CertificateException, KeyException, IOException {
        String string3 = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (string3 == null) {
            string3 = "SunX509";
        }
        return JdkSslContext.buildKeyManagerFactory(file, string3, file2, string, keyManagerFactory, string2);
    }

    protected static KeyManagerFactory buildKeyManagerFactory(File file, File file2, String string, KeyManagerFactory keyManagerFactory) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, CertificateException, KeyException, IOException {
        return JdkSslContext.buildKeyManagerFactory(file, file2, string, keyManagerFactory, KeyStore.getDefaultType());
    }

    static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory, String string3) throws KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, IOException, CertificateException, KeyException, UnrecoverableKeyException {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, string3);
    }

    protected static KeyManagerFactory buildKeyManagerFactory(File file, String string, File file2, String string2, KeyManagerFactory keyManagerFactory) throws KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeySpecException, InvalidAlgorithmParameterException, IOException, CertificateException, KeyException, UnrecoverableKeyException {
        return JdkSslContext.buildKeyManagerFactory(JdkSslContext.toX509Certificates(file), string, JdkSslContext.toPrivateKey(file2, string2), string2, keyManagerFactory, KeyStore.getDefaultType());
    }

    static {
        Defaults defaults = new Defaults();
        defaults.init();
        DEFAULT_PROVIDER = defaults.defaultProvider;
        DEFAULT_PROTOCOLS = defaults.defaultProtocols;
        SUPPORTED_CIPHERS = defaults.supportedCiphers;
        DEFAULT_CIPHERS = defaults.defaultCiphers;
        DEFAULT_CIPHERS_NON_TLSV13 = defaults.defaultCiphersNonTLSv13;
        SUPPORTED_CIPHERS_NON_TLSV13 = defaults.supportedCiphersNonTLSv13;
        if (logger.isDebugEnabled()) {
            logger.debug("Default protocols (JDK): {} ", Arrays.asList(DEFAULT_PROTOCOLS));
            logger.debug("Default cipher suites (JDK): {}", DEFAULT_CIPHERS);
        }
    }

    static final class Defaults {
        String[] defaultProtocols;
        List<String> defaultCiphers;
        List<String> defaultCiphersNonTLSv13;
        Set<String> supportedCiphers;
        Set<String> supportedCiphersNonTLSv13;
        Provider defaultProvider;

        private Defaults() {
        }

        void init() {
            SSLContext sSLContext;
            try {
                sSLContext = SSLContext.getInstance(JdkSslContext.PROTOCOL);
                sSLContext.init(null, null, null);
            }
            catch (Exception exception) {
                throw new Error("failed to initialize the default SSL context", exception);
            }
            this.defaultProvider = sSLContext.getProvider();
            SSLEngine sSLEngine = sSLContext.createSSLEngine();
            this.defaultProtocols = JdkSslContext.defaultProtocols(sSLContext, sSLEngine);
            this.supportedCiphers = Collections.unmodifiableSet(JdkSslContext.supportedCiphers(sSLEngine));
            this.defaultCiphers = Collections.unmodifiableList(JdkSslContext.defaultCiphers(sSLEngine, this.supportedCiphers));
            ArrayList<String> arrayList = new ArrayList<String>(this.defaultCiphers);
            arrayList.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.defaultCiphersNonTLSv13 = Collections.unmodifiableList(arrayList);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.supportedCiphers);
            linkedHashSet.removeAll(Arrays.asList(SslUtils.DEFAULT_TLSV13_CIPHER_SUITES));
            this.supportedCiphersNonTLSv13 = Collections.unmodifiableSet(linkedHashSet);
        }
    }
}

