/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import XdepsXdatabricksX240X9088.io.netty.handler.ssl.BouncyCastle;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.BouncyCastleAlpnSslEngine;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.Conscrypt;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.ConscryptAlpnSslEngine;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkAlpnSslEngine;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkAlpnSslUtils;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JdkBaseApplicationProtocolNegotiator;
import XdepsXdatabricksX240X9088.io.netty.handler.ssl.JettyAlpnSslEngine;
import io.netty.buffer.ByteBufAllocator;
import javax.net.ssl.SSLEngine;

public final class JdkAlpnApplicationProtocolNegotiator
extends JdkBaseApplicationProtocolNegotiator {
    private static final boolean AVAILABLE = Conscrypt.isAvailable() || JdkAlpnSslUtils.supportsAlpn() || JettyAlpnSslEngine.isAvailable() || BouncyCastle.isAvailable();
    private static final JdkApplicationProtocolNegotiator.SslEngineWrapperFactory ALPN_WRAPPER = AVAILABLE ? new AlpnWrapper() : new FailureWrapper();

    public JdkAlpnApplicationProtocolNegotiator(Iterable<String> iterable) {
        this(false, iterable);
    }

    public JdkAlpnApplicationProtocolNegotiator(String ... stringArray) {
        this(false, stringArray);
    }

    public JdkAlpnApplicationProtocolNegotiator(boolean bl2, Iterable<String> iterable) {
        this(bl2, bl2, iterable);
    }

    public JdkAlpnApplicationProtocolNegotiator(boolean bl2, String ... stringArray) {
        this(bl2, bl2, stringArray);
    }

    public JdkAlpnApplicationProtocolNegotiator(boolean bl2, boolean bl3, Iterable<String> iterable) {
        this(bl3 ? FAIL_SELECTOR_FACTORY : NO_FAIL_SELECTOR_FACTORY, bl2 ? FAIL_SELECTION_LISTENER_FACTORY : NO_FAIL_SELECTION_LISTENER_FACTORY, iterable);
    }

    public JdkAlpnApplicationProtocolNegotiator(boolean bl2, boolean bl3, String ... stringArray) {
        this(bl3 ? FAIL_SELECTOR_FACTORY : NO_FAIL_SELECTOR_FACTORY, bl2 ? FAIL_SELECTION_LISTENER_FACTORY : NO_FAIL_SELECTION_LISTENER_FACTORY, stringArray);
    }

    public JdkAlpnApplicationProtocolNegotiator(JdkApplicationProtocolNegotiator.ProtocolSelectorFactory protocolSelectorFactory, JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory protocolSelectionListenerFactory, Iterable<String> iterable) {
        super(ALPN_WRAPPER, protocolSelectorFactory, protocolSelectionListenerFactory, iterable);
    }

    public JdkAlpnApplicationProtocolNegotiator(JdkApplicationProtocolNegotiator.ProtocolSelectorFactory protocolSelectorFactory, JdkApplicationProtocolNegotiator.ProtocolSelectionListenerFactory protocolSelectionListenerFactory, String ... stringArray) {
        super(ALPN_WRAPPER, protocolSelectorFactory, protocolSelectionListenerFactory, stringArray);
    }

    static boolean isAlpnSupported() {
        return AVAILABLE;
    }

    static final class AlpnWrapper
    extends JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory {
        private AlpnWrapper() {
        }

        @Override
        public SSLEngine wrapSslEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl2) {
            if (Conscrypt.isEngineSupported(sSLEngine)) {
                return bl2 ? ConscryptAlpnSslEngine.newServerEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator) : ConscryptAlpnSslEngine.newClientEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
            }
            if (BouncyCastle.isInUse(sSLEngine)) {
                return new BouncyCastleAlpnSslEngine(sSLEngine, jdkApplicationProtocolNegotiator, bl2);
            }
            if (JdkAlpnSslUtils.supportsAlpn()) {
                return new JdkAlpnSslEngine(sSLEngine, jdkApplicationProtocolNegotiator, bl2);
            }
            if (JettyAlpnSslEngine.isAvailable()) {
                return bl2 ? JettyAlpnSslEngine.newServerEngine(sSLEngine, jdkApplicationProtocolNegotiator) : JettyAlpnSslEngine.newClientEngine(sSLEngine, jdkApplicationProtocolNegotiator);
            }
            throw new UnsupportedOperationException("ALPN not supported. Unable to wrap SSLEngine of type '" + sSLEngine.getClass().getName() + "')");
        }
    }

    static final class FailureWrapper
    extends JdkApplicationProtocolNegotiator.AllocatorAwareSslEngineWrapperFactory {
        private FailureWrapper() {
        }

        @Override
        public SSLEngine wrapSslEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator, boolean bl2) {
            throw new RuntimeException("ALPN unsupported. Is your classpath configured correctly? For Conscrypt, add the appropriate Conscrypt JAR to classpath and set the security provider. For Jetty-ALPN, see https://www.eclipse.org/jetty/documentation/current/alpn-chapter.html#alpn-starting");
        }
    }
}

