/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ssl;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class EnhancingX509ExtendedTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager wrapped;

    EnhancingX509ExtendedTrustManager(X509TrustManager x509TrustManager) {
        this.wrapped = (X509ExtendedTrustManager)x509TrustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.wrapped.checkClientTrusted(x509CertificateArray, string, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(x509CertificateArray, string, socket);
        }
        catch (CertificateException certificateException) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(x509CertificateArray, certificateException);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.wrapped.checkClientTrusted(x509CertificateArray, string, sSLEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(x509CertificateArray, string, sSLEngine);
        }
        catch (CertificateException certificateException) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(x509CertificateArray, certificateException);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.wrapped.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            this.wrapped.checkServerTrusted(x509CertificateArray, string);
        }
        catch (CertificateException certificateException) {
            EnhancingX509ExtendedTrustManager.throwEnhancedCertificateException(x509CertificateArray, certificateException);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.wrapped.getAcceptedIssuers();
    }

    private static void throwEnhancedCertificateException(X509Certificate[] x509CertificateArray, CertificateException certificateException) throws CertificateException {
        String string = certificateException.getMessage();
        if (string != null && certificateException.getMessage().startsWith("No subject alternative DNS name matching")) {
            StringBuilder stringBuilder = new StringBuilder(64);
            for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
                X509Certificate x509Certificate = x509CertificateArray[i2];
                Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
                if (collection == null) continue;
                for (List<?> list : collection) {
                    if (list.size() < 2 || (Integer)list.get(0) != 2) continue;
                    stringBuilder.append((String)list.get(1)).append(",");
                }
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.setLength(stringBuilder.length() - 1);
                throw new CertificateException(string + " Subject alternative DNS names in the certificate chain of " + x509CertificateArray.length + " certificate(s): " + stringBuilder, certificateException);
            }
        }
        throw certificateException;
    }
}

