/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ipfilter;

import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.IpFilterRule;
import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SocketUtils;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public final class IpSubnetFilterRule
implements IpFilterRule,
Comparable<IpSubnetFilterRule> {
    private final IpFilterRule filterRule;
    private final String ipAddress;

    public IpSubnetFilterRule(String string, IpFilterRuleType ipFilterRuleType) {
        try {
            String[] stringArray = string.split("/");
            if (stringArray.length != 2) {
                throw new IllegalArgumentException("ipAddressWithCidr: " + string + " (expected: \"<ip-address>/<mask-size>\")");
            }
            this.ipAddress = stringArray[0];
            int n2 = Integer.parseInt(stringArray[1]);
            this.filterRule = IpSubnetFilterRule.selectFilterRule(SocketUtils.addressByName((String)this.ipAddress), n2, ipFilterRuleType);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("ipAddressWithCidr", unknownHostException);
        }
    }

    public IpSubnetFilterRule(String string, int n2, IpFilterRuleType ipFilterRuleType) {
        try {
            this.ipAddress = string;
            this.filterRule = IpSubnetFilterRule.selectFilterRule(SocketUtils.addressByName((String)string), n2, ipFilterRuleType);
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException("ipAddress", unknownHostException);
        }
    }

    public IpSubnetFilterRule(InetAddress inetAddress, int n2, IpFilterRuleType ipFilterRuleType) {
        this.ipAddress = inetAddress.getHostAddress();
        this.filterRule = IpSubnetFilterRule.selectFilterRule(inetAddress, n2, ipFilterRuleType);
    }

    private static IpFilterRule selectFilterRule(InetAddress inetAddress, int n2, IpFilterRuleType ipFilterRuleType) {
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"ipAddress");
        ObjectUtil.checkNotNull((Object)((Object)ipFilterRuleType), (String)"ruleType");
        if (inetAddress instanceof Inet4Address) {
            return new Ip4SubnetFilterRule((Inet4Address)inetAddress, n2, ipFilterRuleType);
        }
        if (inetAddress instanceof Inet6Address) {
            return new Ip6SubnetFilterRule((Inet6Address)inetAddress, n2, ipFilterRuleType);
        }
        throw new IllegalArgumentException("Only IPv4 and IPv6 addresses are supported");
    }

    @Override
    public boolean matches(InetSocketAddress inetSocketAddress) {
        return this.filterRule.matches(inetSocketAddress);
    }

    @Override
    public IpFilterRuleType ruleType() {
        return this.filterRule.ruleType();
    }

    String getIpAddress() {
        return this.ipAddress;
    }

    IpFilterRule getFilterRule() {
        return this.filterRule;
    }

    @Override
    public int compareTo(IpSubnetFilterRule ipSubnetFilterRule) {
        if (this.filterRule instanceof Ip4SubnetFilterRule) {
            return IpSubnetFilterRule.compareInt(((Ip4SubnetFilterRule)this.filterRule).networkAddress, ((Ip4SubnetFilterRule)ipSubnetFilterRule.filterRule).networkAddress);
        }
        return ((Ip6SubnetFilterRule)this.filterRule).networkAddress.compareTo(((Ip6SubnetFilterRule)ipSubnetFilterRule.filterRule).networkAddress);
    }

    @Override
    int compareTo(InetSocketAddress inetSocketAddress) {
        if (this.filterRule instanceof Ip4SubnetFilterRule) {
            Ip4SubnetFilterRule ip4SubnetFilterRule = (Ip4SubnetFilterRule)this.filterRule;
            return IpSubnetFilterRule.compareInt(ip4SubnetFilterRule.networkAddress, NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)inetSocketAddress.getAddress())) & ip4SubnetFilterRule.subnetMask);
        }
        Ip6SubnetFilterRule ip6SubnetFilterRule = (Ip6SubnetFilterRule)this.filterRule;
        return ip6SubnetFilterRule.networkAddress.compareTo(Ip6SubnetFilterRule.ipToInt((Inet6Address)inetSocketAddress.getAddress()).and(ip6SubnetFilterRule.networkAddress));
    }

    private static int compareInt(int n2, int n3) {
        return n2 < n3 ? -1 : (n2 == n3 ? 0 : 1);
    }

    static final class Ip6SubnetFilterRule
    implements IpFilterRule {
        private static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
        private final BigInteger networkAddress;
        private final BigInteger subnetMask;
        private final IpFilterRuleType ruleType;

        private Ip6SubnetFilterRule(Inet6Address inet6Address, int n2, IpFilterRuleType ipFilterRuleType) {
            if (n2 < 0 || n2 > 128) {
                throw new IllegalArgumentException(String.format("IPv6 requires the subnet prefix to be in range of [0,128]. The prefix was: %d", n2));
            }
            this.subnetMask = Ip6SubnetFilterRule.prefixToSubnetMask(n2);
            this.networkAddress = Ip6SubnetFilterRule.ipToInt(inet6Address).and(this.subnetMask);
            this.ruleType = ipFilterRuleType;
        }

        @Override
        public boolean matches(InetSocketAddress inetSocketAddress) {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress instanceof Inet6Address) {
                BigInteger bigInteger = Ip6SubnetFilterRule.ipToInt((Inet6Address)inetAddress);
                return bigInteger.and(this.subnetMask).equals(this.subnetMask) || bigInteger.and(this.subnetMask).equals(this.networkAddress);
            }
            return false;
        }

        @Override
        public IpFilterRuleType ruleType() {
            return this.ruleType;
        }

        private static BigInteger ipToInt(Inet6Address inet6Address) {
            byte[] byArray = inet6Address.getAddress();
            assert (byArray.length == 16);
            return new BigInteger(byArray);
        }

        private static BigInteger prefixToSubnetMask(int n2) {
            return MINUS_ONE.shiftLeft(128 - n2);
        }
    }

    static final class Ip4SubnetFilterRule
    implements IpFilterRule {
        private final int networkAddress;
        private final int subnetMask;
        private final IpFilterRuleType ruleType;

        private Ip4SubnetFilterRule(Inet4Address inet4Address, int n2, IpFilterRuleType ipFilterRuleType) {
            if (n2 < 0 || n2 > 32) {
                throw new IllegalArgumentException(String.format("IPv4 requires the subnet prefix to be in range of [0,32]. The prefix was: %d", n2));
            }
            this.subnetMask = Ip4SubnetFilterRule.prefixToSubnetMask(n2);
            this.networkAddress = NetUtil.ipv4AddressToInt((Inet4Address)inet4Address) & this.subnetMask;
            this.ruleType = ipFilterRuleType;
        }

        @Override
        public boolean matches(InetSocketAddress inetSocketAddress) {
            InetAddress inetAddress = inetSocketAddress.getAddress();
            if (inetAddress instanceof Inet4Address) {
                int n2 = NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)inetAddress));
                return (n2 & this.subnetMask) == this.networkAddress;
            }
            return false;
        }

        @Override
        public IpFilterRuleType ruleType() {
            return this.ruleType;
        }

        private static int prefixToSubnetMask(int n2) {
            return (int)(-1L << 32 - n2);
        }
    }
}

