/*
 * Decompiled with CFR 0.152.
 */
package XdepsXdatabricksX240X9088.io.netty.handler.ipfilter;

import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.AbstractRemoteAddressFilter;
import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.IpFilterRuleType;
import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.IpSubnetFilterRule;
import XdepsXdatabricksX240X9088.io.netty.handler.ipfilter.IpSubnetFilterRuleComparator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.internal.ObjectUtil;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IpSubnetFilter
extends AbstractRemoteAddressFilter<InetSocketAddress> {
    private final boolean acceptIfNotFound;
    private final List<IpSubnetFilterRule> ipv4Rules;
    private final List<IpSubnetFilterRule> ipv6Rules;
    private final IpFilterRuleType ipFilterRuleTypeIPv4;
    private final IpFilterRuleType ipFilterRuleTypeIPv6;

    public IpSubnetFilter(IpSubnetFilterRule ... ipSubnetFilterRuleArray) {
        this(true, Arrays.asList((Object[])ObjectUtil.checkNotNull((Object)ipSubnetFilterRuleArray, (String)"rules")));
    }

    public IpSubnetFilter(boolean bl2, IpSubnetFilterRule ... ipSubnetFilterRuleArray) {
        this(bl2, Arrays.asList((Object[])ObjectUtil.checkNotNull((Object)ipSubnetFilterRuleArray, (String)"rules")));
    }

    public IpSubnetFilter(List<IpSubnetFilterRule> list) {
        this(true, list);
    }

    public IpSubnetFilter(boolean bl2, List<IpSubnetFilterRule> list) {
        ObjectUtil.checkNotNull(list, (String)"rules");
        this.acceptIfNotFound = bl2;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        ArrayList<IpSubnetFilterRule> arrayList = new ArrayList<IpSubnetFilterRule>();
        ArrayList<IpSubnetFilterRule> arrayList2 = new ArrayList<IpSubnetFilterRule>();
        for (IpSubnetFilterRule ipSubnetFilterRule : list) {
            ObjectUtil.checkNotNull((Object)ipSubnetFilterRule, (String)"rule");
            if (ipSubnetFilterRule.getFilterRule() instanceof IpSubnetFilterRule.Ip4SubnetFilterRule) {
                arrayList.add(ipSubnetFilterRule);
                if (ipSubnetFilterRule.ruleType() == IpFilterRuleType.ACCEPT) {
                    ++n2;
                    continue;
                }
                ++n3;
                continue;
            }
            arrayList2.add(ipSubnetFilterRule);
            if (ipSubnetFilterRule.ruleType() == IpFilterRuleType.ACCEPT) {
                ++n4;
                continue;
            }
            ++n5;
        }
        this.ipFilterRuleTypeIPv4 = n2 == 0 && n3 > 0 ? IpFilterRuleType.REJECT : (n2 > 0 && n3 == 0 ? IpFilterRuleType.ACCEPT : null);
        this.ipFilterRuleTypeIPv6 = n4 == 0 && n5 > 0 ? IpFilterRuleType.REJECT : (n4 > 0 && n5 == 0 ? IpFilterRuleType.ACCEPT : null);
        this.ipv4Rules = IpSubnetFilter.sortAndFilter(arrayList);
        this.ipv6Rules = IpSubnetFilter.sortAndFilter(arrayList2);
    }

    @Override
    protected boolean accept(ChannelHandlerContext channelHandlerContext, InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.getAddress() instanceof Inet4Address) {
            int n2 = Collections.binarySearch(this.ipv4Rules, inetSocketAddress, IpSubnetFilterRuleComparator.INSTANCE);
            if (n2 >= 0) {
                if (this.ipFilterRuleTypeIPv4 == null) {
                    return this.ipv4Rules.get(n2).ruleType() == IpFilterRuleType.ACCEPT;
                }
                return this.ipFilterRuleTypeIPv4 == IpFilterRuleType.ACCEPT;
            }
        } else {
            int n3 = Collections.binarySearch(this.ipv6Rules, inetSocketAddress, IpSubnetFilterRuleComparator.INSTANCE);
            if (n3 >= 0) {
                if (this.ipFilterRuleTypeIPv6 == null) {
                    return this.ipv6Rules.get(n3).ruleType() == IpFilterRuleType.ACCEPT;
                }
                return this.ipFilterRuleTypeIPv6 == IpFilterRuleType.ACCEPT;
            }
        }
        return this.acceptIfNotFound;
    }

    private static List<IpSubnetFilterRule> sortAndFilter(List<IpSubnetFilterRule> list) {
        IpSubnetFilterRule ipSubnetFilterRule;
        Collections.sort(list);
        Iterator<IpSubnetFilterRule> iterator = list.iterator();
        ArrayList<IpSubnetFilterRule> arrayList = new ArrayList<IpSubnetFilterRule>();
        IpSubnetFilterRule ipSubnetFilterRule2 = ipSubnetFilterRule = iterator.hasNext() ? iterator.next() : null;
        if (ipSubnetFilterRule != null) {
            arrayList.add(ipSubnetFilterRule);
        }
        while (iterator.hasNext()) {
            IpSubnetFilterRule ipSubnetFilterRule3 = iterator.next();
            if (ipSubnetFilterRule.matches(new InetSocketAddress(ipSubnetFilterRule3.getIpAddress(), 1))) continue;
            arrayList.add(ipSubnetFilterRule3);
            ipSubnetFilterRule = ipSubnetFilterRule3;
        }
        return arrayList;
    }
}

