/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.DefaultRuntime;
import sqlj.runtime.ExecutionContext;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.ref.ProfileGroup;
import sqlj.runtime.util.SqljTrace;

public abstract class ConnectionContextImpl {
    private ExecutionContext m_execCtx = new ExecutionContext();
    private boolean m_closeRTStmtsNotDrivenByFinalizer = true;
    private ProfileGroup.ConnectedGroup m_connProfiles;
    private boolean m_isClosed = false;
    private Connection m_conn;

    protected ConnectionContextImpl(ProfileGroup profileGroup, Connection connection) throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl Constructor Called :" + this + " for Connection :" + connection);
        }
        if (connection == null) {
            RuntimeRefErrors.raise_NULL_CONNECTION();
        }
        this.m_conn = connection;
        this.m_connProfiles = profileGroup.addConnection(connection);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string) throws SQLException {
        this(profileGroup, DefaultRuntime.getConnect(string));
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, String string2, String string3) throws SQLException {
        this(profileGroup, DefaultRuntime.getConnect(string, string2, string3));
    }

    protected static Map loadTypeMap(Class clazz, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        String string2 = null;
        ResourceBundle resourceBundle = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            resourceBundle = null;
            resourceBundle = ResourceBundle.getBundle(string2);
            if (resourceBundle == null) continue;
            Enumeration<String> enumeration = resourceBundle.getKeys();
            String string3 = null;
            String string4 = null;
            while (enumeration.hasMoreElements()) {
                string3 = enumeration.nextElement();
                string4 = resourceBundle.getString(string3);
                hashtable.put(string3, string4);
            }
        }
        return hashtable;
    }

    private ConnectionContextImpl(ProfileGroup profileGroup, Connection connection, boolean bl2) throws SQLException {
        this(profileGroup, ConnectionContextImpl.initAutoCommit(connection, bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection initAutoCommit(Connection connection, boolean bl2) throws SQLException {
        try {
            connection.setAutoCommit(bl2);
        }
        catch (SQLException sQLException) {
            try {
                connection.close();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            finally {
                throw sQLException;
            }
        }
        return connection;
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, String string2, String string3, boolean bl2) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string, string2, string3), bl2);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, Properties properties, boolean bl2) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string, properties), bl2);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, String string, boolean bl2) throws SQLException {
        this(profileGroup, DriverManager.getConnection(string), bl2);
    }

    protected ConnectionContextImpl(ProfileGroup profileGroup, ConnectionContext connectionContext) throws SQLException {
        this(profileGroup, connectionContext.getConnection());
    }

    public ConnectedProfile getConnectedProfile(Object object) throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl.getConnectedProfile() is called ");
        }
        ConnectedProfile connectedProfile = this.m_connProfiles.getProfile(object);
        return connectedProfile;
    }

    public void close() throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl.close called :" + this);
        }
        this.close(true);
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl2) throws SQLException {
        if (SqljTrace.isContextTraceOn()) {
            SqljTrace.printMessage("ConnectionContextImpl.close() is called :" + this);
        }
        this.m_isClosed = true;
        try {
            this.m_connProfiles.setCloseRTStmtsNotDrivenByFinalizer(this.m_closeRTStmtsNotDrivenByFinalizer);
            this.m_connProfiles.close();
        }
        finally {
            if (bl2) {
                this.m_conn.close();
            }
        }
    }

    public ExecutionContext getExecutionContext() {
        return this.m_execCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        block3: {
            try {
                super.finalize();
                Object var2_1 = null;
                if (this.m_isClosed) break block3;
                this.m_closeRTStmtsNotDrivenByFinalizer = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (!this.m_isClosed) {
                    this.m_closeRTStmtsNotDrivenByFinalizer = false;
                    this.close(false);
                }
                throw throwable;
            }
            this.close(false);
            {
            }
        }
    }

    public Map getTypeMap() {
        return null;
    }
}

