/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.SQLNullException;
import sqlj.runtime.Scrollable;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.ref.RTStatementJDBCBase;

public class RTResultSetJDBC
implements RTResultSet,
Scrollable {
    protected ResultSet rs;
    private boolean m_isClosed = false;
    private boolean m_isValidRow = false;
    private RTStatementJDBCBase m_parent = null;

    public RTResultSetJDBC(ResultSet resultSet) {
        this.rs = resultSet;
    }

    RTResultSetJDBC(ResultSet resultSet, RTStatementJDBCBase rTStatementJDBCBase) {
        this.rs = resultSet;
        this.m_parent = rTStatementJDBCBase;
    }

    public ResultSet getJDBCResultSet() {
        return this.rs;
    }

    public boolean next() throws SQLException {
        this.m_isValidRow = this.rs.next();
        return this.m_isValidRow;
    }

    public String getCursorName() throws SQLException {
        return this.rs.getCursorName();
    }

    public int findColumn(String string) throws SQLException {
        return this.rs.findColumn(string);
    }

    public String getString(int n2) throws SQLException {
        return this.rs.getString(n2);
    }

    public byte[] getBytes(int n2) throws SQLException {
        return this.rs.getBytes(n2);
    }

    public Date getDate(int n2) throws SQLException {
        return this.rs.getDate(n2);
    }

    public Time getTime(int n2) throws SQLException {
        return this.rs.getTime(n2);
    }

    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.rs.getTimestamp(n2);
    }

    public boolean getBooleanNoNull(int n2) throws SQLException {
        boolean bl2 = this.rs.getBoolean(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return bl2;
    }

    public byte getByteNoNull(int n2) throws SQLException {
        byte by = this.rs.getByte(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return by;
    }

    public short getShortNoNull(int n2) throws SQLException {
        short s2 = this.rs.getShort(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return s2;
    }

    public int getIntNoNull(int n2) throws SQLException {
        int n3 = this.rs.getInt(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return n3;
    }

    public long getLongNoNull(int n2) throws SQLException {
        long l2 = this.rs.getLong(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return l2;
    }

    public float getFloatNoNull(int n2) throws SQLException {
        float f2 = this.rs.getFloat(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return f2;
    }

    public double getDoubleNoNull(int n2) throws SQLException {
        double d2 = this.rs.getDouble(n2);
        if (this.rs.wasNull()) {
            throw new SQLNullException();
        }
        return d2;
    }

    public Boolean getBooleanWrapper(int n2) throws SQLException {
        boolean bl2 = this.rs.getBoolean(n2);
        return this.rs.wasNull() ? null : new Boolean(bl2);
    }

    public Byte getByteWrapper(int n2) throws SQLException {
        byte by = this.rs.getByte(n2);
        return this.rs.wasNull() ? null : new Byte(by);
    }

    public Short getShortWrapper(int n2) throws SQLException {
        short s2 = this.rs.getShort(n2);
        return this.rs.wasNull() ? null : new Short(s2);
    }

    public Integer getIntWrapper(int n2) throws SQLException {
        int n3 = this.rs.getInt(n2);
        return this.rs.wasNull() ? null : new Integer(n3);
    }

    public Long getLongWrapper(int n2) throws SQLException {
        long l2 = this.rs.getLong(n2);
        return this.rs.wasNull() ? null : new Long(l2);
    }

    public Float getFloatWrapper(int n2) throws SQLException {
        float f2 = this.rs.getFloat(n2);
        return this.rs.wasNull() ? null : new Float(f2);
    }

    public Double getDoubleWrapper(int n2) throws SQLException {
        double d2 = this.rs.getDouble(n2);
        return this.rs.wasNull() ? null : new Double(d2);
    }

    public AsciiStream getAsciiStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getAsciiStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new AsciiStream(inputStream);
    }

    public CharacterStream getCharacterStreamWrapper(int n2) throws SQLException {
        Reader reader = this.rs.getCharacterStream(n2);
        return reader == null || this.rs.wasNull() ? null : new CharacterStream(reader);
    }

    public BinaryStream getBinaryStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getBinaryStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new BinaryStream(inputStream);
    }

    public UnicodeStream getUnicodeStreamWrapper(int n2) throws SQLException {
        InputStream inputStream = this.rs.getUnicodeStream(n2);
        return inputStream == null || this.rs.wasNull() ? null : new UnicodeStream(inputStream);
    }

    public Object getObject(int n2, Class clazz) throws SQLException {
        Object object = this.rs.getObject(n2);
        if (object == null) {
            return object;
        }
        if (!clazz.isAssignableFrom(object.getClass())) {
            ProfileRefErrors.raise_INCOMPATIBLE_TYPE(clazz, object.getClass());
        }
        return object;
    }

    public BigDecimal getBigDecimal(int n2) throws SQLException {
        return this.rs.getBigDecimal(n2);
    }

    public int getColumnCount() throws SQLException {
        return this.rs.getMetaData().getColumnCount();
    }

    public boolean isValidRow() throws SQLException {
        return this.m_isValidRow;
    }

    public boolean isClosed() throws SQLException {
        return this.m_isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws SQLException {
        if (this.m_isClosed) return;
        try {
            this.m_isClosed = true;
            this.rs.close();
            Object var2_1 = null;
            if (this.m_parent == null) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.m_parent == null) throw throwable;
            this.m_parent.notifyClosed(this);
            throw throwable;
        }
        this.m_parent.notifyClosed(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.rs.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.rs.clearWarnings();
    }

    public int getFetchSize() throws SQLException {
        return this.rs.getFetchSize();
    }

    public void setFetchSize(int n2) throws SQLException {
        this.rs.setFetchSize(n2);
    }

    public Blob getBlob(int n2) throws SQLException {
        return this.rs.getBlob(n2);
    }

    public Clob getClob(int n2) throws SQLException {
        return this.rs.getClob(n2);
    }

    public Ref getRef(int n2) throws SQLException {
        return this.rs.getRef(n2);
    }

    public boolean absolute(int n2) throws SQLException {
        return this.rs.absolute(n2);
    }

    public void afterLast() throws SQLException {
        this.rs.afterLast();
    }

    public void beforeFirst() throws SQLException {
        this.rs.beforeFirst();
    }

    public boolean first() throws SQLException {
        return this.rs.first();
    }

    public boolean isAfterLast() throws SQLException {
        return this.rs.isAfterLast();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.rs.isBeforeFirst();
    }

    public boolean isFirst() throws SQLException {
        return this.rs.isFirst();
    }

    public boolean isLast() throws SQLException {
        return this.rs.isLast();
    }

    public boolean last() throws SQLException {
        return this.rs.last();
    }

    public boolean previous() throws SQLException {
        return this.rs.previous();
    }

    public boolean relative(int n2) throws SQLException {
        return this.rs.relative(n2);
    }

    public void setFetchDirection(int n2) throws SQLException {
        this.rs.setFetchDirection(n2);
    }

    public int getFetchDirection() throws SQLException {
        return this.rs.getFetchDirection();
    }
}

