/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Arrays;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONObject;
import net.sf.json.JSONUtils;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Serializer;
import nu.xom.Text;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLSerializer {
    private static final Log log = LogFactory.getLog(class$net$sf$json$xml$XMLSerializer == null ? (class$net$sf$json$xml$XMLSerializer = XMLSerializer.class$("net.sf.json.xml.XMLSerializer")) : class$net$sf$json$xml$XMLSerializer);
    static /* synthetic */ Class class$net$sf$json$xml$XMLSerializer;

    public static JSONArray readArray(String xml) {
        JSONArray jsonArray = null;
        try {
            Document doc = new Builder().build(new StringReader(xml));
            Element root = doc.getRootElement();
            String defaultType = XMLSerializer.getType(root, "string");
            jsonArray = XMLSerializer.processArrayElement(root, defaultType);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return jsonArray;
    }

    public static JSONObject readObject(String xml) {
        JSONObject jsonObject = null;
        try {
            Document doc = new Builder().build(new StringReader(xml));
            Element root = doc.getRootElement();
            String defaultType = XMLSerializer.getType(root, "string");
            jsonObject = XMLSerializer.processObjectElement(root, defaultType);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return jsonObject;
    }

    public static String write(JSONArray jsonArray) {
        Object[] array = jsonArray.toArray();
        Element root = XMLSerializer.processJSONArray(new Element("a"), array);
        Document doc = new Document(root);
        return XMLSerializer.writeDocument(doc);
    }

    public static String write(JSONObject jsonObject) {
        Element root = null;
        if (jsonObject.isNullObject()) {
            root = new Element("o");
            root.addAttribute(new Attribute("null", "true"));
        } else {
            root = XMLSerializer.processJSONObject(jsonObject, new Element("o"));
        }
        Document doc = new Document(root);
        return XMLSerializer.writeDocument(doc);
    }

    private static String getClass(Element element) {
        Attribute attribute = element.getAttribute("class");
        String clazz = null;
        if (attribute != null) {
            String clazzText = attribute.getValue().trim();
            if ("object".compareToIgnoreCase(clazzText) == 0) {
                clazz = "object";
            } else if ("array".compareToIgnoreCase(clazzText) == 0) {
                clazz = "array";
            }
        }
        return clazz;
    }

    private static String getType(Element element) {
        return XMLSerializer.getType(element, null);
    }

    private static String getType(Element element, String defaultType) {
        Attribute attribute = element.getAttribute("type");
        String type = null;
        if (attribute != null) {
            String typeText = attribute.getValue().trim();
            if ("boolean".compareToIgnoreCase(typeText) == 0) {
                type = "boolean";
            } else if ("number".compareToIgnoreCase(typeText) == 0) {
                type = "number";
            } else if ("integer".compareToIgnoreCase(typeText) == 0) {
                type = "integer";
            } else if ("float".compareToIgnoreCase(typeText) == 0) {
                type = "float";
            } else if ("object".compareToIgnoreCase(typeText) == 0) {
                type = "object";
            } else if ("array".compareToIgnoreCase(typeText) == 0) {
                type = "array";
            } else if ("string".compareToIgnoreCase(typeText) == 0) {
                type = "string";
            } else if ("function".compareToIgnoreCase(typeText) == 0) {
                type = "function";
            }
        } else if (defaultType != null) {
            log.info("Using default type " + defaultType);
            type = defaultType;
        }
        return type;
    }

    private static JSONArray processArrayElement(Element element, String defaultType) {
        JSONArray jsonArray = new JSONArray();
        Elements elements = element.getChildElements();
        int max = elements.size();
        for (int i = 0; i < max; ++i) {
            XMLSerializer.set(jsonArray, elements.get(i), defaultType);
        }
        return jsonArray;
    }

    private static Element processJSONArray(Element root, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Element element = new Element("e");
            Object el = array[i];
            if (JSONUtils.isBoolean(el)) {
                element.addAttribute(new Attribute("type", "boolean"));
                element.appendChild(el.toString());
            } else if (JSONUtils.isNumber(el)) {
                element.addAttribute(new Attribute("type", "number"));
                element.appendChild(el.toString());
            } else if (JSONUtils.isFunction(el)) {
                JSONFunction func = (JSONFunction)el;
                element.addAttribute(new Attribute("type", "function"));
                String params = Arrays.toString(func.getParams());
                params = params.substring(1);
                params = params.substring(0, params.length() - 1);
                element.addAttribute(new Attribute("params", params));
                element.appendChild(new Text("<![CDATA[" + func.getText() + "]]>"));
            } else if (JSONUtils.isString(el)) {
                element.addAttribute(new Attribute("type", "string"));
                element.appendChild(el.toString());
            } else if (el instanceof JSONArray) {
                element.addAttribute(new Attribute("class", "array"));
                element = XMLSerializer.processJSONArray(element, ((JSONArray)el).toArray());
            } else if (el instanceof JSONObject) {
                element.addAttribute(new Attribute("class", "object"));
                element = XMLSerializer.processJSONObject((JSONObject)el, element);
            } else if (JSONUtils.isNull(el)) {
                element.addAttribute(new Attribute("class", "object"));
                element.addAttribute(new Attribute("null", "true"));
            }
            root.appendChild(element);
        }
        return root;
    }

    private static Element processJSONObject(JSONObject jsonObject, Element root) {
        if (jsonObject.isNullObject()) {
            root.addAttribute(new Attribute("null", "true"));
            return root;
        }
        if (jsonObject.isEmpty()) {
            return root;
        }
        Object[] names = jsonObject.names().toArray();
        for (int i = 0; i < names.length; ++i) {
            String name = (String)names[i];
            Object el = jsonObject.get(name);
            Element element = new Element(name);
            if (JSONUtils.isBoolean(el)) {
                element.addAttribute(new Attribute("type", "boolean"));
                element.appendChild(el.toString());
            } else if (JSONUtils.isNumber(el)) {
                element.addAttribute(new Attribute("type", "number"));
                element.appendChild(el.toString());
            } else if (JSONUtils.isFunction(el)) {
                JSONFunction func = (JSONFunction)el;
                element.addAttribute(new Attribute("type", "function"));
                String params = Arrays.toString(func.getParams());
                params = params.substring(1);
                params = params.substring(0, params.length() - 1);
                element.addAttribute(new Attribute("params", params));
                element.appendChild(new Text("<![CDATA[" + func.getText() + "]]>"));
            } else if (JSONUtils.isString(el)) {
                element.addAttribute(new Attribute("type", "string"));
                element.appendChild(el.toString());
            } else if (el instanceof JSONArray) {
                element.addAttribute(new Attribute("class", "array"));
                element = XMLSerializer.processJSONArray(element, ((JSONArray)el).toArray());
            } else if (el instanceof JSONObject) {
                element.addAttribute(new Attribute("class", "object"));
                element = XMLSerializer.processJSONObject((JSONObject)el, element);
            } else if (JSONUtils.isNull(el)) {
                element.addAttribute(new Attribute("class", "object"));
                element.addAttribute(new Attribute("null", "true"));
            }
            root.appendChild(element);
        }
        return root;
    }

    private static JSONObject processObjectElement(Element element, String defaultType) {
        Attribute nullAttribute = element.getAttribute("null");
        if (nullAttribute != null && nullAttribute.getValue().compareToIgnoreCase("true") == 0) {
            return new JSONObject(true);
        }
        JSONObject jsonObject = new JSONObject();
        Elements elements = element.getChildElements();
        int max = elements.size();
        for (int i = 0; i < max; ++i) {
            XMLSerializer.set(jsonObject, elements.get(i), defaultType);
        }
        return jsonObject;
    }

    private static void set(JSONArray jsonArray, Element element, String defaultType) {
        String clazz = XMLSerializer.getClass(element);
        String type = XMLSerializer.getType(element);
        type = type == null ? defaultType : type;
        boolean classProcessed = false;
        if (clazz != null) {
            if (clazz.compareToIgnoreCase("array") == 0) {
                jsonArray.put(XMLSerializer.processArrayElement(element, type));
                classProcessed = true;
            } else if (clazz.compareToIgnoreCase("object") == 0) {
                jsonArray.put(XMLSerializer.processObjectElement(element, type));
                classProcessed = true;
            }
        }
        if (!classProcessed) {
            if (type.compareToIgnoreCase("boolean") == 0) {
                jsonArray.put(Boolean.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("number") == 0) {
                try {
                    jsonArray.put(Integer.valueOf(element.getValue()));
                }
                catch (NumberFormatException e) {
                    jsonArray.put(Double.valueOf(element.getValue()));
                }
            } else if (type.compareToIgnoreCase("integer") == 0) {
                jsonArray.put(Integer.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("float") == 0) {
                jsonArray.put(Double.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("string") == 0) {
                jsonArray.put(element.getValue());
            } else if (type.compareToIgnoreCase("function") == 0) {
                String[] params = null;
                String text = element.getValue();
                Attribute paramsAttribute = element.getAttribute("params");
                if (paramsAttribute != null) {
                    params = paramsAttribute.getValue().split(",");
                }
                jsonArray.put(new JSONFunction(params, text));
            }
        }
    }

    private static void set(JSONObject jsonObject, Element element, String defaultType) {
        String clazz = XMLSerializer.getClass(element);
        String type = XMLSerializer.getType(element);
        type = type == null ? defaultType : type;
        boolean classProcessed = false;
        if (clazz != null) {
            if (clazz.compareToIgnoreCase("array") == 0) {
                jsonObject.put(element.getLocalName(), XMLSerializer.processArrayElement(element, type));
                classProcessed = true;
            } else if (clazz.compareToIgnoreCase("object") == 0) {
                jsonObject.put(element.getLocalName(), XMLSerializer.processObjectElement(element, type));
                classProcessed = true;
            }
        }
        if (!classProcessed) {
            if (type.compareToIgnoreCase("boolean") == 0) {
                jsonObject.put(element.getLocalName(), Boolean.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("number") == 0) {
                try {
                    jsonObject.put(element.getLocalName(), Integer.valueOf(element.getValue()));
                }
                catch (NumberFormatException e) {
                    jsonObject.put(element.getLocalName(), Double.valueOf(element.getValue()));
                }
            } else if (type.compareToIgnoreCase("integer") == 0) {
                jsonObject.put(element.getLocalName(), Integer.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("float") == 0) {
                jsonObject.put(element.getLocalName(), Double.valueOf(element.getValue()));
            } else if (type.compareToIgnoreCase("function") == 0) {
                String[] params = null;
                String text = element.getValue();
                Attribute paramsAttribute = element.getAttribute("params");
                if (paramsAttribute != null) {
                    params = paramsAttribute.getValue().split(",");
                }
                jsonObject.put(element.getLocalName(), new JSONFunction(params, text));
            } else if (type.compareToIgnoreCase("string") == 0) {
                Attribute paramsAttribute = element.getAttribute("params");
                if (paramsAttribute != null) {
                    String[] params = null;
                    String text = element.getValue();
                    params = paramsAttribute.getValue().split(",");
                    jsonObject.put(element.getLocalName(), new JSONFunction(params, text));
                } else {
                    jsonObject.put(element.getLocalName(), element.getValue());
                }
            }
        }
    }

    private static String writeDocument(Document doc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XomSerializer serializer = new XomSerializer(baos);
        try {
            serializer.write(doc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class XomSerializer
    extends Serializer {
        public XomSerializer(OutputStream out) {
            super(out);
        }

        protected void write(Text text) throws IOException {
            String value = text.getValue();
            if (value.startsWith("<![CDATA[") && value.endsWith("]]>")) {
                value = value.substring(9);
                value = value.substring(0, value.length() - 3);
                this.writeRaw("<![CDATA[");
                this.writeRaw(value);
                this.writeRaw("]]>");
            } else {
                super.write(text);
            }
        }
    }
}

