/*
 * Decompiled with CFR 0.152.
 */
package com.jsontocsv.writer;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CSVWriter {
    public void writeAsCSV(List<LinkedHashMap<String, String>> flatJson, String fileName) throws FileNotFoundException {
        Set<String> headers = this.collectHeaders(flatJson);
        String output = String.valueOf(StringUtils.join(headers.toArray(), ",")) + "\n";
        for (LinkedHashMap<String, String> map : flatJson) {
            output = String.valueOf(output) + this.getCommaSeperatedRow(headers, map) + "\n";
        }
        this.writeToFile(output, fileName);
    }

    private void writeToFile(String output, String fileName) throws FileNotFoundException {
        block5: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(fileName));
                    writer.write(output);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.close(writer);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
            this.close(writer);
        }
    }

    private void close(BufferedWriter writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getCommaSeperatedRow(Set<String> headers, LinkedHashMap<String, String> map) {
        ArrayList<String> items = new ArrayList<String>();
        for (String header : headers) {
            String value = map.get(header) == null ? "" : map.get(header).replace(",", "");
            items.add("\"" + value + "\"");
        }
        return StringUtils.join(items.toArray(), ",");
    }

    private Set<String> collectHeaders(List<LinkedHashMap<String, String>> flatJson) {
        LinkedHashSet<String> headers = new LinkedHashSet<String>();
        for (LinkedHashMap<String, String> map : flatJson) {
            headers.addAll(map.keySet());
        }
        return headers;
    }
}

