/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.Action.CustomFunctionAction;
import com.dvsum.workflow.model.Action.JdbcAction;
import com.dvsum.workflow.model.Ref.RefActionType;
import com.dvsum.workflow.model.Ref.RefExecutionState;
import com.dvsum.workflow.model.Ref.RefStateType;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.StateMachine;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.LogHandler;
import com.dvsum.workflow.service.MacAddressExtractor;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class WorkflowExecutionService {
    private static final CustomLogger logger = CustomLogger.getLogger(WorkflowExecutionService.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Value(value="${python.code.execution.api}")
    private String pythonCodeExecutionApi;
    @Value(value="${get.workflow_state.url.api}")
    private String workflowStateGetUrlApi;

    public void startExecution(JSONObject workflowJson) {
        try {
            logger.info("Starting execution.....");
            if (this.isOldWorkflow(workflowJson)) {
                String errorMessage = "Old workflows are not supported on gateways running version 1.3.0 or newer.";
                LogHandler.sendInvalidWFLogMessageToUI(workflowJson, errorMessage);
                logger.error(errorMessage);
                return;
            }
            Workflow workflow = JsonObjectMapperUtil.getObjectFromJsonObject(workflowJson, Workflow.class);
            this.executeStateMachine(workflow, null);
        }
        catch (Exception e) {
            logger.error("Error while executing workflow. Error : ", e.getMessage());
            e.printStackTrace();
        }
    }

    public void resumeExecution(JSONObject webhookPayload) {
        try {
            Workflow workflow = Workflow.loadWorkflowState((JSONObject)webhookPayload.get((Object)"dvsum_metadata"), this.workflowStateGetUrlApi);
            if (!RefExecutionState.isCompletedOrErroredorResumed(workflow.getStateMachine().getCurrentExecutionState())) {
                workflow.getStateMachine().setCurrentExecutionState("RESUMED");
                workflow.saveWorkflowState();
                this.executeStateMachine(workflow, webhookPayload);
            }
        }
        catch (Exception e) {
            logger.error("Error while resuming workflow. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isOldWorkflow(JSONObject workflowJson) {
        if (workflowJson == null) {
            return false;
        }
        JSONObject stateMachine = (JSONObject)workflowJson.get((Object)"state_machine");
        Object states = stateMachine.get((Object)"states");
        return states instanceof JSONObject;
    }

    public String getMacAddress(Workflow workflow, JSONObject webhookPayload) {
        String macAddress;
        block5: {
            macAddress = null;
            if (webhookPayload != null) {
                try {
                    macAddress = MacAddressExtractor.extractMacAddress(workflow, (Map<String, Object>)webhookPayload);
                    if (Util.isNotNullOrEmpty(macAddress)) {
                        webhookPayload.put((Object)"detected_mac_address", (Object)macAddress.trim());
                        break block5;
                    }
                    System.out.println("Detected mac address is null or empty.");
                }
                catch (Exception e) {
                    logger.info("Error while getting mac address. Error: ", e.getMessage());
                    LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), e.getMessage(), true, 500);
                    workflow.getStateMachine().setCurrentExecutionState("ERRORED");
                    workflow.failAllStates();
                    workflow.saveWorkflowState();
                }
            } else {
                logger.info("Unable to get MAC Address because webhook payload is null or empty.");
            }
        }
        return macAddress;
    }

    public void executeStateMachine(Workflow workflow, JSONObject webhookPayload) {
        try {
            StateMachine stateMachine = workflow.getStateMachine();
            String nextState = stateMachine.getStartState();
            String END_STATE = "END";
            logger.info("Executing State Machine :", stateMachine.getStateMachineName());
            while (!nextState.equalsIgnoreCase(END_STATE)) {
                State currentState = stateMachine.findState(nextState);
                if (RefExecutionState.isCompleted(currentState.getCurrentExecutionState()) || RefExecutionState.isErrored(currentState.getCurrentExecutionState())) {
                    logger.info("State is not valid to be executed. State's status is ", currentState.getCurrentExecutionState(), " and ID is : ", currentState.getId());
                    nextState = currentState.getNextState();
                    continue;
                }
                logger.info("Executing State :", currentState.getId());
                if (RefStateType.isTask(currentState.getStateType())) {
                    if (this.performStateActions(workflow, currentState, webhookPayload)) {
                        logger.info("Stopping execution...");
                        break;
                    }
                } else {
                    logger.info("Invalid State type. State type :", currentState.getStateType());
                }
                nextState = currentState.getNextState();
                logger.info("Next state :", nextState);
                if (!nextState.equalsIgnoreCase(END_STATE)) continue;
                if (!RefExecutionState.isPending(currentState.getCurrentExecutionState())) {
                    stateMachine.setCurrentExecutionState("COMPLETED");
                }
                workflow.generateResponses();
                workflow.getWorkflowDataStore().clearOutputs();
                workflow.uploadWorkflowStateJson();
                workflow.uploadResponseFiles();
            }
        }
        catch (Exception e) {
            logger.error("Error while executing state machine. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean performStateActions(Workflow workflow, State state, JSONObject webhookPayload) {
        ExecutorService executor = Executors.newFixedThreadPool(state.getActions().size());
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (Action action : state.getActions()) {
            logger.info("Working on Action ", action.getId());
            logger.info(action.getActionType());
            Callable<Boolean> task = () -> {
                SourceConfig sourceConfig = workflow.findSourceConfig(action.getSourceId());
                if (RefActionType.isWebhook(action.getActionType()) && RefExecutionState.isPending(action.getCurrentExecutionState())) {
                    boolean stopExecution = action.saveActionResults(workflow, state, webhookPayload.toJSONString(), this.workflowStateGetUrlApi);
                    workflow.saveWorkflowState();
                    if (stopExecution) {
                        return true;
                    }
                } else if (RefExecutionState.isNotStarted(action.getCurrentExecutionState())) {
                    LogHandler.sendActionStartLogToUI(workflow, state, action);
                    String response = this.performTaskStateAction(workflow, state, action, sourceConfig, webhookPayload);
                    if (action.saveActionResults(workflow, state, response, this.workflowStateGetUrlApi)) {
                        workflow.saveWorkflowState();
                        return true;
                    }
                }
                workflow.saveWorkflowState();
                return this.shouldStopExecution(action);
            };
            futures.add(executor.submit(task));
        }
        executor.shutdown();
        for (Future future : futures) {
            try {
                if (!((Boolean)future.get()).booleanValue()) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public boolean shouldStopExecution(Action action) {
        return RefActionType.isWebhook(action.getActionType()) && RefExecutionState.isPending(action.getCurrentExecutionState());
    }

    public String performTaskStateAction(Workflow workflow, State state, Action action, SourceConfig sourceConfig, JSONObject webhookPayload) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String response = "";
        Callable<String> task = () -> {
            try {
                if (RefActionType.isCustomFunction(action.getActionType())) {
                    ((CustomFunctionAction)action).setPythonCodeExecutionApiUrl(this.pythonCodeExecutionApi);
                } else if (RefActionType.isJdbc(action.getActionType())) {
                    ((JdbcAction)action).setDataSourceFactory(this.dataSourceFactory);
                }
                return action.execute(workflow, state, sourceConfig, webhookPayload);
            }
            catch (Exception e) {
                logger.error("Error occurred while performing state action. Details: " + e.getMessage(), e);
                throw e;
            }
        };
        Future<String> future = executor.submit(task);
        long timeout = action.findTimeout(workflow);
        logger.info("Timeout value: ", timeout);
        try {
            try {
                response = future.get(timeout, TimeUnit.SECONDS);
            }
            catch (TimeoutException te) {
                logger.error("Task timed out after " + timeout + " seconds.");
                future.cancel(true);
                String errorMessage = String.format("Error: Action %s for state '%s' timed out after %d seconds.", action.getId(), state.getId(), timeout);
                action.handleError(workflow, state, errorMessage, false);
                executor.shutdownNow();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("Exception in task execution: " + e.getMessage(), e);
                executor.shutdownNow();
            }
        }
        finally {
            executor.shutdownNow();
        }
        return response;
    }
}

