/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PythonCodeExecutor {
    public static String executePythonCode(String pythonCode) {
        ProcessBuilder processBuilder = new ProcessBuilder("python", "-c", pythonCode);
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            String output = PythonCodeExecutor.captureProcessOutput(process.getInputStream());
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.out.println("Python script exited with error code: " + exitCode);
            }
            return output;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String captureProcessOutput(InputStream inputStream) throws IOException {
        StringBuilder output = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return output.toString();
    }

    public static void main(String[] args) {
        String pythonCode = "def process_data_for_llm(data: dict):\r\n    import json\r\n    return json.dumps(data)\r\nprint(process_data_for_llm({'Name': ['John', 'Anna', 'Peter'], 'Age': [28, 24, 35], 'City': ['New York', 'Paris', 'Berlin']}))\r\n";
        String result = PythonCodeExecutor.executePythonCode(pythonCode);
        if (result != null) {
            System.out.println("Output from Python: " + result);
        } else {
            System.out.println("Failed to execute Python code.");
        }
    }
}

