/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.LogHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;

public class MacAddressExtractor {
    public static String extractMacAddress(Workflow workflow, Map<String, Object> crmDataMap) throws Exception {
        try {
            JSONObject crmData = new JSONObject();
            for (Map.Entry<String, Object> entry : crmDataMap.entrySet()) {
                crmData.put((Object)entry.getKey(), entry.getValue());
            }
            JSONObject sigmaDPM = MacAddressExtractor.getJSONObject(crmData, "Sigma DPM");
            JSONObject cerillion = MacAddressExtractor.getJSONObject(crmData, "Cerillion");
            if (sigmaDPM == null && cerillion == null) {
                throw new Exception("Both Sigma DPM and Cerillion data are missing from the payload.");
            }
            Set<String> cerillionMacAddresses = MacAddressExtractor.extractMacAddressesFromCerillion(cerillion);
            if (sigmaDPM != null && "success".equalsIgnoreCase(String.valueOf(sigmaDPM.get((Object)"status")))) {
                JSONObject serviceDetails = MacAddressExtractor.getJSONObject(sigmaDPM, "service_details");
                if (serviceDetails != null && !serviceDetails.isEmpty()) {
                    return MacAddressExtractor.processSigmaServiceDetails(serviceDetails, cerillionMacAddresses, workflow);
                }
                throw new Exception("Service details in Sigma DPM are missing or empty.");
            }
            if (cerillion != null) {
                return MacAddressExtractor.processCerillion(cerillion, workflow);
            }
            throw new Exception("Cerillion data is missing or not successful.");
        }
        catch (Exception e) {
            LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), "Error extracting MAC address: " + e.getMessage(), true);
            throw new Exception("Failed to extract MAC address: " + e.getMessage(), e);
        }
    }

    private static String processSigmaServiceDetails(JSONObject serviceDetails, Set<String> cerillionMacAddresses, Workflow workflow) throws Exception {
        JSONObject bestCandidate = null;
        String minKey = null;
        int detailsCount = serviceDetails.size();
        for (Object key : serviceDetails.keySet()) {
            JSONObject detail = (JSONObject)serviceDetails.get(key);
            String packageStatus = (String)detail.get((Object)"package");
            String macAddress = MacAddressExtractor.findMacAddressForRole(detail, "CM");
            if (!Util.isNotNullOrEmpty(macAddress)) continue;
            if (cerillionMacAddresses.contains(macAddress.toLowerCase())) {
                MacAddressExtractor.showSigmaLogMessage(workflow);
                return macAddress;
            }
            if (detailsCount == 1) {
                MacAddressExtractor.showSigmaLogMessage(workflow);
                return macAddress;
            }
            if (!packageStatus.toLowerCase().matches(".*(disabled|suspended|blocked).*")) {
                if (minKey != null && key.toString().compareTo(minKey) >= 0) continue;
                minKey = key.toString();
                bestCandidate = detail;
                continue;
            }
            if (bestCandidate != null) continue;
            bestCandidate = detail;
            minKey = key.toString();
        }
        if (bestCandidate != null) {
            String fallbackMacAddress = MacAddressExtractor.findMacAddressForRole(bestCandidate, "CM");
            MacAddressExtractor.showSigmaLogMessage(workflow);
            return fallbackMacAddress;
        }
        throw new Exception("No suitable MAC address found in Sigma DPM service details.");
    }

    private static String findMacAddressForRole(JSONObject detail, String role) {
        JSONObject deviceEventView = (JSONObject)detail.get((Object)"device_event_view");
        String macAddress = null;
        for (Object key : deviceEventView.keySet()) {
            JSONObject deviceInfo = (JSONObject)deviceEventView.get(key);
            if (!role.equalsIgnoreCase(String.valueOf(deviceInfo.get((Object)"role")))) continue;
            macAddress = deviceInfo.containsKey((Object)"mac_address") && deviceInfo.get((Object)"mac_address") != null ? String.valueOf(deviceInfo.get((Object)"mac_address")).trim() : null;
            break;
        }
        return macAddress;
    }

    private static Set<String> extractMacAddressesFromCerillion(JSONObject cerillion) {
        JSONObject macAddressObject;
        HashSet<String> macAddresses = new HashSet<String>();
        if (cerillion != null && "success".equalsIgnoreCase(String.valueOf(cerillion.get((Object)"status"))) && (macAddressObject = MacAddressExtractor.getJSONObject(cerillion, "mac_address")) != null) {
            for (Object key : macAddressObject.keySet()) {
                String mac = macAddressObject.get(key).toString().toLowerCase().trim();
                macAddresses.add(mac);
            }
        }
        return macAddresses;
    }

    private static String processCerillion(JSONObject cerillion, Workflow workflow) throws Exception {
        if (cerillion != null && "success".equals(cerillion.get((Object)"status"))) {
            String macAddress = MacAddressExtractor.extractMacFromCerillion(cerillion);
            MacAddressExtractor.showCerillionLogMessage(workflow);
            return macAddress;
        }
        String errorMessage = cerillion.containsKey((Object)"error") && cerillion.get((Object)"error") != null ? String.valueOf(cerillion.get((Object)"error")) : "Cerillion data is missing or not successful.";
        throw new Exception(errorMessage);
    }

    private static String extractMacFromCerillion(JSONObject cerillion) {
        JSONObject macAddressObject = MacAddressExtractor.getJSONObject(cerillion, "mac_address");
        if (macAddressObject != null && macAddressObject.get((Object)"0") != null) {
            return macAddressObject.get((Object)"0").toString();
        }
        return null;
    }

    private static JSONObject getJSONObject(JSONObject json, String key) {
        if (json != null && json.containsKey((Object)key) && json.get((Object)key) instanceof JSONObject) {
            return (JSONObject)json.get((Object)key);
        }
        return null;
    }

    public String getMacAddress(Workflow workflow, JSONObject webhookPayload) {
        String macAddress = null;
        try {
            macAddress = MacAddressExtractor.extractMacAddress(workflow, (Map<String, Object>)webhookPayload);
            if (Util.isNotNullOrEmpty(macAddress)) {
                macAddress = macAddress.trim();
                LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), "Detected Mac Address is " + macAddress);
            }
        }
        catch (Exception e) {
            LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), e.getMessage(), true);
        }
        return macAddress;
    }

    public static void showSigmaLogMessage(Workflow workflow) {
        System.out.println(workflow);
        LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), "Detected MAC Address from Sigma DPM", false);
    }

    public static void showCerillionLogMessage(Workflow workflow) {
        LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), "Detected MAC Address from Cerillion", false);
    }

    public static void main(String[] args) {
        String jsonString = "\r\n{\r\n    \"customer_id\": \"50440670\",\r\n    \"bu_id\": \"JAM\",\r\n    \"dvsum_metadata\": {\r\n        \"execution_id\": \"44591921_240604131235_11a7a723-6db3-456f-b13a-31833b8fd1e3:cerillion_and_sigma_dpm:api:il2avCweVxll1Z9WXegpJx6LknlcTG8Nmjb915Bp5b8=\"\r\n    },\r\n    \"Cerillion\": {\r\n        \"customer_id\": \"50440670\",\r\n        \"bu_id\": \"JAM\",\r\n        \"status\": \"success\",\r\n        \"timestamp\": \"2024060418123919\",\r\n        \"error\": \"NA\",\r\n        \"mac_address\": {\r\n            \"0\": \"e457408f2c4c\"\r\n        }\r\n    },\r\n    \"Sigma DPM\": {\r\n        \"customer_id\": \"50440670\",\r\n        \"bu_id\": \"JAM\",\r\n        \"status\": \"success\",\r\n        \"timestamp\": \"2024060418123919\",\r\n        \"error\": \"NA\",\r\n        \"service_details\": {\r\n            \"0\": {\r\n                \"package\": \"SAGSIP JM_TK_SAG_ESSNTL_SIP\",\r\n                \"mac_address\": \"acd75be49bed [CM]   acd75be49bf0[SIP]   \",\r\n                \"device_event_view\": {\r\n                    \"0\": {\r\n                        \"role\": \"dhcp\",\r\n                        \"device_name\": \"JamaicaDHCPTwo\",\r\n                        \"ip_address\": \"10.159.10.70 \",\r\n                        \"mac_address\": \"-\"\r\n                    },\r\n                    \"1\": {\r\n                        \"role\": \"DocsisCMTS\",\r\n                        \"device_name\": \"H8-NMG2-CM1\",\r\n                        \"ip_address\": \"72.252.25.226 \",\r\n                        \"mac_address\": \"-\"\r\n                    },\r\n                    \"2\": {\r\n                        \"role\": \"CM\",\r\n                        \"device_name\": \"-\",\r\n                        \"ip_address\": \"0.0.0.0 \",\r\n                        \"mac_address\": \"acd75be49bed \"\r\n                    }\r\n                }\r\n            },\r\n            \"1\": {\r\n                \"package\": \"BlockedAccess_JM_SIP\",\r\n                \"mac_address\": \"e457408f2c4c [CM]   \",\r\n                \"device_event_view\": {\r\n                    \"3\": {\r\n                        \"role\": \"dhcp\",\r\n                        \"device_name\": \"JamaicaDHCPTwo\",\r\n                        \"ip_address\": \"10.159.10.70 \",\r\n                        \"mac_address\": \"-\"\r\n                    },\r\n                    \"4\": {\r\n                        \"role\": \"DocsisCMTS\",\r\n                        \"device_name\": \"H8-NMG2-CM1\",\r\n                        \"ip_address\": \"72.252.25.226 \",\r\n                        \"mac_address\": \"-\"\r\n                    },\r\n                    \"5\": {\r\n                        \"role\": \"CM\",\r\n                        \"device_name\": \"-\",\r\n                        \"ip_address\": \"10.131.2.41 \",\r\n                        \"mac_address\": \"e457408f2c4c \"\r\n                    }\r\n                }\r\n            }\r\n        }\r\n    }\r\n}";
        try {
            JSONObject jsonobj = JsonUtil.parseToJsonObject(jsonString);
            System.out.println(MacAddressExtractor.extractMacAddress(null, (Map<String, Object>)jsonobj));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

