/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.Util;
import com.dvsum.workflow.service.JsonNavigator;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonExtractor {
    private static final CustomLogger logger = CustomLogger.getLogger(JsonExtractor.class);

    public static Object findAttr(JsonElement obj, String attrPath) {
        JsonNavigator navigator = new JsonNavigator(obj);
        return navigator.findAttribute(attrPath);
    }

    public static Object findAttr(JSONObject obj, String attrPath) {
        Object attr = null;
        if (Util.isNullOrEmpty(attrPath)) {
            return obj;
        }
        try {
            JsonElement jsonElement = new JsonParser().parse(obj.toJSONString());
            attr = JsonExtractor.findAttr(jsonElement, attrPath);
        }
        catch (Exception e) {
            logger.info("Error while finding attribute. Error :", e.getMessage());
            e.printStackTrace();
        }
        return attr;
    }

    public static Object findAttr(JSONArray obj, String attrPath) {
        Object attr = null;
        if (Util.isNullOrEmpty(attrPath)) {
            return obj;
        }
        try {
            JsonElement jsonElement = new JsonParser().parse(obj.toJSONString());
            attr = JsonExtractor.findAttr(jsonElement, attrPath);
        }
        catch (Exception e) {
            logger.info("Error while finding attribute. Error :", e.getMessage());
            e.printStackTrace();
        }
        return attr;
    }

    public static Object findAttr(Object obj, String attrPath) {
        Object attr = null;
        JsonElement jsonElement = null;
        if (Util.isNullOrEmpty(attrPath) || obj == null) {
            return obj;
        }
        try {
            jsonElement = obj instanceof JSONObject ? new JsonParser().parse(((JSONObject)obj).toJSONString()) : (obj instanceof JSONArray ? new JsonParser().parse(((JSONArray)obj).toJSONString()) : new JsonParser().parse((String)obj));
            attr = JsonExtractor.findAttr(jsonElement, attrPath);
        }
        catch (Exception e) {
            logger.info("Error while finding attribute. Error :", e.getMessage());
            e.printStackTrace();
        }
        return attr;
    }

    public static void main(String[] args) {
        try {
            JsonExtractor.example_1();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void example_1() {
        String json = "{\r\n    \"source_configs\": [\r\n        {\r\n            \"source_id\": \"3421511\",\r\n            \"domain\": \"8nje7gm3x6.execute-api.us-east-1.amazonaws.com\",\r\n            \"auth_info\": {\r\n                \"auth_type\": \"API_KEY\",\r\n                \"headers\": {\r\n                    \"x-api-key\": \"some api key\"\r\n                }\r\n            }\r\n        },\r\n        {\r\n            \"source_id\": \"3421512\",\r\n            \"domain\": \"nxt.lla.com\",\r\n            \"auth_info\": {\r\n                \"auth_type\": \"BASIC\",\r\n                \"base64_encoding\": true,\r\n                \"username\": \"some username\",\r\n                \"password\": \"some password\",\r\n                \"headers\": {\r\n                    \"content-type\": \"application/json\",\r\n                    \"Authorization\": \"Basic base64(some username:some password)\"\r\n                }\r\n            }\r\n        }\r\n    ],\r\n    \"workflow_data_store\": {\r\n        \"context\": {\r\n            \"country\": \"TT\"\r\n        },\r\n        \"outputs\":{}\r\n    },\r\n    \"state_machine\": {\r\n        \"state_machine_name\": \"DvSum_Copilot_Workflow\",\r\n        \"start_state\": \"step_1\",\r\n        \"default_timeout\": 120,\r\n        \"states\": [\r\n            {\r\n                \"state_id\": \"step_1\",\r\n                \"state_name\": \"cerillion_and_sigma_dpm\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state\": \"step_2\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"current_execution_state\":\"\",\r\n                \"actions\": [\r\n                    {\r\n                        \"seq_id\": 1,\r\n                        \"action_id\": \"api\",\r\n                        \"action_type\": \"WEBHOOK\",\r\n                        \"label\": \"Cerillion CRM & Sigma DPM\",\r\n                        \"timeout\": 120,\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true,\r\n                        \"include_dvsum_metadata_in_payload\": true,\r\n                        \"source_id\": \"3421511\",\r\n                        \"url\": \"/V1/trigger-Dvsum-bot/\",\r\n                        \"method\": \"POST\",\r\n                        \"payload\": {\r\n                            \"dvsum_metadata\": {\r\n                                \"execution_id\": \"$$.execution_id\",\r\n                                \"instance\": \"$$.context.instance\"\r\n                            },\r\n                            \"customer_id\": \"$$.context.customer_id\",\r\n                            \"bu_id\": \"$$.context.country\"\r\n                        },\r\n                        \"output_key\": \"crm_data\"\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"state_id\": \"step_2\",\r\n                \"state_name\": \"extract_mac_address\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state\": \"step_2\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"actions\": [\r\n                    {\r\n                        \"seq_id\": 2,\r\n                        \"action_id\": \"mac_extractor\",\r\n                        \"action_type\": \"DATA_PROCESSOR\",\r\n                        \"label\": \"Extracted Mac Address From Cerillion And Sigma DPM\",\r\n                        \"function\": \"extractMacAddress\",\r\n                        \"function_params\": {\r\n                            \"crm_data\": \"$$.crm_data\"\r\n                        },\r\n                        \"output_key\": \"detected_mac_address\",\r\n                        \"timeout\": 120,\r\n                        \"display_on_ui\": false,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"state_id\": \"step_3\",\r\n                \"state_name\": \"telemetry\",\r\n                \"next_state\": \"step_4\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state_type\": \"TASK\",\r\n                \"actions\": [\r\n                    {\r\n                        \"seq_id\": 3,\r\n                        \"action_id\": \"cm_level\",\r\n                        \"action_type\": \"REST\",\r\n                        \"label\": \"ServAssure NXT Telemetry: Cable Modem\",\r\n                        \"timeout\": 120,\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true,\r\n                        \"source_id\": \"3421511\",\r\n                        \"url\": \"/nxt-api/xray/v1.2/cm/{$$.detected_mac_address}/poll\",\r\n                        \"output_key\": \"telemetry_cm_level\",\r\n                        \"method\": \"GET\",\r\n                        \"query_parameters\": {\r\n                            \"parameters\": \"cmHost,cmtsHost,cmtsId,cmtsName,cmtsUptime,lastRegTime,fiberNodeId,inHomeScore,flapLastTime,flapTotalCnt,cmDocsisCapability,cmCollectStatus,cmUptime,cmDsBitrate,cmUsBitrate\"\r\n                        }\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"state_name\": \"get_scan_time_state\",\r\n                \"state_id\": \"step_3\",\r\n                \"next_state\": \"step_4\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state\": \"NOT_STARTED\",\r\n                \"type\": \"TASK\",\r\n                \"actions\": [\r\n                    {\r\n                        \"seq_id\": 8,\r\n                        \"action_id\": \"get_fiber_scan_time\",\r\n                        \"action_type\": \"REST\",\r\n                        \"label\": \"ServAssure NXT: Get Fiber Scan Time\",\r\n                        \"timeout\": 120,\r\n                        \"display_on_ui\": false,\r\n                        \"upload_raw_response_to_cloud\": true,\r\n                        \"source_id\": \"3421511\",\r\n                        \"url\": \"/nxt-ui/rest/service/stats/getScanTime\",\r\n                        \"method\": \"GET\",\r\n                        \"output_key\": \"get_scan_time\",\r\n                        \"query_parameters\": {\r\n                            \"fnId\": \"$$.telemetry_cm_level.parameters.fiberNodeId.value\"\r\n                        }\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"state_name\": \"get_cm_stats\",\r\n                \"state_id\": \"step_4\",\r\n                \"next_state\": \"END\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"type\": \"TASK\",\r\n                \"actions\": [\r\n                    {\r\n                        \"seq_id\": 9,\r\n                        \"action_id\": \"get_all_cms_on_the_node\",\r\n                        \"type\": \"REST\",\r\n                        \"label\": \"ServAssure NXT: All CMs on the Node\",\r\n                        \"timeout\": 120,\r\n                        \"display_on_ui\": false,\r\n                        \"upload_raw_response_to_cloud\": true,\r\n                        \"source_id\": \"3421511\",\r\n                        \"url\": \"/nxt-ui/rest/service/stats/getCMStats\",\r\n                        \"method\": \"POST\",\r\n                        \"path_parameters\": {},\r\n                        \"query_parameters\": {},\r\n                        \"output_key\": \"cm_stats_data\",\r\n                        \"payload\": \"$$.get_scan_time_state\"\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"state_id\": \"step_5\",\r\n                \"state_name\": \"modems_threshold_crossing\",\r\n                \"next_state\": \"END\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"type\": \"TASK\",\r\n                \"actions\": [\r\n                    {\r\n                        \"seq_id\": 10,\r\n                        \"action_id\": \"analyze_all_cm_stats\",\r\n                        \"type\": \"LAMBDA_CODE_EXECUTION\",\r\n                        \"label\": \"ServAssure NXT: All Modems on Fiber Node Threshold Crossing\",\r\n                        \"function\": \"nxt_all_modems_threshold_crossing\",\r\n                        \"function_params\": {\r\n                            \"cm_stats_json\": \"$$.cm_stats_data\",\r\n                            \"simultaneous_flap_count_configs\": {\r\n                                \"online_status_value\": \"8\",\r\n                                \"max_points_per_line\": 100,\r\n                                \"time_window_minutes\": 60,\r\n                                \"source_details\": \"$$$.source_configs.3421512\"\r\n                            }\r\n                        },\r\n                        \"output_key\": \"all_modems_threshold_crossing\",\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    },\r\n                    {\r\n                        \"seq_id\": 11,\r\n                        \"action_id\": \"analyze_single_cm_stats\",\r\n                        \"type\": \"LAMBDA_CODE_EXECUTION\",\r\n                        \"label\": \"ServAssure NXT: Single Modem Threshold Crossing\",\r\n                        \"function\": \"nxt_single_modem_threshold_crossing\",\r\n                        \"function_params\": {\r\n                            \"required_actions\": [\r\n                                \"$$$.state_machine.states[]\"\r\n                            ]\r\n                        },\r\n                        \"output_key\": \"single_modem_threshold_crossing\",\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            }\r\n        ]\r\n    },\r\n    \"response_json_mapping\": [\r\n        {\r\n            \"label\": \"cerillion_and_sigma_dpm\",\r\n            \"description\": \"Cerillion CRM and Sigma DPM telemetry information\",\r\n            \"source_mapping\": \"$$.pre_execution_metadata.crm_data\",\r\n            \"format\": \"JSON\"\r\n        },\r\n        {\r\n            \"label\": \"telemetry_cm_level\",\r\n            \"description\": \"Cable modem telemetry information\",\r\n            \"source_mapping\": \"$$.results.telemetry.cm_level\",\r\n            \"format\": \"JSON\"\r\n        },\r\n        {\r\n            \"label\": \"nxt_all_modems_threshold_crossing\",\r\n            \"description\": \"All Modems Threshold Crossing for a given fiber node\",\r\n            \"source_mapping\": \"$$.results.modems_threshold_crossing.analyze_all_cm_stats\",\r\n            \"format\": \"JSON\"\r\n        },\r\n        {\r\n            \"label\": \"nxt_single_modem_threshold_crossing\",\r\n            \"description\": \"Single Modem Threshold Crossing details\",\r\n            \"source_mapping\": \"$$.results.modems_threshold_crossing.analyze_single_cm_stats\",\r\n            \"format\": \"JSON\"\r\n        }\r\n    ]\r\n}";
        JsonParser parser = new JsonParser();
        JsonElement data = parser.parse(json);
        System.out.println(JsonExtractor.findAttr(data, "workflow_data_store.context.country"));
    }
}

