/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.service;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.JsonExtractor;
import com.dvsum.workflow.service.LogHandler;
import com.dvsum.workflow.service.QuoteRemover;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;

public class DynamicParamExtractor {
    private static final CustomLogger logger = CustomLogger.getLogger(DynamicParamExtractor.class);

    public static String fetchPythonFriendlyDynamicParam(Workflow workflow, String mappingVal) {
        String dynamicParam = DynamicParamExtractor.fetchDynamicParam(workflow, mappingVal);
        String pythonFriendlyJson = dynamicParam.replaceAll("null", "None").replaceAll("true", "True").replaceAll("false", "False");
        return pythonFriendlyJson;
    }

    public static String fetchDynamicParam(Workflow workflow, String mappingVal) {
        if (workflow == null || mappingVal == null) {
            logger.error("Invalid null input provided.");
            return null;
        }
        String trimmedVal = mappingVal.trim();
        Object objToParse = DynamicParamExtractor.determineTargetObject(workflow, trimmedVal);
        if (objToParse == null) {
            return mappingVal;
        }
        trimmedVal = DynamicParamExtractor.trimPrefix(trimmedVal);
        return DynamicParamExtractor.extractJsonAttribute(objToParse, trimmedVal);
    }

    private static Object determineTargetObject(Workflow workflow, String mappingVal) {
        if (mappingVal.startsWith("$$.context.")) {
            return workflow.getWorkflowDataStore();
        }
        if (mappingVal.startsWith("$$.")) {
            return workflow.getWorkflowDataStore().getOutputs();
        }
        if (mappingVal.startsWith("$$$.")) {
            return workflow;
        }
        return null;
    }

    private static String trimPrefix(String mappingVal) {
        if (mappingVal.startsWith("$$.")) {
            return mappingVal.substring(3);
        }
        if (mappingVal.startsWith("$$$.")) {
            return mappingVal.substring(4);
        }
        return mappingVal;
    }

    private static String extractJsonAttribute(Object objToParse, String attributePath) {
        Object fetchedAttr;
        block3: {
            try {
                String jsonString = JsonObjectMapperUtil.getJsonStringFromObject(objToParse);
                JsonElement jsonElement = new JsonParser().parse(jsonString);
                fetchedAttr = JsonExtractor.findAttr(jsonElement, attributePath);
                if (fetchedAttr != null) break block3;
                logger.info("Attribute", attributePath, "not found.");
                return null;
            }
            catch (Exception e) {
                logger.error("Error while fetching dynamic parameter from state machine. Param: ", attributePath, " Error: ", e.getMessage());
                return null;
            }
        }
        return QuoteRemover.removeQuotes(String.valueOf(fetchedAttr));
    }

    public static Map<String, Object> resolveMap(Map<String, Object> map, Workflow workflow) {
        HashMap<String, Object> updatedPayload = new HashMap<String, Object>();
        if (map == null || workflow == null) {
            return updatedPayload;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String) {
                updatedPayload.put(key, DynamicParamExtractor.processStringValue((String)value, workflow));
                continue;
            }
            if (value instanceof Map) {
                Map nestedMap = (Map)value;
                updatedPayload.put(key, DynamicParamExtractor.resolveMap(nestedMap, workflow));
                continue;
            }
            updatedPayload.put(key, value);
        }
        return updatedPayload;
    }

    private static Object processStringValue(String value, Workflow workflow) {
        try {
            if (DynamicParamExtractor.isDynamicParameter(value)) {
                String replacedValue = null;
                if ("$$.execution_id".equals(value)) {
                    replacedValue = workflow.getWorkflowDataStore().generateContextExecutionId();
                    LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), "Execution ID: " + replacedValue);
                } else {
                    replacedValue = DynamicParamExtractor.fetchDynamicParam(workflow, value);
                }
                return replacedValue != null ? JsonUtil.parseToJsonOrReturn(replacedValue) : value;
            }
        }
        catch (Exception e) {
            logger.error("Error while processing string value when resolving map. Error: ", e.getMessage());
            e.printStackTrace();
        }
        return value;
    }

    private static boolean isDynamicParameter(String value) {
        return value.startsWith("$$.") || value.startsWith("$$$.");
    }

    public static void main(String[] args) {
        HashMap<String, String> dvsumMetadata = new HashMap<String, String>();
        dvsumMetadata.put("execution_id", "$$.execution_id");
        dvsumMetadata.put("instance", "$$.context.instance");
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("dvsum_metadata", dvsumMetadata);
        payload.put("customer_id", "$$.context.customer_id");
        payload.put("bu_id", "$$.context.country");
        String workflowStr = "{\"state_machine\":{\"state_machine_name\":\"DvSum_Copilot_Workflow\",\"start_state\":\"STEP_1\",\"default_timeout\":120,\"states\":[{\"next_state\":\"STEP_2\",\"state_name\":\"cerillion_and_sigma_dpm\",\"state_type\":\"TASK\",\"next_state_on_error\":\"END\",\"state_id\":\"STEP_1\",\"actions\":[{\"method\":\"POST\",\"action_type\":\"WEBHOOK\",\"include_dvsum_metadata_in_payload\":true,\"label\":\"Cerillion CRM & Sigma DPM\",\"timeout\":120,\"url\":\"\\/V1\\/trigger-Dvsum-bot\\/\",\"display_on_ui\":true,\"action_id\":\"api\",\"payload\":{\"dvsum_metadata\":{\"execution_id\":\"$$.execution_id\",\"instance\":\"$$.context.instance\"},\"customer_id\":\"$$.context.customer_id\",\"bu_id\":\"$$.context.country\"},\"output_key\":\"crm_data\",\"seq_id\":1,\"source_id\":\"1\",\"upload_raw_response_to_cloud\":true}]},{\"next_state\":\"STEP_3\",\"state_name\":\"extract_mac_address\",\"state_type\":\"TASK\",\"next_state_on_error\":\"END\",\"state_id\":\"STEP_2\",\"actions\":[{\"action_id\":\"mac_extractor\",\"action_type\":\"DATA_PROCESSOR\",\"output_key\":\"detected_mac_address\",\"function\":\"extractMacAddress\",\"seq_id\":2,\"label\":\"Extracted Mac Address From Cerillion And Sigma DPM\",\"function_params\":{\"crm_data\":\"$$.crm_data\"},\"timeout\":120,\"display_on_ui\":false,\"upload_raw_response_to_cloud\":true}]},{\"next_state\":\"STEP_4\",\"state_name\":\"telemetry\",\"state_type\":\"TASK\",\"next_state_on_error\":\"STEP_4\",\"state_id\":\"STEP_3\",\"actions\":[{\"query_parameters\":{\"parameters\":\"cmHost,cmtsHost,cmtsId,cmtsName,cmtsUptime,lastRegTime,fiberNodeId,inHomeScore,flapLastTime,flapTotalCnt,cmDocsisCapability,cmCollectStatus,cmUptime,cmDsBitrate,cmUsBitrate\"},\"method\":\"GET\",\"action_id\":\"cm_level\",\"action_type\":\"REST\",\"output_key\":\"telemetry_cm_level\",\"seq_id\":3,\"label\":\"ServAssure NXT Telemetry: Cable Modem\",\"source_id\":\"2\",\"timeout\":120,\"url\":\"\\/nxt-api\\/xray\\/v1.2\\/cm\\/{$$.detected_mac_address}\\/poll\",\"display_on_ui\":true,\"upload_raw_response_to_cloud\":true},{\"method\":\"GET\",\"action_type\":\"REST\",\"label\":\"ServAssure NXT Telemetry: Cable Modem Channel - DownData\",\"timeout\":120,\"url\":\"\\/nxt-api\\/xray\\/v1.2\\/cm\\/{$$.detected_mac_address}\\/poll\",\"display_on_ui\":true,\"query_parameters\":{\"parameters\":\"downData.ifType,downData.ifDescr,downData.frequency,downData.ifSpeed,downData.partialSvcReason,downData.rxPwr,downData.snr,downData.width,downData.modulation,downData.cmCCER,downData.cmCER,downData.cmCERCCER\"},\"action_id\":\"channel_level_down_data\",\"output_key\":\"telemetry_channel_level_down_data\",\"ui_display_mapping\":\"parameters.downData.values\",\"seq_id\":4,\"source_id\":\"2\",\"upload_raw_response_to_cloud\":true},{\"method\":\"GET\",\"action_type\":\"REST\",\"label\":\"ServAssure NXT Telemetry: Cable Modem Channel - UpData\",\"timeout\":120,\"url\":\"\\/nxt-api\\/xray\\/v1.2\\/cm\\/{$$.detected_mac_address}\\/poll\",\"display_on_ui\":true,\"query_parameters\":{\"parameters\":\"upData.ifType,upData.ifDescr,upData.frequency,upData.channelType,upData.ifSpeed,upData.partialSvcReason,upData.rxPwr,upData.txPwr,upData.snr,upData.cmCCER,upData.cmCER,upData.cmCERCCER\"},\"action_id\":\"channel_level_up_data\",\"output_key\":\"telemetry_channel_level_up_data\",\"ui_display_mapping\":\"parameters.upData.values\",\"seq_id\":5,\"source_id\":\"2\",\"upload_raw_response_to_cloud\":true},{\"method\":\"GET\",\"action_type\":\"REST\",\"label\":\"ServAssure NXT Telemetry: Cable Modem Channel - OFDM\",\"timeout\":120,\"url\":\"\\/nxt-api\\/xray\\/v1.2\\/cm\\/{$$.detected_mac_address}\\/poll\",\"display_on_ui\":true,\"query_parameters\":{\"parameters\":\"ofdmData.rxPwr,ofdmData.partialSvcReason\"},\"action_id\":\"channel_level_ofdm_data\",\"output_key\":\"telemetry_channel_level_ofdm_data\",\"ui_display_mapping\":\"parameters.ofdmData.values\",\"seq_id\":6,\"source_id\":\"2\",\"upload_raw_response_to_cloud\":true},{\"method\":\"GET\",\"action_type\":\"REST\",\"label\":\"ServAssure NXT Telemetry: Cable Modem Channel - OFDMA\",\"timeout\":120,\"url\":\"\\/nxt-api\\/xray\\/v1.2\\/cm\\/{$$.detected_mac_address}\\/poll\",\"display_on_ui\":true,\"query_parameters\":{\"parameters\":\"ofdmaData.attenuation,ofdmaData.rxPwr,ofdmaData.txPwr,ofdmaData.cmCCER,ofdmaData.cmCERCCER,ofdmaData.cmCER\"},\"action_id\":\"channel_level_ofdma_data\",\"output_key\":\"telemetry_channel_level_ofdma_data\",\"ui_display_mapping\":\"parameters.ofdmaData.values\",\"seq_id\":7,\"source_id\":\"2\",\"upload_raw_response_to_cloud\":true},{\"method\":\"GET\",\"action_type\":\"REST\",\"label\":\"ServAssure NXT Telemetry: Cable Modem Alarms\",\"timeout\":120,\"url\":\"\\/nxt-api\\/xray\\/v1.1\\/alarms_for_modem\",\"display_on_ui\":true,\"query_parameters\":{\"mac\":\"$$.detected_mac_address\"},\"action_id\":\"cm_alarms\",\"output_key\":\"telemetry_channel_level_down_data\",\"ui_display_mapping\":\"parameters.downData.values\",\"seq_id\":8,\"source_id\":\"2\",\"upload_raw_response_to_cloud\":true}]},{\"next_state\":\"STEP_5\",\"state_name\":\"scan_time\",\"state_type\":\"TASK\",\"next_state_on_error\":\"STEP_5\",\"state_id\":\"STEP_4\",\"actions\":[{\"query_parameters\":{\"fnId\":\"$$.telemetry_cm_level.parameters.fiberNodeId.value\"},\"method\":\"GET\",\"action_id\":\"get_fiber_scan_time\",\"action_type\":\"REST\",\"output_key\":\"fiber_scan_time\",\"seq_id\":9,\"label\":\"ServAssure NXT: Get Fiber Scan Time\",\"source_id\":\"2\",\"timeout\":120,\"url\":\"\\/nxt-ui\\/rest\\/service\\/stats\\/getScanTime\",\"display_on_ui\":false,\"upload_raw_response_to_cloud\":true}]},{\"next_state\":\"END\",\"state_name\":\"get_cm_stats\",\"state_type\":\"TASK\",\"next_state_on_error\":\"END\",\"state_id\":\"STEP_5\",\"actions\":[{\"method\":\"POST\",\"action_id\":\"get_all_cms_on_the_node\",\"action_type\":\"REST\",\"payload\":{\"payload_json_mapping\":\"$$.fiber_scan_time\"},\"output_key\":\"cm_stats\",\"seq_id\":10,\"label\":\"ServAssure NXT: All CMs on the Node\",\"source_id\":\"2\",\"timeout\":120,\"url\":\"\\/nxt-ui\\/rest\\/service\\/stats\\/getCMStats\",\"display_on_ui\":false,\"upload_raw_response_to_cloud\":true}]},{\"next_state\":\"END\",\"state_name\":\"modems_threshold_crossing\",\"state_type\":\"TASK\",\"next_state_on_error\":\"END\",\"state_id\":\"STEP_6\",\"actions\":[{\"action_id\":\"analyze_all_cm_stats\",\"action_type\":\"LAMBDA_CODE_EXECUTION\",\"output_key\":\"all_modems_threshold_crossing\",\"function\":\"nxt_all_modems_threshold_crossing\",\"seq_id\":11,\"label\":\"ServAssure NXT: All Modems on Fiber Node Threshold Crossing\",\"function_params\":{\"cm_stats_json\":\"$$.cm_stats\",\"simultaneous_flap_count_configs\":{\"max_points_per_line\":100,\"source_details\":\"$$$.source_configs[src_id=2]\",\"online_status_value\":\"8\",\"time_window_minutes\":60}},\"display_on_ui\":true,\"upload_raw_response_to_cloud\":true},{\"action_id\":\"analyze_single_cm_stats\",\"action_type\":\"LAMBDA_CODE_EXECUTION\",\"output_key\":\"single_modem_threshold_crossing\",\"function\":\"nxt_single_modem_threshold_crossing\",\"seq_id\":12,\"label\":\"ServAssure NXT: Single Modem Threshold Crossing\",\"function_params\":{\"required_actions\":[\"$$$.state_machine.states[]\"]},\"display_on_ui\":true,\"upload_raw_response_to_cloud\":true}]}]},\"workflow_data_store\":{\"context\":{\"country\":\"TT\",\"execution_id\":\"38548785_240929141346_b4396443-d2f6-49ed-9080-028719507319\",\"regex_pattern\":\"\\\\b\\\\d{5,}\\\\b\",\"instance\":\"CLOUD_DEV\",\"account_id\":\"30028807\",\"question\":[\"60131959\"],\"browser_websocket_connection_id\":\"e24uTfSLPHcCE5g=\",\"saws_websocket_connection_id\":\"e3EJNf52vHcCE1Q=\",\"saws_connector_id\":\"37681686\",\"is_on_prem_saws\":true,\"customer_id\":\"60131959\",\"bot_id\":\"38548785\"}},\"name\":\"DvSum Co-Pilot Workflow\",\"response_json_mapping\":[{\"source_mapping\":\"$$.crm_data\",\"format\":\"JSON\",\"description\":\"Cerillion CRM and Sigma DPM telemetry information\",\"label\":\"cerillion_and_sigma_dpm\"},{\"source_mapping\":\"$$.telemetry_cm_level\",\"format\":\"JSON\",\"description\":\"Cable modem telemetry information\",\"label\":\"telemetry_cm_level\"},{\"source_mapping\":\"$$.all_modems_threshold_crossing\",\"format\":\"JSON\",\"description\":\"All Modems Threshold Crossing for a given fiber node\",\"label\":\"nxt_all_modems_threshold_crossing\"},{\"source_mapping\":\"$$.single_modem_threshold_crossing\",\"format\":\"JSON\",\"description\":\"Single Modem Threshold Crossing details\",\"label\":\"nxt_single_modem_threshold_crossing\"}],\"s3_pre_signed_URL\":{\"fields\":{\"signature\":\"jnrkB\\/OA2qQj4pN9c+2N0UmVkuM=\",\"AWSAccessKeyId\":\"AKIA5TTPV3WAWJTSSTOB\",\"key\":\"data-analysis\\/30028807\\/38548785_240929141346_b4396443-d2f6-49ed-9080-028719507319\\/${filename}\",\"policy\":\"eyJleHBpcmF0aW9uIjogIjIwMjktMDktMjhUMDk6MTM6NDlaIiwgImNvbmRpdGlvbnMiOiBbeyJidWNrZXQiOiAiZHZzdW0tYXBwLWRhdGEtZGV2In0sIFsic3RhcnRzLXdpdGgiLCAiJGtleSIsICJkYXRhLWFuYWx5c2lzLzMwMDI4ODA3LzM4NTQ4Nzg1XzI0MDkyOTE0MTM0Nl9iNDM5NjQ0My1kMmY2LTQ5ZWQtOTA4MC0wMjg3MTk1MDczMTkvIl1dfQ==\"},\"url\":\"https:\\/\\/dvsum-app-data-dev.s3.amazonaws.com\\/\"},\"source_configs\":[{\"src_id\":\"1\",\"domain\":\"8nje7gm3x6.execute-api.us-east-1.amazonaws.com\",\"auth_info\":{\"headers\":{\"x-api-key\":\"wXHzbVT55S79ckvHwjgOj1SkjZqNG0ZQ8SANtdvQ\"},\"auth_type\":\"API_KEY\"}},{\"src_id\":\"2\",\"domain\":\"nxt.lla.com\",\"auth_info\":{\"headers\":{\"Authorization\":\"Basic base64(cablew\\/LLADvsum:p@ssw0rd)\",\"content-type\":\"application\\/json\"},\"auth_type\":\"BASIC\",\"password\":\"p@ssw0rd\",\"base64_encoding\":true,\"username\":\"cablew\\/LLADvsum\"}}]} ";
        Workflow workflow = JsonObjectMapperUtil.getObjectFromJsonString(workflowStr, Workflow.class);
        String sourceConfig = DynamicParamExtractor.fetchDynamicParam(workflow, "$$$.source_configs[src_id=2]");
        System.out.println(sourceConfig);
    }
}

