/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.State;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WorkflowDataStore {
    private static final CustomLogger logger = CustomLogger.getLogger(WorkflowDataStore.class);
    public static final String CONTEXT_KEY = "context";
    public static final String OUTPUTS_KEY = "outputs";
    @JsonProperty(value="context")
    private Map<String, Object> context;
    @JsonProperty(value="outputs")
    private Map<String, Object> outputs;

    public WorkflowDataStore() {
    }

    public WorkflowDataStore(String contextExecutionId) {
        this.setContextUsingExecutionId(contextExecutionId);
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public void setContextUsingExecutionId(String contextExecutionId) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        try {
            String[] parts = contextExecutionId.split(":");
            if (parts.length == 4) {
                this.context.put("execution_id", parts[0]);
                this.context.put("current_state_id", parts[1]);
                this.context.put("current_action_id", parts[2]);
                this.context.put("account_id", CryptographicUtil.decrypt(parts[3]));
                this.context.put("is_on_prem_saws", !Boolean.parseBoolean(FileUtil.getPropertyWithDefault("is.cloud.saws", "false")));
                logger.info("Execution ID: {}", this.context.get("execution_id"));
                logger.info("State ID: {}", this.context.get("current_state_id"));
                logger.info("Action ID: {}", this.context.get("current_action_id"));
                logger.info("Account ID: {}", this.context.get("account_id"));
                logger.info("isOnPremSaws: {}", this.context.get("is_on_prem_saws"));
            } else {
                logger.error("Invalid context execution ID format. Context execution id: ", contextExecutionId);
            }
        }
        catch (Exception e) {
            logger.error("Error while reading context execution ID: {}", e.getMessage());
        }
    }

    public Map<String, Object> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Map<String, Object> outputs) {
        this.outputs = outputs;
    }

    public void setOutput(String key, Object output) {
        if (this.outputs == null) {
            this.outputs = new HashMap<String, Object>();
        }
        this.outputs.put(key, output);
    }

    public void appendContext(String key, Object value) {
        if (this.context == null) {
            System.out.println("Creating new context");
            this.context = new HashMap<String, Object>();
        }
        this.context.put(key, value);
    }

    public void clearOutput(String key) {
        this.outputs.remove(key);
    }

    public void clearOutputs() {
        this.setOutputs(new HashMap<String, Object>());
    }

    public Object findOutput(String key) {
        return this.outputs.get(key);
    }

    public void updateStateIdAndActionIdInContext(State state, Action action) {
        this.context.put("current_state_id", state.getId());
        this.context.put("current_action_id", action.getId());
    }

    public void removeIdsFromContext() {
        this.context.remove("current_state_id");
        this.context.remove("current_action_id");
    }

    public String generateContextExecutionId() {
        String stateId = String.valueOf(this.findCurrentStateId());
        String actionId = String.valueOf(this.findCurrentActionId());
        String executionId = String.valueOf(this.findExecutionId());
        String accountId = String.valueOf(this.findAccountId());
        String encryptedAccountId = CryptographicUtil.encrypt(accountId);
        String contextExecutionId = String.format("%s:%s:%s:%s", executionId, stateId, actionId, encryptedAccountId);
        logger.info("Context Execution id :", contextExecutionId);
        return contextExecutionId;
    }

    public String findAccountId() {
        return String.valueOf(this.context.get("account_id"));
    }

    public String findExecutionId() {
        return String.valueOf(this.context.get("execution_id"));
    }

    public boolean findIsOnPremSaws() {
        return Boolean.valueOf(String.valueOf(this.context.get("is_on_prem_saws")));
    }

    public String findCurrentStateId() {
        return String.valueOf(this.context.get("current_state_id"));
    }

    public String findCurrentActionId() {
        return String.valueOf(this.context.get("current_action_id"));
    }

    public String findBrowserWebSocketConnectionId() {
        return String.valueOf(this.context.get("browser_websocket_connection_id"));
    }

    public String findToolId() {
        return this.context.containsKey("tool_id") && this.context.get("tool_id") != null ? String.valueOf(this.context.get("tool_id")) : "";
    }

    public String findToolName() {
        return this.context.containsKey("tool_name") && this.context.get("tool_name") != null ? String.valueOf(this.context.get("tool_name")) : "";
    }

    public static void main(String[] args) {
        String dataStoreString = "{\r\n        \"context\": {\r\n            \"country\": \"TT\",\r\n            \"instance\": \"CLOUD_QA\",\r\n            \"records_per_page\": 100\r\n        }\r\n    }";
        WorkflowDataStore dataStore = JsonObjectMapperUtil.getObjectFromJsonString(dataStoreString, WorkflowDataStore.class);
        System.out.println(dataStore.getContext());
    }
}

