/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JSONToCSVUtil;
import com.dvsum.util.JsonFlattener;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.Action.JdbcAction;
import com.dvsum.workflow.model.CustomFunction;
import com.dvsum.workflow.model.ResponseJsonMapping;
import com.dvsum.workflow.model.S3PreSignedURLInfo;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.StateMachine;
import com.dvsum.workflow.model.WorkflowDataStore;
import com.dvsum.workflow.service.DynamicParamExtractor;
import com.dvsum.workflow.service.JsonExtractor;
import com.dvsum.workflow.service.WorkflowFileUploader;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Workflow {
    private static final CustomLogger logger = CustomLogger.getLogger(Workflow.class);
    @JsonProperty(value="name")
    private String workflowName;
    @JsonProperty(value="source_configs")
    private List<SourceConfig> sourceConfigs;
    @JsonProperty(value="custom_functions")
    private List<CustomFunction> customFunctions;
    @JsonProperty(value="s3_pre_signed_URL")
    private S3PreSignedURLInfo s3PreSignedURLInfo;
    @JsonProperty(value="workflow_data_store")
    private WorkflowDataStore workflowDataStore;
    @JsonProperty(value="response_json_mapping")
    private List<ResponseJsonMapping> responseJsonMappings;
    @JsonProperty(value="state_machine")
    private StateMachine stateMachine;
    @JsonProperty(value="workflow_state_s3_pre_signed_get_url")
    private String workflowStateS3PreSignedGetUrl;
    @JsonIgnore
    private JSONObject response;
    @JsonIgnore
    private JSONObject prunedResponse;

    public JSONObject getResponse() {
        return this.response;
    }

    public void setResponse(JSONObject response) {
        this.response = response;
    }

    public JSONObject getPrunedResponse() {
        return this.prunedResponse;
    }

    public void setPrunedResponse(JSONObject prunedResponse) {
        this.prunedResponse = prunedResponse;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public List<SourceConfig> getSourceConfigs() {
        return this.sourceConfigs;
    }

    public void setSourceConfigs(List<SourceConfig> sourceConfigs) {
        this.sourceConfigs = sourceConfigs;
    }

    public List<CustomFunction> getCustomFunctions() {
        return this.customFunctions;
    }

    public void setCustomFunctions(List<CustomFunction> customFunctions) {
        this.customFunctions = customFunctions;
    }

    public S3PreSignedURLInfo getS3PreSignedURLInfo() {
        return this.s3PreSignedURLInfo;
    }

    public void setS3PreSignedURLInfo(S3PreSignedURLInfo s3PreSignedURLInfo) {
        this.s3PreSignedURLInfo = s3PreSignedURLInfo;
    }

    public WorkflowDataStore getWorkflowDataStore() {
        return this.workflowDataStore;
    }

    public void setWorkflowDataStore(WorkflowDataStore workflowDataStore) {
        this.workflowDataStore = workflowDataStore;
    }

    public List<ResponseJsonMapping> getResponseJsonMappings() {
        return this.responseJsonMappings;
    }

    public void setResponseJsonMappings(List<ResponseJsonMapping> responseJsonMappings) {
        this.responseJsonMappings = responseJsonMappings;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public void setStateMachine(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public CustomFunction findCustomFunction(String functionId) {
        for (CustomFunction customFunction : this.getCustomFunctions()) {
            if (!customFunction.getFunction().equalsIgnoreCase(functionId)) continue;
            return customFunction;
        }
        return null;
    }

    public SourceConfig findSourceConfig(String sourceId) {
        for (SourceConfig sourceConfig : this.sourceConfigs) {
            if (!sourceConfig.getSourceId().equalsIgnoreCase(sourceId)) continue;
            return sourceConfig;
        }
        return null;
    }

    public String generateBaseFilePath() {
        return "./data_analysis/workflow/" + this.workflowDataStore.findExecutionId() + "/";
    }

    public String generateWorkflowStateFilePath() {
        return String.valueOf(this.generateBaseFilePath()) + "workflow_state.json";
    }

    public String generateFilePath(String fileName) {
        return String.valueOf(this.generateBaseFilePath()) + fileName;
    }

    public void saveWorkflowState() {
        WorkflowFileUploader.generateFile(this.generateWorkflowStateFilePath(), JsonObjectMapperUtil.getJsonObjectFromObject(this), this.getS3PreSignedURLInfo(), new LogFormat());
        logger.info("Workflow context saved.");
    }

    public static Workflow loadWorkflowState(WorkflowDataStore workflowDataStore, String workflowStateGetUrlApi) {
        return Workflow.loadWorkflowStateInternal(workflowDataStore, workflowStateGetUrlApi);
    }

    public static Workflow loadWorkflowState(JSONObject dvsumMetadata, String workflowStateGetUrlApi) {
        String executionId = String.valueOf(dvsumMetadata.get((Object)"execution_id"));
        WorkflowDataStore workflowDataStore = new WorkflowDataStore(executionId);
        return Workflow.loadWorkflowStateInternal(workflowDataStore, workflowStateGetUrlApi);
    }

    private static Workflow loadWorkflowStateInternal(WorkflowDataStore workflowDataStore, String workflowStateGetUrlApi) {
        Workflow workflow = null;
        try {
            if (!workflowDataStore.findIsOnPremSaws()) {
                String workflowStatePresignedUrl = Workflow.getWorkflowStatePresignedUrl(workflowStateGetUrlApi, workflowDataStore.findAccountId(), workflowDataStore.findExecutionId());
                logger.info("Cloud Gateway. Reading workflow state from S3 url: ", workflowStatePresignedUrl);
                String workflowStringified = TLSHttpsRequestor.downloadWithPresignedUrl(workflowStatePresignedUrl);
                workflow = JsonObjectMapperUtil.getObjectFromJsonString(workflowStringified, Workflow.class);
            } else {
                String baseFilePath = "./data_analysis/workflow/" + workflowDataStore.findExecutionId() + "/";
                String workflowStateFilePath = String.valueOf(baseFilePath) + "workflow_state.json";
                logger.info("On-Prem Gateway. Reading workflow state from local file path: ", workflowStateFilePath);
                JSONObject workflowStateJson = FileUtil.readFileAsJsonObject(workflowStateFilePath);
                workflow = JsonObjectMapperUtil.getObjectFromJsonObject(workflowStateJson, Workflow.class);
            }
        }
        catch (Exception e) {
            logger.error("Error while loading workflow state. Error: ", e.getMessage());
            e.printStackTrace();
        }
        return workflow;
    }

    private static String getWorkflowStatePresignedUrl(String apiUrl, String accountId, String executionId) {
        String preSignedUrl = null;
        try {
            String response = TLSHttpsRequestor.executeGet(apiUrl, new String[]{accountId, executionId}, new String[]{"account_id", "execution_id"});
            JSONObject responseJson = JsonUtil.parseToJsonObject(response);
            preSignedUrl = String.valueOf(responseJson.get((Object)"url"));
        }
        catch (Exception e) {
            logger.error("Error while getting workflow state presigned url. Error :", e.getMessage());
            e.printStackTrace();
        }
        logger.info("PRESIGNED URL = ", preSignedUrl);
        return preSignedUrl;
    }

    public JSONObject generateResMappingObject(String actionName, String outputData, ResponseJsonMapping currentResMapping) {
        JSONObject mappedFormattedJson = new JSONObject();
        try {
            Object value = JsonExtractor.findAttr(outputData, currentResMapping.getSourceMapping());
            logger.info("Response Json Mapping Value :", value);
            mappedFormattedJson.put((Object)"state", (Object)actionName);
            mappedFormattedJson.put((Object)"source", (Object)currentResMapping.getSourceMapping());
            mappedFormattedJson.put((Object)"value", value);
        }
        catch (Exception e) {
            logger.error("Error while mapping results to response mapping. Error :", e.getMessage());
            e.printStackTrace();
        }
        return mappedFormattedJson;
    }

    public Object getFormattedOutputData(ResponseJsonMapping resJsonMapping, Object sourceMappingData) {
        logger.info("Getting formatted output data for ", resJsonMapping.getLabel());
        Object formattedResponse = null;
        try {
            sourceMappingData = JsonUtil.parseToJson(String.valueOf(sourceMappingData));
            String format = resJsonMapping.getFormat();
            if (sourceMappingData != null) {
                if (Util.isNullOrEmpty(format) || "JSON".equalsIgnoreCase(format)) {
                    formattedResponse = sourceMappingData;
                    logger.info("Format set to JSON");
                } else if ("CSV".equalsIgnoreCase(format)) {
                    if (sourceMappingData != null) {
                        logger.info(sourceMappingData.getClass());
                    }
                    JSONArray extractedArray = new JSONArray();
                    if (sourceMappingData instanceof JSONObject || sourceMappingData instanceof Map) {
                        logger.info("Converting to JSON Array");
                        extractedArray.add((Object)sourceMappingData);
                    }
                    if (extractedArray.isEmpty()) {
                        extractedArray = sourceMappingData;
                    }
                    if (extractedArray != null && !extractedArray.isEmpty()) {
                        logger.info("Extracted Array = ", extractedArray.toJSONString());
                        formattedResponse = JSONToCSVUtil.convertJsonArrayToCsv(String.valueOf(extractedArray));
                    }
                    logger.info("Format set to CSV");
                } else if ("flatten".equalsIgnoreCase(format) && sourceMappingData instanceof JSONObject) {
                    formattedResponse = JsonFlattener.flattenJsonObject((JSONObject)sourceMappingData, "");
                    logger.info("Format set to Flatten");
                } else if ("flatten".equalsIgnoreCase(format) && sourceMappingData instanceof JSONArray) {
                    formattedResponse = JsonFlattener.convertJsonArrayToKeyValPairs(sourceMappingData);
                    logger.info("Format set to Flatten");
                } else {
                    formattedResponse = sourceMappingData;
                    logger.info("Provided format is not valid. Using default format as JSON.");
                }
            } else {
                logger.error("Unable to retrieve results from provided response json mapping source: ", resJsonMapping.getSourceMapping());
            }
        }
        catch (Exception e) {
            logger.error("Error while formatting output data. Error :", e.getMessage());
            e.printStackTrace();
        }
        return formattedResponse;
    }

    public JSONObject generatePrunedResponseJson() {
        JSONObject prunedResponseJson = new JSONObject();
        logger.info("Generating pruned response json.");
        try {
            for (ResponseJsonMapping resMapping : this.getResponseJsonMappings()) {
                if (!resMapping.isValidResponseJsonMapping(this.getWorkflowDataStore())) {
                    logger.info("Output key", resMapping.extractOutputKey(), "doesn't exist in workflow data store. Skipping response json mapping with ID:", resMapping.getSourceMapping());
                    continue;
                }
                logger.info("Getting source mapping for ", resMapping.getSourceMapping());
                String sourceMappingData = DynamicParamExtractor.fetchDynamicParam(this, resMapping.getSourceMapping());
                Object parsedObject = JsonUtil.parseToJson(sourceMappingData);
                Object formattedOutput = this.getFormattedOutputData(resMapping, parsedObject);
                JSONObject prunedResponseNested = new JSONObject();
                prunedResponseNested.put((Object)"data", formattedOutput);
                prunedResponseNested.put((Object)"description", (Object)resMapping.getDescription());
                prunedResponseJson.put((Object)resMapping.getLabel(), (Object)prunedResponseNested);
            }
        }
        catch (Exception e) {
            logger.error("Error while generating pruned response. Error :", e.getMessage());
            e.printStackTrace();
        }
        return prunedResponseJson;
    }

    public JSONObject generateResponseJson() {
        JSONObject responseJson = new JSONObject();
        try {
            HashMap<String, Map<String, Object>> workflowDataStoreWithoutOutputs = new HashMap<String, Map<String, Object>>();
            workflowDataStoreWithoutOutputs.put("context", this.workflowDataStore.getContext());
            responseJson.put((Object)"workflow_data_store", workflowDataStoreWithoutOutputs);
            JSONObject responsesObject = new JSONObject();
            List<State> states = this.getStateMachine().getStates();
            for (State state : states) {
                for (Action action : state.getActions()) {
                    if (Util.isNotNullOrEmpty(action.getOutputFilePath())) {
                        String actionResultsKey = this.generateActionResultsKey(state, action);
                        responsesObject.put((Object)actionResultsKey, (Object)this.generateResponseObject(action));
                        continue;
                    }
                    logger.info("No results found for Action :", action.getId());
                }
            }
            responseJson.put((Object)"responses", (Object)responsesObject);
        }
        catch (Exception e) {
            logger.error("Error while generating response json. Error :", e.getMessage());
            e.printStackTrace();
        }
        return responseJson;
    }

    private JSONObject generateResponseObject(Action action) {
        JSONObject responseObj = new JSONObject();
        try {
            responseObj.put((Object)"seq_id", (Object)action.getSeqId());
            responseObj.put((Object)"label", (Object)action.getLabel());
            responseObj.put((Object)"file_path", (Object)action.getOutputFilePath());
            responseObj.put((Object)"display_on_ui", (Object)action.getDisplayOnUi());
            responseObj.put((Object)"type", (Object)action.getActionType());
            if (action instanceof JdbcAction && ((JdbcAction)action).getChartConfig() != null) {
                responseObj.put((Object)"chart_config", (Object)((JdbcAction)action).getChartConfig());
            }
        }
        catch (Exception e) {
            logger.error("Error while generating response object. Error :", e.getMessage());
            e.printStackTrace();
        }
        return responseObj;
    }

    public String generatePrunedResponseFlattened(JSONObject prunedResponse) {
        StringBuilder strBuilder = new StringBuilder();
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            for (Object labelObj : prunedResponse.keySet()) {
                JSONObject valueJson;
                Object value;
                String label = String.valueOf(labelObj);
                JSONObject valueObj = (JSONObject)prunedResponse.get((Object)label);
                String description = valueObj.get((Object)"description") != null ? String.valueOf(valueObj.get((Object)"description")) : "";
                strBuilder.append(label).append("\n");
                if (Util.isNotNullOrEmpty(description)) {
                    strBuilder.append(description).append("\n");
                }
                if ((value = valueObj.get((Object)"data")) == null) {
                    value = "No data found";
                }
                if (value instanceof JSONObject) {
                    valueJson = (JSONObject)value;
                    value = gson.toJson((Object)valueJson);
                } else if (value instanceof JSONArray) {
                    valueJson = (JSONArray)value;
                    value = gson.toJson((Object)valueJson);
                }
                strBuilder.append(value).append("\n\n");
            }
        }
        catch (Exception e) {
            logger.error("Error while generating response txt file. Error: " + e.getMessage());
        }
        return strBuilder.toString();
    }

    public void generateResponses() {
        try {
            this.getWorkflowDataStore().removeIdsFromContext();
            this.setResponse(this.generateResponseJson());
            this.setPrunedResponse(this.generatePrunedResponseJson());
        }
        catch (Exception e) {
            logger.error("Error while generating responses. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public void uploadResponseFiles() {
        try {
            String prunedRespnoseJsonFlattened = this.generatePrunedResponseFlattened(this.getPrunedResponse());
            String responseJsonFilePath = this.generateFilePath("response.json");
            String prunedResponseFilePath = this.generateFilePath("response_pruned.txt");
            WorkflowFileUploader.uploadResponseFilesToS3(responseJsonFilePath, this.response.toJSONString(), prunedResponseFilePath, prunedRespnoseJsonFlattened, this.getS3PreSignedURLInfo(), new LogFormat());
        }
        catch (Exception e) {
            logger.error("Error while generating responses. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public void uploadWorkflowStateJson() {
        try {
            this.getWorkflowDataStore().removeIdsFromContext();
            String workflowStateFilePath = this.generateWorkflowStateFilePath();
            WorkflowFileUploader.uploadFileToS3(workflowStateFilePath, JsonObjectMapperUtil.getJsonStringFromObject(this), this.getS3PreSignedURLInfo(), new LogFormat());
        }
        catch (Exception e) {
            logger.error("Error while handling workflow_state.json. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public String generateActionResultsKey(State state, Action action) {
        return String.valueOf(state.getId()) + "_" + action.getId() + "_response";
    }

    public void failAllStates() {
        for (State state : this.stateMachine.getStates()) {
            state.errorAllActions();
        }
    }

    public static void main(String[] args) {
        String workflowStr = "{\r\n    \"workflow_data_store\": {\r\n        \"context\": {\r\n            \"execution_id\": \"38548785_240928001750_03980f5f-41b8-4c1b-9e5f-4b1f3b2be021\",\r\n            \"account_id\": \"30028807\",\r\n            \"question\": \"60131959\",\r\n            \"browser_websocket_connection_id\": \"exxbPefePHcCHDg=\",\r\n            \"saws_websocket_connection_id\": \"ex2x6dJIvHcCEBg=\",\r\n            \"saws_connector_id\": \"37681686\",\r\n            \"is_on_prem_saws\": true,\r\n            \"customer_id\": \"60131959\",\r\n            \"bot_id\": \"38548785\",\r\n            \"country\": \"TT\",\r\n            \"instance\": \"CLOUD_DEV\"\r\n        }\r\n    },\r\n    \"state_machine\": {\r\n        \"state_machine_name\": \"DvSum_Copilot_Workflow\",\r\n        \"start_state\": \"step_1\",\r\n        \"default_timeout\": 120,\r\n        \"states\": [\r\n            {\r\n                \"next_state\": \"step_2\",\r\n                \"state_name\": \"cerillion_and_sigma_dpm\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state_id\": \"step_1\",\r\n                \"actions\": [\r\n                    {\r\n                        \"method\": \"POST\",\r\n                        \"action_type\": \"WEBHOOK\",\r\n                        \"include_dvsum_metadata_in_payload\": true,\r\n                        \"label\": \"Cerillion CRM & Sigma DPM\",\r\n                        \"timeout\": 120,\r\n                        \"url\": \"\\/V1\\/trigger-Dvsum-bot\\/\",\r\n                        \"display_on_ui\": true,\r\n                        \"action_id\": \"api\",\r\n                        \"payload\": {\r\n                            \"dvsum_metadata\": {\r\n                                \"execution_id\": \"$$.execution_id\",\r\n                                \"instance\": \"$$.context.instance\"\r\n                            },\r\n                            \"customer_id\": \"$$.context.customer_id\",\r\n                            \"bu_id\": \"$$.context.country\"\r\n                        },\r\n                        \"output_key\": \"crm_data\",\r\n                        \"seq_id\": 1,\r\n                        \"source_id\": \"3421511\",\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"next_state\": \"step_2\",\r\n                \"state_name\": \"extract_mac_address\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state_id\": \"step_2\",\r\n                \"actions\": [\r\n                    {\r\n                        \"action_id\": \"mac_extractor\",\r\n                        \"action_type\": \"DATA_PROCESSOR\",\r\n                        \"output_key\": \"detected_mac_address\",\r\n                        \"function\": \"extractMacAddress\",\r\n                        \"seq_id\": 2,\r\n                        \"label\": \"Extracted Mac Address From Cerillion And Sigma DPM\",\r\n                        \"function_params\": {\r\n                            \"crm_data\": \"$$.crm_data\"\r\n                        },\r\n                        \"timeout\": 120,\r\n                        \"display_on_ui\": false,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"next_state\": \"step_4\",\r\n                \"state_name\": \"telemetry\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state_id\": \"step_3\",\r\n                \"actions\": [\r\n                    {\r\n                        \"query_parameters\": {\r\n                            \"parameters\": \"cmHost,cmtsHost,cmtsId,cmtsName,cmtsUptime,lastRegTime,fiberNodeId,inHomeScore,flapLastTime,flapTotalCnt,cmDocsisCapability,cmCollectStatus,cmUptime,cmDsBitrate,cmUsBitrate\"\r\n                        },\r\n                        \"method\": \"GET\",\r\n                        \"action_id\": \"cm_level\",\r\n                        \"action_type\": \"REST\",\r\n                        \"output_key\": \"telemetry_cm_level\",\r\n                        \"seq_id\": 3,\r\n                        \"label\": \"ServAssure NXT Telemetry: Cable Modem\",\r\n                        \"source_id\": \"3421511\",\r\n                        \"timeout\": 120,\r\n                        \"url\": \"\\/nxt-api\\/xray\\/v1.2\\/cm\\/{$$.detected_mac_address}\\/poll\",\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"next_state\": \"step_4\",\r\n                \"state_name\": \"get_scan_time_state\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state_id\": \"step_3\",\r\n                \"actions\": [\r\n                    {\r\n                        \"query_parameters\": {\r\n                            \"fnId\": \"$$.telemetry_cm_level.parameters.fiberNodeId.value\"\r\n                        },\r\n                        \"method\": \"GET\",\r\n                        \"action_id\": \"get_fiber_scan_time\",\r\n                        \"action_type\": \"REST\",\r\n                        \"output_key\": \"get_scan_time\",\r\n                        \"seq_id\": 8,\r\n                        \"label\": \"ServAssure NXT: Get Fiber Scan Time\",\r\n                        \"source_id\": \"3421511\",\r\n                        \"timeout\": 120,\r\n                        \"url\": \"\\/nxt-ui\\/rest\\/service\\/stats\\/getScanTime\",\r\n                        \"display_on_ui\": false,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"next_state\": \"END\",\r\n                \"state_name\": \"get_cm_stats\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state_id\": \"step_4\",\r\n                \"actions\": [\r\n                    {\r\n                        \"method\": \"POST\",\r\n                        \"action_type\": \"REST\",\r\n                        \"label\": \"ServAssure NXT: All CMs on the Node\",\r\n                        \"path_parameters\": {},\r\n                        \"timeout\": 120,\r\n                        \"url\": \"\\/nxt-ui\\/rest\\/service\\/stats\\/getCMStats\",\r\n                        \"display_on_ui\": false,\r\n                        \"query_parameters\": {},\r\n                        \"action_id\": \"get_all_cms_on_the_node\",\r\n                        \"payload\": {},\r\n                        \"output_key\": \"cm_stats_data\",\r\n                        \"seq_id\": 9,\r\n                        \"source_id\": \"3421511\",\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            },\r\n            {\r\n                \"next_state\": \"END\",\r\n                \"state_name\": \"modems_threshold_crossing\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"state_id\": \"step_5\",\r\n                \"actions\": [\r\n                    {\r\n                        \"action_id\": \"analyze_all_cm_stats\",\r\n                        \"action_type\": \"LAMBDA_CODE_EXECUTION\",\r\n                        \"output_key\": \"all_modems_threshold_crossing\",\r\n                        \"function\": \"nxt_all_modems_threshold_crossing\",\r\n                        \"seq_id\": 10,\r\n                        \"label\": \"ServAssure NXT: All Modems on Fiber Node Threshold Crossing\",\r\n                        \"function_params\": {\r\n                            \"cm_stats_json\": \"$$.cm_stats_data\",\r\n                            \"simultaneous_flap_count_configs\": {\r\n                                \"max_points_per_line\": 100,\r\n                                \"source_details\": \"$$$.source_configs.3421512\",\r\n                                \"online_status_value\": \"8\",\r\n                                \"time_window_minutes\": 60\r\n                            }\r\n                        },\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    },\r\n                    {\r\n                        \"action_id\": \"analyze_single_cm_stats\",\r\n                        \"action_type\": \"LAMBDA_CODE_EXECUTION\",\r\n                        \"output_key\": \"single_modem_threshold_crossing\",\r\n                        \"function\": \"nxt_single_modem_threshold_crossing\",\r\n                        \"seq_id\": 11,\r\n                        \"label\": \"ServAssure NXT: Single Modem Threshold Crossing\",\r\n                        \"function_params\": {\r\n                            \"required_actions\": [\r\n                                \"$$$.state_machine.states[]\"\r\n                            ]\r\n                        },\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true\r\n                    }\r\n                ]\r\n            }\r\n        ]\r\n    },\r\n    \"name\": \"LLA API Workflow\",\r\n    \"response_json_mapping\": [\r\n        {\r\n            \"source_mapping\": \"$$.crm_data\",\r\n            \"format\": \"JSON\",\r\n            \"description\": \"Cerillion CRM and Sigma DPM telemetry information\",\r\n            \"label\": \"cerillion_and_sigma_dpm\"\r\n        },\r\n        {\r\n            \"source_mapping\": \"$$.results.telemetry.cm_level\",\r\n            \"format\": \"JSON\",\r\n            \"description\": \"Cable modem telemetry information\",\r\n            \"label\": \"telemetry_cm_level\"\r\n        },\r\n        {\r\n            \"source_mapping\": \"$$.results.modems_threshold_crossing.analyze_all_cm_stats\",\r\n            \"format\": \"JSON\",\r\n            \"description\": \"All Modems Threshold Crossing for a given fiber node\",\r\n            \"label\": \"nxt_all_modems_threshold_crossing\"\r\n        },\r\n        {\r\n            \"source_mapping\": \"$$.results.modems_threshold_crossing.analyze_single_cm_stats\",\r\n            \"format\": \"JSON\",\r\n            \"description\": \"Single Modem Threshold Crossing details\",\r\n            \"label\": \"nxt_single_modem_threshold_crossing\"\r\n        }\r\n    ],\r\n    \"s3_pre_signed_URL\": {\r\n        \"fields\": {\r\n            \"signature\": \"7woXxu1pf0UhPpHbx8suRm0lUrc=\",\r\n            \"AWSAccessKeyId\": \"AKIA5TTPV3WAWJTSSTOB\",\r\n            \"key\": \"data-analysis\\/30028807\\/38548785_240928001750_03980f5f-41b8-4c1b-9e5f-4b1f3b2be021\\/${filename}\",\r\n            \"policy\": \"eyJleHBpcmF0aW9uIjogIjIwMjktMDktMjZUMTk6MTc6NTRaIiwgImNvbmRpdGlvbnMiOiBbeyJidWNrZXQiOiAiZHZzdW0tYXBwLWRhdGEtZGV2In0sIFsic3RhcnRzLXdpdGgiLCAiJGtleSIsICJkYXRhLWFuYWx5c2lzLzMwMDI4ODA3LzM4NTQ4Nzg1XzI0MDkyODAwMTc1MF8wMzk4MGY1Zi00MWI4LTRjMWItOWU1Zi00YjFmM2IyYmUwMjEvIl1dfQ==\"\r\n        },\r\n        \"url\": \"https:\\/\\/dvsum-app-data-dev.s3.amazonaws.com\\/\"\r\n    },\r\n    \"source_configs\": [\r\n        {\r\n            \"src_id\": \"3421511\",\r\n            \"domain\": \"8nje7gm3x6.execute-api.us-east-1.amazonaws.com\",\r\n            \"auth_info\": {\r\n                \"headers\": {\r\n                    \"x-api-key\": \"wXHzbVT55S79ckvHwjgOj1SkjZqNG0ZQ8SANtdvQ\"\r\n                },\r\n                \"auth_type\": \"API_KEY\"\r\n            }\r\n        },\r\n        {\r\n            \"src_id\": \"3421512\",\r\n            \"domain\": \"nxt.lla.com\",\r\n            \"auth_info\": {\r\n                \"headers\": {\r\n                    \"Authorization\": \"Basic base64(cablew\\/LLADvsum:p@ssw0rd)\",\r\n                    \"content-type\": \"application\\/json\"\r\n                },\r\n                \"auth_type\": \"BASIC\",\r\n                \"password\": \"p@ssw0rd\",\r\n                \"base64_encoding\": true,\r\n                \"username\": \"cablew\\/LLADvsum\"\r\n            }\r\n        }\r\n    ]\r\n}";
        try {
            JSONObject workflowJson = JsonUtil.parseToJsonObject(workflowStr);
            Workflow workflow = JsonObjectMapperUtil.getObjectFromJsonObject(workflowJson, Workflow.class);
            workflow.saveWorkflowState();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

