/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.Action.WebhookAction;
import com.dvsum.workflow.model.Ref.RefExecutionState;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class State {
    private static final CustomLogger logger = CustomLogger.getLogger(State.class);
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="state_name")
    private String stateName;
    @JsonProperty(value="state_type")
    private String stateType;
    @JsonProperty(value="next_state")
    private String nextState;
    @JsonProperty(value="next_state_on_error")
    private String nextStateOnError;
    @JsonProperty(value="current_execution_state")
    private String currentExecutionState;
    @JsonProperty(value="current_execution_status")
    private String currentExecutionStatus;
    @JsonProperty(value="proceed_on_failure")
    private Boolean proceedOnFailure;
    @JsonProperty(value="actions")
    private List<Action> actions;

    public String getNextStateOnError() {
        if (Util.isNullOrEmpty(this.nextStateOnError)) {
            this.nextStateOnError = "END";
        }
        return this.nextStateOnError;
    }

    public void getNextStateOnError(String nextStateOnError) {
        this.nextStateOnError = nextStateOnError;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public Boolean getProceedOnFailure() {
        if (this.proceedOnFailure == null) {
            this.proceedOnFailure = true;
        }
        return this.proceedOnFailure;
    }

    public void setProceedOnFailure(Boolean proceedOnFailure) {
        this.proceedOnFailure = proceedOnFailure;
    }

    public String getCurrentExecutionState() {
        if (this.currentExecutionState == null) {
            this.currentExecutionState = "NOT_STARTED";
        }
        return this.currentExecutionState;
    }

    public void setCurrentExecutionState(String currentExecutionState) {
        this.currentExecutionState = currentExecutionState;
    }

    public String getCurrentExecutionStatus() {
        return this.currentExecutionStatus;
    }

    public void setCurrentExecutionStatus(String currentExecutionStatus) {
        this.currentExecutionStatus = currentExecutionStatus;
    }

    public String getStateType() {
        if (Util.isNullOrEmpty(this.stateType)) {
            this.stateType = "task";
        }
        return this.stateType;
    }

    public void setStateType(String type) {
        this.stateType = type;
    }

    public String getNextState() {
        if (Util.isNullOrEmpty(this.nextState)) {
            this.nextState = "END";
        }
        return this.nextState;
    }

    public void setNextState(String nextState) {
        this.nextState = nextState;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String stateId) {
        this.id = stateId;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public void updateStateMetadata(String state, String status) {
        this.setCurrentExecutionState(state);
        this.setCurrentExecutionStatus(status);
    }

    public void errorAllActions() {
        this.setCurrentExecutionState("ERRORED");
        this.setCurrentExecutionStatus("FAILURE");
        for (Action action : this.getActions()) {
            action.setCurrentExecutionState("ERRORED");
            action.setCurrentExecutionStatus("FAILURE");
        }
    }

    public Action findAction(String actionId) {
        for (Action action : this.actions) {
            if (!action.getId().equals(actionId)) continue;
            return action;
        }
        return null;
    }

    public static State findPendingState(Map<String, State> states) {
        if (states == null) {
            return null;
        }
        State pendingState = null;
        try {
            for (String key : states.keySet()) {
                State state = states.get(key);
                if (!RefExecutionState.isPending(state.getCurrentExecutionState())) continue;
                pendingState = state;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pendingState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isStateErrored() {
        try {
            Action action;
            Iterator<Action> iterator = this.getActions().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (RefExecutionState.isErrored((action = iterator.next()).getCurrentExecutionState()));
            return false;
        }
        catch (Exception e) {
            logger.error("Error while checking if state is errored: " + e.getMessage(), e);
            return false;
        }
    }

    public boolean shouldStopExecution() {
        return this.isStateErrored() && this.getProceedOnFailure() == false;
    }

    public static void main(String[] args) {
        String stateJson = "{\r\n                \"state_id\": \"step_1\",\r\n                \"state_name\": \"cerillion_and_sigma_dpm\",\r\n                \"state_type\": \"TASK\",\r\n                \"next_state\": \"step_2\",\r\n                \"next_state_on_error\": \"END\",\r\n                \"current_execution_state\":\"\",\r\n                \"actions\": [\r\n                    {\r\n                        \"seq_id\": 1,\r\n                        \"action_id\": \"api\",\r\n                        \"action_type\": \"WEBHOOK\",\r\n                        \"label\": \"Cerillion CRM & Sigma DPM\",\r\n                        \"timeout\": 120,\r\n                        \"display_on_ui\": true,\r\n                        \"upload_raw_response_to_cloud\": true,\r\n                        \"include_dvsum_metadata_in_payload\": true,\r\n                        \"source_id\": \"3421511\",\r\n                        \"url\": \"/V1/trigger-Dvsum-bot/\",\r\n                        \"method\": \"POST\",\r\n                        \"payload\": {\r\n                            \"dvsum_metadata\": {\r\n                                \"execution_id\": \"$$.execution_id\",\r\n                                \"instance\": \"$$.context.instance\"\r\n                            },\r\n                            \"customer_id\": \"$$.context.customer_id\",\r\n                            \"bu_id\": \"$$.context.country\"\r\n                        },\r\n                        \"output_key\": \"crm_data\"\r\n                    }\r\n                ]\r\n            }";
        State state = JsonObjectMapperUtil.getObjectFromJsonString(stateJson, State.class);
        System.out.println(state.getId());
        Action action = state.getActions().get(0);
        System.out.println(action.getId());
        WebhookAction webhookAction = (WebhookAction)action;
        System.out.println(webhookAction.getIncludeDvSumMetadataInPayload());
    }
}

