/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.WorkflowDataStore;
import com.dvsum.workflow.service.StringExtractor;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResponseJsonMapping {
    private static final CustomLogger logger = CustomLogger.getLogger(ResponseJsonMapping.class);
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="source_mapping")
    private String sourceMapping;
    @JsonProperty(value="format")
    private String format;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFormat() {
        if (Util.isNullOrEmpty(this.format)) {
            this.format = "JSON";
        }
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getSourceMapping() {
        return this.sourceMapping;
    }

    public void setSourceMapping(String sourceMapping) {
        this.sourceMapping = sourceMapping;
    }

    public boolean isValidResponseJsonMapping(WorkflowDataStore workflowDataStore) {
        String outputKey = this.extractOutputKey();
        if (Util.isNullOrEmpty(outputKey) || outputKey.equalsIgnoreCase("context")) {
            return true;
        }
        return workflowDataStore.getOutputs().containsKey(outputKey);
    }

    public String extractOutputKey() {
        if (Util.isNullOrEmpty(this.getSourceMapping())) {
            return null;
        }
        try {
            String outputKey = StringExtractor.extractStringAfterDollarSigns(this.getSourceMapping());
            return outputKey;
        }
        catch (Exception e) {
            logger.error("Error while extracting output key from source mapping. Source mapping: ", this.getSourceMapping());
            e.printStackTrace();
            return null;
        }
    }
}

