/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model;

import com.dvsum.util.AuthorizationHeaderGenerator;
import com.dvsum.workflow.model.AuthInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.json.simple.JSONObject;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Header {
    @JsonProperty(value="x-api-key")
    private String apiKey;
    @JsonProperty(value="Authorization")
    private String authorization;

    public String getAPiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public static JSONObject getApiKeyHeader(List<Header> headers) {
        JSONObject headerJson = new JSONObject();
        for (Header header : headers) {
            headerJson.put((Object)"x-api-key", (Object)header.getAPiKey());
        }
        return headerJson;
    }

    public static JSONObject getBasicHeader(AuthInfo authInfo) {
        JSONObject headerJson = new JSONObject();
        String authorizationHeader = AuthorizationHeaderGenerator.generateBasicAuthorizationHeader(authInfo.getUserName(), authInfo.getPassword());
        headerJson.put((Object)"Authorization", (Object)authorizationHeader);
        return headerJson;
    }
}

