/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.logger.CustomLogger;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.Action.RestAction;
import com.dvsum.workflow.model.Ref.RefActionType;
import com.dvsum.workflow.model.Ref.RefExecutionState;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.json.simple.JSONObject;

public class WebhookAction
extends RestAction {
    private static final CustomLogger logger = CustomLogger.getLogger(WebhookAction.class);
    @JsonProperty(value="include_dvsum_metadata_in_payload")
    private boolean includeDvSumMetadataInPayload;

    public boolean getIncludeDvSumMetadataInPayload() {
        return this.includeDvSumMetadataInPayload;
    }

    public void setIncludeDvSumMetadataInPayload(boolean includeDvSumMetadataInPayload) {
        this.includeDvSumMetadataInPayload = includeDvSumMetadataInPayload;
    }

    @Override
    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        return super.execute(workflow, state, sourceConfig, webhookPayload);
    }

    public void saveActionResultsHandler(Workflow workflow, State state, String actionResults, String workflowStateGetUrlApi) {
        logger.info("This is a Webhook type action and it's current execution state is", this.getCurrentExecutionState());
        if (RefExecutionState.isNotStarted(this.getCurrentExecutionState())) {
            workflow.getStateMachine().setStartState(state.getId());
            workflow.getStateMachine().findState(state.getId()).updateStateMetadata("PENDING", null);
            this.updateActionMetadata(workflow.getWorkflowDataStore(), null, null, "PENDING", null);
            workflow.getWorkflowDataStore().updateStateIdAndActionIdInContext(state, this);
            this.startWebhookActionTimeoutCheck(workflow, state, workflowStateGetUrlApi);
        } else if (RefExecutionState.isPending(this.getCurrentExecutionState())) {
            this.executeActionCompletionFlow(workflow, state, actionResults);
        }
    }

    public boolean checkWebhookActionTimeout(Workflow workflow, State state, String workflowStateGetUrlApi) {
        block5: {
            block6: {
                Action loadedAction;
                int timePassed;
                if (!RefActionType.isWebhook(this.getActionType()) || !RefExecutionState.isPending(this.getCurrentExecutionState())) break block5;
                int timeout = (int)this.findTimeout(workflow);
                int sleepTime = timeout / 2 * 1000;
                do {
                    Thread.sleep(sleepTime);
                    Workflow loadedWorkflow = Workflow.loadWorkflowState(workflow.getWorkflowDataStore(), workflowStateGetUrlApi);
                    State loadedState = loadedWorkflow.getStateMachine().findState(state.getId());
                    loadedAction = loadedState.findAction(this.getId());
                    timePassed = (int)((System.currentTimeMillis() - this.getStartTime()) / 1000L);
                    logger.info("Execution time passed for action " + this.getId() + " is " + timePassed + " seconds. Timeout is " + timeout + " seconds.");
                    if (!RefActionType.isWebhook(loadedAction.getActionType()) || !RefExecutionState.isPending(loadedAction.getCurrentExecutionState())) break block6;
                } while (timePassed < timeout);
                logger.info("Current state ", loadedAction.getCurrentExecutionState());
                String errorMessage = String.format("Error: Action %s for state '%s' timed out after %d seconds.", this.getId(), state.getId(), timeout);
                this.handleError(workflow, state, errorMessage, true);
                workflow.saveWorkflowState();
                return false;
            }
            try {
                logger.info("Action state has changed from pending. Exiting timeout check.");
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("Thread interrupted while checking async action timeout. Error: ", e.getMessage());
                return false;
            }
            catch (Exception e) {
                logger.error("Error while checking async action timeout. Error: ", e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void startWebhookActionTimeoutCheck(Workflow workflow, State state, String workflowStateGetUrlApi) {
        new Thread(() -> {
            try {
                boolean result = this.checkWebhookActionTimeout(workflow, state, workflowStateGetUrlApi);
                logger.info("Async action timeout check completed with result: " + result);
            }
            catch (Exception e) {
                logger.error("Exception in async action timeout check: ", e);
            }
        }, "AsyncActionTimeoutChecker").start();
    }
}

