/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.AuthorizationHeaderGenerator;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.AuthInfo;
import com.dvsum.workflow.model.Ref.RefAuthType;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.DynamicParamExtractor;
import com.dvsum.workflow.service.URLGenerator;
import com.dvsum.workflow.service.WorkflowRequestHandler;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.json.simple.JSONObject;

public class RestAction
extends Action {
    private static final CustomLogger logger = CustomLogger.getLogger(RestAction.class);
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="method")
    private String method;
    @JsonProperty(value="payload")
    private Map<String, Object> payload;
    @JsonProperty(value="payload_mapping")
    private String payloadMapping;
    @JsonProperty(value="query_parameters")
    private Map<String, String> queryParameters;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPayloadMapping() {
        return this.payloadMapping;
    }

    public void setPayloadMapping(String payloadMapping) {
        this.payloadMapping = payloadMapping;
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    public void setPayload(Map<String, Object> payload) {
        this.payload = payload;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void applyQueryParams(Workflow workflow, State state) throws Exception {
        String urlWithQueryParams = this.getUrl();
        if (this.getQueryParameters() != null) {
            for (String paramKey : this.getQueryParameters().keySet()) {
                String paramVal = this.getQueryParameters().get(paramKey);
                String attr = DynamicParamExtractor.fetchDynamicParam(workflow, paramVal);
                if (Util.isNotNullOrEmpty(attr)) {
                    paramVal = attr.trim();
                    urlWithQueryParams = URLGenerator.concatQueryParam(paramKey, paramVal, urlWithQueryParams);
                    continue;
                }
                logger.info("Parameter " + paramKey + " is null or empty.");
                if (paramKey.equalsIgnoreCase("fnId")) {
                    throw new Exception("Error: Action " + state.getId() + "." + this.id + " failed. No device id or fiber id found. Skipping this.");
                }
                throw new Exception("Error: Action " + state.getId() + "." + this.id + " failed. Invalid value provided for query parameter " + paramKey + ". Skipping this.");
            }
            this.setUrl(urlWithQueryParams);
            logger.info("Setting URL = ", urlWithQueryParams);
        } else {
            logger.info("No query parameters are provided for action " + this.id);
        }
    }

    @Override
    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        logger.info("Executing Rest Api call action. Action id:", this.getId());
        String response = "";
        try {
            AuthInfo authInfo = sourceConfig.getAuthInfo();
            Map<String, Object> headers = this.generateRestApiHeaders(authInfo);
            String resolvedUrl = URLGenerator.generateAndResolveUrl(workflow, sourceConfig.getDomain(), this.getUrl());
            this.setUrl(resolvedUrl);
            this.applyQueryParams(workflow, state);
            logger.info("Resolved URL : ", this.getUrl());
            workflow.getWorkflowDataStore().updateStateIdAndActionIdInContext(state, this);
            Map<String, Object> payload = this.generatePayload(workflow, state);
            logger.info("Payload generated successfully for action:", this.getId());
            response = WorkflowRequestHandler.executeHttpRequest(workflow, state, this, headers, payload);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing Rest Api action. Error :", e.getMessage());
            this.handleError(workflow, state, e.getMessage(), false);
        }
        return response;
    }

    public Map<String, Object> generatePayload(Workflow workflow, State state) throws Exception {
        Map<String, Object> payload;
        if (Util.isNotNullOrEmpty(this.getPayloadMapping())) {
            Object payloadFromMapping = JsonUtil.parseToJson(DynamicParamExtractor.fetchDynamicParam(workflow, this.getPayloadMapping()));
            this.setPayload((Map<String, Object>)((JSONObject)payloadFromMapping));
        }
        if ((payload = DynamicParamExtractor.resolveMap(this.getPayload(), workflow)) == null) {
            throw new Exception("Error: Action " + state.getId() + "." + this.getId() + " failed. Invalid payload. Skipping this.");
        }
        return payload;
    }

    public Map<String, Object> generateRestApiHeaders(AuthInfo authInfo) {
        Map<String, Object> headers = authInfo.getHeaders();
        try {
            if (RefAuthType.isBasic(authInfo.getAuthType()) && authInfo.isBase64Encoding()) {
                String authorizationHeader = AuthorizationHeaderGenerator.generateBasicAuthorizationHeader(authInfo.getUserName(), authInfo.getPassword());
                headers.replace("Authorization", authorizationHeader);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while processing REST API headers. Error :", e.getMessage());
        }
        return headers;
    }
}

