/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.dataSource.DataSource;
import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.JsonObjectMapperUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.DynamicParamExtractor;
import com.dvsum.workflow.service.LogHandler;
import com.dvsum.workflow.service.URLGenerator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JdbcAction
extends Action {
    private static final CustomLogger logger = CustomLogger.getLogger(JdbcAction.class);
    private DataSourceFactory dataSourceFactory;
    @JsonProperty(value="query")
    protected String query;
    @JsonProperty(value="query_parameters")
    private Map<String, String> queryParameters;
    @JsonProperty(value="chart_config")
    protected JSONObject chartConfig;

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public JSONObject getChartConfig() {
        return this.chartConfig;
    }

    public void setChartConfig(JSONObject chartConfig) {
        this.chartConfig = chartConfig;
    }

    public void applyQueryParams(Workflow workflow) {
        String queryWithQueryParams = this.getQuery();
        if (this.getQueryParameters() != null) {
            for (String paramKey : this.getQueryParameters().keySet()) {
                String paramVal = this.getQueryParameters().get(paramKey);
                String attr = DynamicParamExtractor.fetchDynamicParam(workflow, paramVal);
                if (!Util.isNotNullOrEmpty(attr)) continue;
                paramVal = attr.trim();
                queryWithQueryParams = URLGenerator.replaceParam(paramKey, paramVal, queryWithQueryParams);
            }
            this.setQuery(queryWithQueryParams);
        }
    }

    @Override
    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        logger.info("Executing JDBC call action. Action id :", this.getId());
        String response = "";
        try {
            DataSource dataSource = this.connectToJDBC(sourceConfig);
            String resolvedQuery = URLGenerator.resolveDynamicPathParameters(workflow, this.getQuery());
            logger.info("Resolved query : ", resolvedQuery);
            try {
                LogHandler.sendQueryToUI(workflow.getWorkflowDataStore(), resolvedQuery);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error while sending query to websocket. Error: ", e.getMessage());
            }
            JSONObject responseJson = this.executeQueryOnJDBC(dataSource, resolvedQuery);
            JSONArray resultsJson = this.getResultsFromJdbcResponse(responseJson, state, this, workflow);
            response = resultsJson.toJSONString();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing JDBC call action. Error :", e.getMessage());
            this.handleError(workflow, state, "Unable to execute query. Error: " + e.getMessage(), false);
        }
        return response;
    }

    public JSONArray getResultsFromJdbcResponse(JSONObject responseJson, State state, Action action, Workflow workflow) {
        JSONArray responseArray = new JSONArray();
        if (responseJson.containsKey((Object)"results")) {
            responseArray = (JSONArray)responseJson.get((Object)"results");
        } else {
            action.handleError(workflow, state, "Error: Action " + state.getId() + "." + action.getId() + " Failed. Unable to retrieve query results.", false);
        }
        return responseArray;
    }

    public DataSource connectToJDBC(SourceConfig sourceConfig) {
        DataSource dataSource = null;
        try {
            String sourceType = sourceConfig.getSrcType();
            logger.info("Source Type: ", sourceType);
            logger.info(sourceConfig);
            JSONObject dataSourceConfigJson = JsonObjectMapperUtil.getJsonObjectFromObject(sourceConfig);
            logger.info("DS Config JSON: ", dataSourceConfigJson);
            logger.info("DataSource Factory:");
            logger.info(this.dataSourceFactory);
            dataSource = this.dataSourceFactory.getDataSource(String.valueOf(sourceType), dataSourceConfigJson, false, new LogFormat());
            logger.info("Data Source : ", dataSource);
            dataSource.connect();
            logger.info("Connection successful.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while connecting to JDBC. Error :", e.getMessage());
        }
        return dataSource;
    }

    public JSONObject executeQueryOnJDBC(DataSource dataSource, String query) {
        JSONObject response = new JSONObject();
        try {
            Connection connection = dataSource.connection;
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            boolean results_exist = rs.next();
            if (!results_exist) {
                throw new Exception("Result Set is empty.");
            }
            response = new JsonUtil().ResultSet2JSONObject(rs, false);
            dataSource.disconnect();
            logger.info("Connection terminated.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing query on JDBC. Error :", e.getMessage());
        }
        return response;
    }
}

