/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.GsonToJsonSimpleConverter;
import com.dvsum.util.JsonFlattener;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.Action;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.service.DynamicParamExtractor;
import com.dvsum.workflow.service.LogHandler;
import com.dvsum.workflow.service.MacAddressExtractor;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.JsonArray;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DataProcessorAction
extends Action {
    private static final CustomLogger logger = CustomLogger.getLogger(DataProcessorAction.class);
    @JsonProperty(value="function")
    protected String function;
    @JsonProperty(value="function_params")
    protected Map<String, Object> functionParams;

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public Map<String, Object> getFunctionParams() {
        return this.functionParams;
    }

    public void setFunctionParams(Map<String, Object> functionParams) {
        this.functionParams = functionParams;
    }

    @Override
    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        String response;
        block13: {
            response = null;
            try {
                block14: {
                    if (!Util.isNotNullOrEmpty(this.getFunction())) break block14;
                    switch (this.getFunction()) {
                        case "EXTRACT_MAC_ADDRESS": {
                            logger.info("Extracting mac address.");
                            response = this.extractMacAddress(workflow, this.resolveFunctionParams(workflow));
                            break;
                        }
                        case "CONVERT_TO_ARRAY": {
                            response = this.convertToArray(workflow, this.resolveFunctionParams(workflow));
                            if (response == null) {
                                throw new Exception("Unable to convert to array for action: " + this.getId());
                            }
                            break block13;
                        }
                    }
                    break block13;
                }
                throw new Exception("For " + state.getId() + "." + this.id + ", function is empty or null.");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage());
                throw e;
            }
        }
        return response;
    }

    public Map<String, Object> resolveFunctionParams(Workflow workflow) {
        return DynamicParamExtractor.resolveMap(this.functionParams, workflow);
    }

    public JSONObject getCrmDataFromFunctionParams(Map<String, Object> resolvedFunctionParams) {
        JSONObject crmData = new JSONObject();
        try {
            Object crmDataObj = resolvedFunctionParams.get("crm_data");
            crmData = crmDataObj instanceof String ? JsonUtil.parseToJsonObject(String.valueOf(crmDataObj)) : (JSONObject)crmDataObj;
        }
        catch (Exception e) {
            logger.error("Error while getting CRM Data from Function Params. Error: ", e.getMessage());
            e.printStackTrace();
        }
        return crmData;
    }

    public String extractMacAddress(Workflow workflow, Map<String, Object> resolvedFunctionParams) {
        JSONObject crmData = this.getCrmDataFromFunctionParams(resolvedFunctionParams);
        String macAddress = null;
        if (crmData != null) {
            try {
                macAddress = MacAddressExtractor.extractMacAddress(workflow, (Map<String, Object>)crmData);
                if (!Util.isNotNullOrEmpty(macAddress)) {
                    logger.info("No Mac Address found. Exiting...");
                    throw new Exception("No Mac Address found.");
                }
                LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), "MAC Address: " + macAddress);
                logger.info("Mac Address extracted: ", macAddress);
            }
            catch (Exception e) {
                logger.info("Error while getting mac address. Error: ", e.getMessage());
                LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), e.getMessage(), true, 500);
                workflow.getStateMachine().setCurrentExecutionState("ERRORED");
                workflow.failAllStates();
                workflow.saveWorkflowState();
            }
        } else {
            logger.info("Unable to get MAC Address because webhook payload is null or empty.");
        }
        return macAddress;
    }

    public String convertToArray(Workflow workflow, Map<String, Object> resolvedFunctionParams) throws Exception {
        String response = null;
        try {
            String sourceMapping = String.valueOf(resolvedFunctionParams.get("source_mapping"));
            String extractedVal = DynamicParamExtractor.fetchDynamicParam(workflow, sourceMapping);
            if (Util.isNullOrEmpty(extractedVal)) {
                throw new Exception("Could not extract object defined in source mapping: " + sourceMapping);
            }
            Object parsedValue = JsonUtil.parseToJson(extractedVal);
            Object value = JsonUtil.parseToJson(extractedVal);
            logger.info("Value instanceof:", value.getClass());
            if (value != null && value instanceof JsonArray) {
                value = GsonToJsonSimpleConverter.convertGsonArrayToSimpleArray((JsonArray)value);
                logger.info("Converting GSON Array to KEY VAL Pairs.");
                value = JsonFlattener.convertJsonArrayToKeyValPairs((JSONArray)value);
            } else if (value != null && value instanceof JSONArray) {
                logger.info("Converting JSON Array to Key Val Pairs.");
                value = JsonFlattener.convertJsonArrayToKeyValPairs((JSONArray)value);
            }
            if (value != null) {
                response = String.valueOf(value);
            } else {
                if (parsedValue != null) {
                    response = String.valueOf(parsedValue);
                }
                logger.error("Could not extract object defined in source mapping: ", sourceMapping);
            }
        }
        catch (Exception e) {
            logger.error("Error while converting to array. Error: ", e.getMessage());
            e.printStackTrace();
            throw e;
        }
        return response;
    }
}

