/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.workflow.model.Action;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.DateUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.dvsum.workflow.model.Action.CustomFunctionAction;
import com.dvsum.workflow.model.Action.DataProcessorAction;
import com.dvsum.workflow.model.Action.JdbcAction;
import com.dvsum.workflow.model.Action.LambdaCodeExecutionAction;
import com.dvsum.workflow.model.Action.RestAction;
import com.dvsum.workflow.model.Action.WebhookAction;
import com.dvsum.workflow.model.Ref.RefActionType;
import com.dvsum.workflow.model.Ref.RefExecutionState;
import com.dvsum.workflow.model.S3PreSignedURLInfo;
import com.dvsum.workflow.model.SourceConfig;
import com.dvsum.workflow.model.State;
import com.dvsum.workflow.model.Workflow;
import com.dvsum.workflow.model.WorkflowDataStore;
import com.dvsum.workflow.service.LogHandler;
import com.dvsum.workflow.service.WorkflowFileUploader;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.json.simple.JSONObject;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action_type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=RestAction.class, name="REST"), @JsonSubTypes.Type(value=WebhookAction.class, name="WEBHOOK"), @JsonSubTypes.Type(value=DataProcessorAction.class, name="DATA_PROCESSOR"), @JsonSubTypes.Type(value=JdbcAction.class, name="JDBC"), @JsonSubTypes.Type(value=LambdaCodeExecutionAction.class, name="LAMBDA_CODE_EXECUTION"), @JsonSubTypes.Type(value=CustomFunctionAction.class, name="CUSTOM_FUNCTION")})
public class Action {
    private static final CustomLogger logger = CustomLogger.getLogger(Action.class);
    @JsonProperty(value="id")
    protected String id;
    @JsonProperty(value="seq_id")
    protected int seqId;
    @JsonProperty(value="source_id")
    protected String sourceId;
    @JsonProperty(value="label")
    protected String label;
    @JsonProperty(value="action_type")
    protected String actionType;
    @JsonProperty(value="display_on_ui")
    protected boolean displayOnUi;
    @JsonProperty(value="current_execution_state")
    protected String currentExecutionState;
    @JsonProperty(value="current_execution_status")
    protected String currentExecutionStatus;
    @JsonProperty(value="start_time")
    protected Long startTime;
    @JsonProperty(value="end_time")
    protected Long endTime;
    @JsonProperty(value="output_file_path")
    protected String outputFilePath;
    @JsonProperty(value="raw_output_file_path")
    protected String rawOutputFilePath;
    @JsonProperty(value="timeout")
    protected Long timeout;
    @JsonProperty(value="upload_raw_response_to_cloud")
    protected Boolean uploadRawResponseToCloud;

    public String getActionType() {
        if (Util.isNotNullOrEmpty(this.actionType)) {
            return this.actionType;
        }
        if (this instanceof WebhookAction) {
            return "WEBHOOK";
        }
        if (this instanceof RestAction) {
            return "REST";
        }
        if (this instanceof WebhookAction) {
            return "WEBHOOK";
        }
        if (this instanceof LambdaCodeExecutionAction) {
            return "LAMBDA_CODE_EXECUTION";
        }
        if (this instanceof DataProcessorAction) {
            return "DATA_PROCESSOR";
        }
        if (this instanceof JdbcAction) {
            return "JDBC";
        }
        if (this instanceof CustomFunctionAction) {
            return "CUSTOM_FUNCTION";
        }
        logger.error("Unknown subclass of Action");
        return null;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public Boolean getUploadRawResponseToCloud() {
        if (this.uploadRawResponseToCloud == null) {
            this.uploadRawResponseToCloud = false;
        }
        return this.uploadRawResponseToCloud;
    }

    public void setUploadRawResponseToCloud(Boolean uploadRawResponseToCloud) {
        this.uploadRawResponseToCloud = uploadRawResponseToCloud;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public int getSeqId() {
        return this.seqId;
    }

    public void setSeqId(int seqId) {
        this.seqId = seqId;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public String getCurrentExecutionState() {
        if (this.currentExecutionState == null) {
            this.currentExecutionState = "NOT_STARTED";
        }
        return this.currentExecutionState;
    }

    public void setCurrentExecutionState(String currentExecutionState) {
        this.currentExecutionState = currentExecutionState;
    }

    public boolean getDisplayOnUi() {
        return this.displayOnUi;
    }

    public void setDisplayOnUi(boolean displayOnUi) {
        this.displayOnUi = displayOnUi;
    }

    public String getCurrentExecutionStatus() {
        return this.currentExecutionStatus;
    }

    public void setCurrentExecutionStatus(String currentExecutionStatus) {
        this.currentExecutionStatus = currentExecutionStatus;
    }

    public void setOutputFilePath(String outputFilePath) {
        this.outputFilePath = outputFilePath;
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setRawOutputFilePath(String rawOutputFilePath) {
        this.rawOutputFilePath = rawOutputFilePath;
    }

    public String getRawOutputFilePath() {
        return this.rawOutputFilePath;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String actionId) {
        this.id = actionId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void saveOutput(WorkflowDataStore workflowDataStore, String content, S3PreSignedURLInfo s3PreSignedUrlInfo, LogFormat logFormat) {
        try {
            Object parsedOutput = JsonUtil.parseToJson(content);
            workflowDataStore.setOutput(this.getId(), parsedOutput);
            WorkflowFileUploader.generateFile(this.outputFilePath, parsedOutput, s3PreSignedUrlInfo, logFormat);
            logger.info("Action output updated for action id :", this.getId());
        }
        catch (Exception e) {
            logger.error("Error while saving action output. Error :", e.getMessage());
            e.printStackTrace();
        }
    }

    public void clearOutputData(WorkflowDataStore workflowDataStore) {
        workflowDataStore.clearOutput(this.getId());
    }

    public String generateActionResultsFilePath(State state) {
        return String.format("%s_%s.json", state.getId(), this.id);
    }

    public String generateRawActionResultsFilePath(State state) {
        return String.format("%s_%s_raw.json", state.getId(), this.id);
    }

    public void updateActionMetadata(WorkflowDataStore workflowDataStore, String resultsFilePath, Object outputData, String state, String status) {
        this.setOutputFilePath(resultsFilePath);
        logger.info("Setting output for Action ", this.getId());
        workflowDataStore.setOutput(this.getId(), outputData);
        this.setCurrentExecutionState(state);
        this.setCurrentExecutionStatus(status);
    }

    public boolean saveActionResults(Workflow workflow, State state, String actionResults, String workflowStateGetUrlApi) {
        block8: {
            block9: {
                block7: {
                    try {
                        if (!RefActionType.isLambdaCodeExecution(this.getActionType())) break block7;
                        ((LambdaCodeExecutionAction)this).saveActionResultsHandler(workflow, state);
                        return false;
                    }
                    catch (Exception e) {
                        logger.error("Failed to save action results for action ID '" + state.getId() + "': ", e);
                        LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), "Error while saving action results for action '" + state.getId() + "': " + e.getMessage());
                        return true;
                    }
                }
                if (!RefExecutionState.isErrored(this.getCurrentExecutionState())) break block8;
                if (!RefExecutionState.isErrored(state.getCurrentExecutionState())) break block9;
                logger.info("Both state and action are in an errored state. Execution will be stopped.");
                return true;
            }
            logger.info("Action encountered an error; however, the state remains stable. Resuming execution...");
            return false;
        }
        if (RefActionType.isWebhook(this.getActionType())) {
            ((WebhookAction)this).saveActionResultsHandler(workflow, state, actionResults, workflowStateGetUrlApi);
        } else {
            this.executeActionCompletionFlow(workflow, state, actionResults);
        }
        return false;
    }

    public void handleError(Workflow workflow, State state, String errorMessage, boolean stopExecution) {
        try {
            State currentState = workflow.getStateMachine().findState(state.getId());
            logger.error(errorMessage);
            this.updateActionMetadata(workflow.getWorkflowDataStore(), null, null, "ERRORED", "FAILURE");
            boolean shouldStopExecutionBasedOnActionStates = currentState.shouldStopExecution();
            boolean isLastMsg = stopExecution || shouldStopExecutionBasedOnActionStates;
            LogHandler.sendLogMessageToUI(workflow.getWorkflowDataStore(), errorMessage, isLastMsg, 500);
            if (isLastMsg) {
                this.handleLastMessage(workflow, currentState);
            }
        }
        catch (Exception e) {
            logger.error("Unable to handle error. Error: ", e.getMessage());
            e.printStackTrace();
        }
    }

    public void handleLastMessage(Workflow workflow, State currentState) {
        logger.info("Setting", currentState.getCurrentExecutionState(), "state status to ERRORED.");
        workflow.getStateMachine().setCurrentExecutionState("ERRORED");
        currentState.updateStateMetadata("ERRORED", "FAILURE");
        currentState.setNextState(currentState.getNextStateOnError());
    }

    public int findExecutionTimePassed() {
        long currentTime = DateUtil.getCurrentEpochTimeInMillis();
        logger.info("CURRENT TIME : ", currentTime);
        logger.info("START TIME :", this.getStartTime());
        long timePassed = currentTime - this.getStartTime();
        logger.info("Time Passed : ", timePassed);
        int timePassedInSecs = (int)(timePassed * 1000L);
        logger.info("Time passed (in seconds) for action ", this.id, " is ", timePassedInSecs);
        return timePassedInSecs;
    }

    public String generateActionResultsDataToWrite(Object results) {
        String stringifiedResults = String.valueOf(results);
        stringifiedResults = this.removeDvsumMetadata(stringifiedResults);
        boolean isCloudSaws = Boolean.parseBoolean(FileUtil.getPropertyWithDefault("is.cloud.saws", "false"));
        if (!isCloudSaws) {
            stringifiedResults = CryptographicUtil.encrypt(stringifiedResults);
        }
        return stringifiedResults;
    }

    public String removeDvsumMetadata(String actionResults) {
        String modifiedActionResults = actionResults;
        String DVSUM_METADATA_KEY = "dvsum_metadata";
        try {
            JSONObject actionResultsJson = JsonUtil.parseToJsonObject(modifiedActionResults);
            if (actionResultsJson != null && actionResultsJson.containsKey((Object)DVSUM_METADATA_KEY)) {
                actionResultsJson.remove((Object)DVSUM_METADATA_KEY);
                modifiedActionResults = actionResultsJson.toJSONString();
            }
        }
        catch (Exception e) {
            logger.error("Error while removing DvSum Metadata from action results. Error :", e.getMessage());
            e.printStackTrace();
        }
        return modifiedActionResults;
    }

    public void executeActionCompletionFlow(Workflow workflow, State state, String actionResults) {
        try {
            Object outputData = JsonUtil.parseToJsonOrReturn(actionResults);
            String resultsFilePath = String.valueOf(workflow.generateBaseFilePath()) + this.generateActionResultsFilePath(state);
            String generatedFilePath = this.saveResultsToFile(workflow, state, actionResults, resultsFilePath);
            this.updateWorkflowForActionCompletion(workflow, state, outputData, generatedFilePath);
            logger.info("State and Action metadata updated.");
            LogHandler.sendActionCompletionLogToUI(workflow, state, this);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while executing action completion flow. Error: ", e.getMessage());
        }
    }

    public void updateWorkflowForActionCompletion(Workflow workflow, State state, Object outputData, String resultsFilePath) {
        try {
            State currentState = workflow.getStateMachine().findState(state.getId());
            currentState.updateStateMetadata("COMPLETED", "SUCCESS");
            this.updateActionMetadata(workflow.getWorkflowDataStore(), resultsFilePath, outputData, "COMPLETED", "SUCCESS");
            workflow.getWorkflowDataStore().updateStateIdAndActionIdInContext(state, this);
        }
        catch (Exception e) {
            logger.error("Error while updating workflow for action completion. Error: ", e.getMessage());
            e.printStackTrace();
        }
    }

    public String saveResultsToFile(Workflow workflow, State state, Object outputData, String resultsFilePath) {
        try {
            resultsFilePath = WorkflowFileUploader.generateFile(resultsFilePath, this.generateActionResultsDataToWrite(outputData), workflow.getS3PreSignedURLInfo(), new LogFormat());
            logger.info("Action results saved to", resultsFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while saving action results to file. Error: ", e.getMessage());
        }
        return resultsFilePath;
    }

    public long findTimeout(Workflow workflow) {
        Long timeout = 120L;
        if (this.getTimeout() == null) {
            if (workflow.getStateMachine().getDefaultTimeout() != null) {
                timeout = workflow.getStateMachine().getDefaultTimeout();
            }
        } else {
            timeout = this.getTimeout();
        }
        return timeout;
    }

    public String execute(Workflow workflow, State state, SourceConfig sourceConfig, JSONObject webhookPayload) throws Exception {
        return null;
    }
}

