/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.initializer.EmbeddedJetty;
import com.dvsum.util.FileUtil;
import java.util.Iterator;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class StatusUtil {
    private static CircularFifoQueue<Long> memoryQueue = new CircularFifoQueue(50);
    private static CircularFifoQueue<Integer> jobsQueue = new CircularFifoQueue(50);
    private static CircularFifoQueue<Integer> connectionsQueue = new CircularFifoQueue(50);
    private static int connectionCount = 0;
    public static int jobCount = 0;
    private static JSONObject sawsInfo = FileUtil.getSawsConfigurationInfo();
    public static Long maxjob = Long.parseLong(sawsInfo.get((Object)"poolSize").toString());
    public static Long maxConnection = Long.parseLong(sawsInfo.get((Object)"maxDatabaseConnAllowed").toString());

    public static void main(String[] args) {
        memoryQueue.add((Object)123L);
        memoryQueue.add((Object)124L);
        memoryQueue.add((Object)134L);
        memoryQueue.add((Object)125L);
        jobsQueue.add((Object)5);
        jobsQueue.add((Object)4);
        jobsQueue.add((Object)8);
        jobsQueue.add((Object)10);
        connectionsQueue.add((Object)2);
        connectionsQueue.add((Object)6);
        connectionsQueue.add((Object)7);
        connectionsQueue.add((Object)4);
    }

    public StatusUtil() {
        memoryQueue = new CircularFifoQueue(15);
        jobsQueue = new CircularFifoQueue(15);
        connectionsQueue = new CircularFifoQueue(15);
    }

    public static boolean isSawsBusy() {
        return connectionCount > 0 || jobCount > 0;
    }

    public static synchronized void monitorMemoryUsage() {
        Runtime rt = Runtime.getRuntime();
        long usedMB = (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L;
        memoryQueue.add((Object)usedMB);
    }

    public static Long memoryUsed() {
        Runtime rt = Runtime.getRuntime();
        return (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L;
    }

    public static void monitorJobs(Integer numberOfJobs) {
        jobsQueue.add((Object)numberOfJobs);
    }

    public static void monitorConnections(Integer numberOfConnections) {
        connectionsQueue.add((Object)numberOfConnections);
    }

    public static synchronized void incerementConnectionCount() {
        connectionCount = (long)connectionCount < maxConnection ? connectionCount + 1 : connectionCount;
    }

    public static synchronized void dcrementConnectionCount() {
        int n = connectionCount = connectionCount > 0 ? connectionCount - 1 : 0;
        if (connectionCount == 0) {
            jobCount = 0;
        }
    }

    public static synchronized void incrementJobCount() {
        jobCount = (long)jobCount < maxjob ? jobCount + 1 : jobCount;
    }

    public static synchronized void decrementJobCount() {
        jobCount = jobCount > 0 ? jobCount - 1 : 0;
    }

    public static int getJobsCount() {
        return jobCount >= 0 ? jobCount : 0;
    }

    public static int getConnectionCount() {
        return connectionCount >= 0 ? connectionCount : 0;
    }

    public static JSONObject getSatusData() {
        JSONObject statusInfo = new JSONObject();
        try {
            statusInfo.put((Object)"memory", (Object)StatusUtil.getMemoryInfo());
            statusInfo.put((Object)"jobs", (Object)StatusUtil.getJobInfo());
            statusInfo.put((Object)"dbConnections", (Object)StatusUtil.getConnectionInfo());
            statusInfo.put((Object)"serverStartTime", (Object)EmbeddedJetty.SERVER_START_TIME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusInfo;
    }

    private static JSONObject getMemoryInfo() throws Exception {
        Iterator memIterator = memoryQueue.iterator();
        JSONArray memoryData = new JSONArray();
        JSONObject memory = new JSONObject();
        Long totalMemory = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
        Long maxUsedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
        while (memIterator.hasNext()) {
            Long usedMemory = (Long)memIterator.next();
            if (usedMemory > maxUsedMemory) {
                maxUsedMemory = usedMemory;
            }
            JSONObject usedMemoryObj = new JSONObject();
            usedMemoryObj.put((Object)"limit", (Object)totalMemory);
            usedMemoryObj.put((Object)"used", (Object)usedMemory);
            if (usedMemory <= 0L) continue;
            memoryData.add((Object)usedMemoryObj);
        }
        memory.put((Object)"memoryLimit", (Object)totalMemory);
        Long usedPercet = 0L;
        if (maxUsedMemory > 0L) {
            usedPercet = maxUsedMemory > totalMemory ? 100L : maxUsedMemory * 100L / totalMemory;
        }
        memory.put((Object)"memoryUsage", (Object)(usedPercet + "%"));
        memory.put((Object)"data", (Object)memoryData);
        return memory;
    }

    private static JSONObject getConnectionInfo() throws Exception {
        Iterator conecIterator = connectionsQueue.iterator();
        JSONArray connectionDataList = new JSONArray();
        JSONObject connection = new JSONObject();
        Integer maxUsedconnection = 0;
        while (conecIterator.hasNext()) {
            Integer usedconnection = (Integer)conecIterator.next();
            if (usedconnection > maxUsedconnection) {
                maxUsedconnection = usedconnection;
            }
            JSONObject usedconnectionObj = new JSONObject();
            usedconnectionObj.put((Object)"limit", (Object)maxConnection);
            usedconnectionObj.put((Object)"used", (Object)usedconnection);
            Long usedConnectionPercentage = 0L;
            if (usedconnection > 0) {
                usedConnectionPercentage = (long)usedconnection.intValue() > maxConnection ? 100L : (long)(usedconnection * 100) / maxConnection;
            }
            usedconnectionObj.put((Object)"usedPercent", (Object)(usedConnectionPercentage + "%"));
            connectionDataList.add((Object)usedconnectionObj);
        }
        connection.put((Object)"connectionLimit", (Object)maxConnection);
        connection.put((Object)"data", (Object)connectionDataList);
        if (connectionDataList.size() <= 0) {
            JSONObject usedconnectionObj = new JSONObject();
            usedconnectionObj.put((Object)"limit", (Object)maxConnection);
            usedconnectionObj.put((Object)"used", (Object)0);
            connectionDataList.add((Object)usedconnectionObj);
        }
        return connection;
    }

    private static JSONObject getJobInfo() throws Exception {
        JSONObject usedjobObj;
        Iterator jobIterator = jobsQueue.iterator();
        JSONArray jobDataList = new JSONArray();
        JSONObject job = new JSONObject();
        Integer maxRuningJob = 0;
        while (jobIterator.hasNext()) {
            Integer runingjobs = (Integer)jobIterator.next();
            if (runingjobs > maxRuningJob) {
                maxRuningJob = runingjobs;
            }
            usedjobObj = new JSONObject();
            usedjobObj.put((Object)"limit", (Object)maxjob);
            usedjobObj.put((Object)"used", (Object)runingjobs);
            Long runingJobsPercent = 0L;
            if (runingjobs > 0) {
                runingJobsPercent = (long)runingjobs.intValue() > maxjob ? 100L : (long)(runingjobs * 100) / maxjob;
            }
            usedjobObj.put((Object)"runingJobs", (Object)(runingJobsPercent + "%"));
            jobDataList.add((Object)usedjobObj);
        }
        job.put((Object)"jobLimit", (Object)maxjob);
        Long usedPercet = 0L;
        if (maxRuningJob > 0) {
            usedPercet = (long)maxRuningJob.intValue() > maxjob ? 100L : (long)(maxRuningJob * 100) / maxjob;
        }
        job.put((Object)"numberOfJobs", (Object)(usedPercet + "%"));
        job.put((Object)"data", (Object)jobDataList);
        if (jobDataList.size() <= 0) {
            usedjobObj = new JSONObject();
            usedjobObj.put((Object)"limit", (Object)maxjob);
            usedjobObj.put((Object)"used", (Object)0);
            jobDataList.add((Object)usedjobObj);
        }
        return job;
    }
}

