/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.initializer.EmbeddedJetty;
import com.dvsum.logger.CustomLogger;
import com.dvsum.services.SawsUpgradeService;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class SelfSignedHttps {
    private static final CustomLogger logger = CustomLogger.getLogger(SelfSignedHttps.class);

    public static void main(String[] args) {
        SelfSignedHttps.executePostRequest("https://localhost:8443/DVSUM/webserviceApi/writeBackPartTwo", Arrays.asList("3123", "1231", "123", "12312"), Arrays.asList("transactionId", "testId", "userId", "token"));
    }

    public static String downloadFile(String url, Object[] parameterValues, Object[] parametersName) {
        HttpGet httpGet = new HttpGet(url);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        try {
            Integer requestTimeout;
            StringBuilder requestUrl = new StringBuilder(url);
            if (parameterValues != null && parameterValues.length > 0) {
                int i = 1;
                while (i <= parameterValues.length) {
                    parameters.add(new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                    ++i;
                }
                String querystring = URLEncodedUtils.format(parameters, (String)"utf-8");
                requestUrl.append("?");
                requestUrl.append(querystring);
            }
            if ((requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"))) != null) {
                httpGet.setConfig(SelfSignedHttps.getRequestConfig(requestTimeout));
            }
            CloseableHttpResponse response = SelfSignedHttps.getCloseableHttpClient().execute((HttpUriRequest)httpGet);
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = null;
            long totalSize = 0L;
            if (status >= 200 && status <= 300) {
                int inByte;
                entity = response.getEntity();
                InputStream is = entity.getContent();
                totalSize = entity.getContentLength();
                File outputFile = new File(SawsUpgradeService.TEMP_SAWS_FILE);
                FileOutputStream fos = new FileOutputStream(outputFile);
                System.out.println("Downloading...");
                while ((inByte = is.read()) != -1) {
                    fos.write(inByte);
                    double newPercentage = SelfSignedHttps.getPercentage(totalSize, outputFile.length());
                    newPercentage = Util.roundDouble(newPercentage, 2);
                    SelfSignedHttps.printAbsolutePercentage(newPercentage);
                }
                is.close();
                fos.close();
                return "SUCCESS";
            }
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            e.printStackTrace();
        }
        return null;
    }

    public static String downloadFileNew(String url, Object[] parameterValues, Object[] parametersName) {
        int status;
        String responseString;
        block7: {
            SelfSignedHttps.disableCertificateValidation();
            logger.info("downloadingFile ........." + url);
            responseString = null;
            ArrayList<BasicNameValuePair> getParameters = new ArrayList<BasicNameValuePair>();
            StringBuilder requestUrl = new StringBuilder(url);
            if (parameterValues != null && parameterValues.length > 0) {
                int i = 1;
                while (i <= parameterValues.length) {
                    getParameters.add(new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                    ++i;
                }
                String querystring = URLEncodedUtils.format(getParameters, (String)"utf-8");
                requestUrl.append("?");
                requestUrl.append(querystring);
            }
            System.out.println("Downloading...");
            HttpGet httpget = new HttpGet(requestUrl.toString());
            Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"));
            if (requestTimeout != null) {
                httpget.setConfig(SelfSignedHttps.getRequestConfig(requestTimeout));
            }
            CloseableHttpResponse response = SelfSignedHttps.getCloseableHttpClient().execute((HttpUriRequest)httpget);
            status = response.getStatusLine().getStatusCode();
            HttpEntity entity = null;
            if (status < 200 || status > 300) break block7;
            entity = response.getEntity();
            InputStream is = entity.getContent();
            File outputFile = new File(SawsUpgradeService.TEMP_SAWS_FILE);
            FileOutputStream fos = new FileOutputStream(outputFile);
            int read = 0;
            byte[] buffer = new byte[32768];
            while ((read = is.read(buffer)) > 0) {
                fos.write(buffer, 0, read);
            }
            fos.close();
            is.close();
            System.out.println("Download Complete..." + SawsUpgradeService.TEMP_SAWS_FILE);
            return "SUCCESS";
        }
        try {
            logger.debug("Request Compelet ......... Status" + status);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return responseString;
    }

    private static Double getPercentage(Long total, Long value) {
        Double result = value.doubleValue() / total.doubleValue() * 100.0;
        return result;
    }

    private static void printAbsolutePercentage(double value) {
        String valStr = String.valueOf(value);
        String valDecimal = valStr.substring(valStr.indexOf(".") + 1, valStr.length());
        double valDouble = Double.parseDouble(valDecimal);
        if (valDouble == 0.0) {
            System.out.println(String.valueOf(value) + "%");
        }
    }

    public static String executeGetRequest(String url, Object[] parameterValues, Object[] parametersName) {
        return SelfSignedHttps.executeGetRequest(url, parameterValues, parametersName, null);
    }

    public static String executeGetRequest(String url, Object[] parameterValues, Object[] parametersName, String API_KEY) {
        SelfSignedHttps.disableCertificateValidation();
        logger.info("Polling ........." + url);
        String responseString = null;
        ArrayList<BasicNameValuePair> getParameters = new ArrayList<BasicNameValuePair>();
        try {
            StringBuilder requestUrl = new StringBuilder(url);
            if (parameterValues != null && parameterValues.length > 0) {
                int i = 1;
                while (i <= parameterValues.length) {
                    getParameters.add(new BasicNameValuePair(parametersName[i - 1].toString(), parameterValues[i - 1].toString()));
                    ++i;
                }
                String querystring = URLEncodedUtils.format(getParameters, (String)"utf-8");
                requestUrl.append("?");
                requestUrl.append(querystring);
            }
            HttpGet httpget = new HttpGet(requestUrl.toString());
            httpget.setHeader("x-api-key", API_KEY);
            Integer requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.get", "1800000"));
            if (requestTimeout != null) {
                httpget.setConfig(SelfSignedHttps.getRequestConfig(requestTimeout));
            }
            CloseableHttpResponse response = SelfSignedHttps.getCloseableHttpClient().execute((HttpUriRequest)httpget);
            responseString = SelfSignedHttps.handleResponse((HttpResponse)response);
            logger.info("Request Compelet .........");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return responseString;
    }

    public static RequestConfig getRequestConfig(int requestTimeout) {
        return RequestConfig.custom().setConnectTimeout(requestTimeout).setConnectionRequestTimeout(requestTimeout).setSocketTimeout(requestTimeout).build();
    }

    public static String executePostRequest(String url, List<String> parameterValues, List<String> parametersName) {
        SelfSignedHttps.disableCertificateValidation();
        logger.info("Posting to ........." + url);
        String responseString = null;
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        try {
            Integer requestTimeout;
            HttpPost httppost = new HttpPost(url);
            if (parameterValues != null && parameterValues.size() > 0) {
                int i = 1;
                while (i <= parameterValues.size()) {
                    postParameters.add(new BasicNameValuePair(parametersName.get(i - 1), parameterValues.get(i - 1)));
                    ++i;
                }
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
            }
            if ((requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"))) != null) {
                httppost.setConfig(SelfSignedHttps.getRequestConfig(requestTimeout));
            }
            CloseableHttpResponse response = SelfSignedHttps.getCloseableHttpClient().execute((HttpUriRequest)httppost);
            responseString = SelfSignedHttps.handleResponse((HttpResponse)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return responseString;
    }

    public static String executePostRequest(String url, List<String> parameterValues, List<String> parametersName, String API_KEY) {
        SelfSignedHttps.disableCertificateValidation();
        logger.info("Posting to ........." + url);
        String responseString = null;
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        try {
            Integer requestTimeout;
            HttpPost httppost = new HttpPost(url);
            if (parameterValues != null && parameterValues.size() > 0) {
                int i = 1;
                while (i <= parameterValues.size()) {
                    postParameters.add(new BasicNameValuePair(parametersName.get(i - 1), parameterValues.get(i - 1)));
                    ++i;
                }
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
            }
            if ((requestTimeout = Integer.valueOf(FileUtil.getPropertyWithDefault("request.timeout.post", "1800000"))) != null) {
                httppost.setConfig(SelfSignedHttps.getRequestConfig(requestTimeout));
            }
            httppost.setHeader("x-api-key", API_KEY);
            CloseableHttpResponse response = SelfSignedHttps.getCloseableHttpClient().execute((HttpUriRequest)httppost);
            responseString = SelfSignedHttps.handleResponse((HttpResponse)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return responseString;
    }

    public static String executeLoginRequest(String url, String emailAddress, String password) {
        SelfSignedHttps.disableCertificateValidation();
        logger.debug("SAWS login........." + url);
        if (Util.isNullOrEmpty(emailAddress) || Util.isNullOrEmpty(password)) {
            return null;
        }
        String responseString = null;
        ArrayList<BasicNameValuePair> postParameters = new ArrayList<BasicNameValuePair>();
        try {
            HttpPost httppost = new HttpPost(url);
            postParameters.add(new BasicNameValuePair("emailAddress", CryptographicUtil.encrypt(emailAddress)));
            postParameters.add(new BasicNameValuePair("password", CryptographicUtil.encrypt(password)));
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParameters));
            CloseableHttpResponse response = SelfSignedHttps.getCloseableHttpClient().execute((HttpUriRequest)httppost);
            responseString = SelfSignedHttps.handleResponse((HttpResponse)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
        return responseString;
    }

    private static String handleResponse(HttpResponse response) throws ParseException, IOException {
        int status = response.getStatusLine().getStatusCode();
        HttpEntity entity = null;
        if (status >= 200 && status < 300) {
            entity = response.getEntity();
            return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
        }
        logger.info("Request Failed");
        throw new ClientProtocolException("Unexpected response status: " + status);
    }

    private static CloseableHttpClient getCloseableHttpClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)SelfSignedHttps.getSSLConnectionSocketFactory()).build();
        return httpclient;
    }

    private static SSLConnectionSocketFactory getSSLConnectionSocketFactory() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        sslConnectionSocketFactory = new SSLConnectionSocketFactory(SelfSignedHttps.getSSLContext(), new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        return sslConnectionSocketFactory;
    }

    private static SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        SSLContext sslcontext = null;
        sslcontext = SSLContexts.custom().loadTrustMaterial(new File(EmbeddedJetty.KEYSTORE_PATH), EmbeddedJetty.KEYSTORE_PASS.toCharArray(), (TrustStrategy)new TrustSelfSignedStrategy()).build();
        return sslcontext;
    }

    public static void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getRequestData(HttpServletRequest request) {
        ServletInputStream inputStream = null;
        String encryptedMessage = null;
        try {
            inputStream = request.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream);
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String read = bufferedReader.readLine();
            while (read != null) {
                stringBuilder.append(read);
                read = bufferedReader.readLine();
                if (read == null) continue;
                stringBuilder.append("\n");
            }
            encryptedMessage = stringBuilder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Exception: ", e);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return encryptedMessage;
    }
}

