/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.util.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class MultipartFileUploader {
    private static final CustomLogger logger = CustomLogger.getLogger(MultipartFileUploader.class);

    public static void main(String[] args) {
        try {
            String filePath = "/Users/shafaqatali/Downloads/scan_source_metadata1.json";
            String s3URL = "{\n        \"url\": \"https://s3-bucket-stage-new.dvsum.ai/s3-files/upload/\",\n        \"fields\": {\n            \"key\": \"input-catalog/83f7d0e5-c913-4d6d-badf-eddee0286e9f/${filename}\",\n            \"x-amz-algorithm\": \"AWS4-HMAC-SHA256\",\n            \"x-amz-credential\": \"ASIARVZBTIYDFC54SCZH/20241226/us-east-2/s3/aws4_request\",\n            \"x-amz-date\": \"20241226T211345Z\",\n            \"x-amz-security-token\": \"7c0ead5a-f32d-4b31-9747-b861e40fa171\",\n            \"policy\": \"eyJleHBpcmF0aW9uIjogIjIwMjUtMDEtMDFUMjE6MTM6NDVaIiwgImNvbmRpdGlvbnMiOiBbWyJzdGFydHMtd2l0aCIsICIka2V5IiwgImlucHV0LWNhdGFsb2cvIl0sIHsiYnVja2V0IjogImR2c3VtLWFwcC1kYXRhLXN0YWdlLW9oaW8ifSwgWyJzdGFydHMtd2l0aCIsICIka2V5IiwgImlucHV0LWNhdGFsb2cvODNmN2QwZTUtYzkxMy00ZDZkLWJhZGYtZWRkZWUwMjg2ZTlmLyJdLCB7IngtYW16LWFsZ29yaXRobSI6ICJBV1M0LUhNQUMtU0hBMjU2In0sIHsieC1hbXotY3JlZGVudGlhbCI6ICJBU0lBUlZaQlRJWURGQzU0U0NaSC8yMDI0MTIyNi91cy1lYXN0LTIvczMvYXdzNF9yZXF1ZXN0In0sIHsieC1hbXotZGF0ZSI6ICIyMDI0MTIyNlQyMTEzNDVaIn0sIHsieC1hbXotc2VjdXJpdHktdG9rZW4iOiAiSVFvSmIzSnBaMmx1WDJWakVGMGFDWFZ6TFdWaGMzUXRNaUpHTUVRQ0lDcktqaTUxS3FONzJqc1ovUEVsUGhlYVVSOVYvN29aSVovZFBDRVFZVzB2QWlBbVlhcDRDS2NxdlV1V3I5Ulkxd2hRbEtRc01JMlZveUU5TUlUVFFEVTVqeXI2QWdnMkVBSWFEREV4TlRRNU56Y3hOVEl3TmlJTUtwRUFwVEtib1pGSmhtOEVLdGNDay8xL05qeEJwVXN2ckRNU2ZPY2k0UU0vTjRtaTJLdmZsTzczOW5CSk1vR2lxdWtJSE96R1lRbFNGdFlKVTZ0ZFhjdGxFa0pPdTZNUFlCTTQ3Y0JhaXpMSWljZVp1andJbkxIMjc5bVM5dUtZeDFKcENCV0JrenMwWVBTcXFqY045alBxVXlybTdVa1FNdG51djBKZk8xaUhGeENtcCtJbVVqbTcwMXVnamVzS0xNemQ5UEt4R0RwbzhiSE00U3FSckJaMjRIS2E0V1NhVFFDamZCSWJCREl4Z1FGaXY4V3ZPU1hrSDBNM0dhRFgxZkZLTThtN1pKc0R3TGx4eHNHYzl4OXBTRUhOSjdicFkvU2lMdVBkT0VqWmJrUTdXeUp6MnVJbVJ6YkpQQk9BbDJuVldsRUJFa2JjRUFPNkJTOU5lbHBQbjloWnNkSFJ3bm5pVXd5UjYxV0pGbVEvSVVEVnZaMjZUTXpKYjlvVWR1UUpyVSswOUd5bkdtTVFwOVp3TTBnNFRGVU5CMWRVMldSVUpSaHVCV2JjRVVhbVZ3cUV4U1AweGdYdGZ3MmhDTTB3dVhzWU9GMXZJckl1VVRBdWtKeTF4bzhId2pDRmpyZTdCanFmQVpMd1VRK2U2Y3VhdHBwTE5JczdxZXFjK1lqWmlQc2s4TFlYcTArUzdxcGJXWUpyYmxVV0xjWlNmZW8yeWM3V3pmYUVEU1llZW1BZHNlcDVEZkd2ZU5CWmNMQ1BPNVRiTmRrcFdzVWFySFhqc1dCUkUzT251YnB1YWxaeW0vWnV6bG1MVC9acHN6bmRSUU5ndWFnYlhFYnRvbjY2cU15NkJqVy9VZG5Rd0pFZXRUeFM5K0JXVlU4NHgwMlErVnhoSnpCNkk5KzJxanZ4U1pZUWNiZ0R5UT09In1dfQ==\",\n            \"x-amz-signature\": \"626cb4fc68bd4b614425d42aaa18fd4a3a23084b4664d4ef146213d91be7ba72\",\n            \"signature\": \"P9dNxj7uEh9qlQ3agVtVCHhYCb4DG6HhSY1Ul4hc_nI=\"\n        }\n    }";
            JSONObject s3PreSignedURL = JsonUtil.parseToJsonObject(s3URL);
            MultipartFileUploader.uploadGzipFileToS3(filePath, s3PreSignedURL);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static int uploadFileToS3AndGetStatus(String filePath, JSONObject s3PreSignedURL, LogFormat logFormat) {
        int statusCode = 500;
        try {
            JSONObject fields = (JSONObject)s3PreSignedURL.get((Object)"fields");
            CloseableHttpClient httpclient = MultipartFileUploader.createHttpClientWithNoSSLValidation();
            HttpPost httppost = new HttpPost(String.valueOf(s3PreSignedURL.get((Object)"url")));
            httppost.addHeader("Accept", "application/json");
            File fileToUse = new File(filePath);
            FileBody data = new FileBody(fileToUse);
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("signature", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"signature"))));
            if (fields.containsKey((Object)"x-amz-security-token")) {
                reqEntity.addPart("x-amz-security-token", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"x-amz-security-token"))));
            }
            reqEntity.addPart("AWSAccessKeyId", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"AWSAccessKeyId"))));
            reqEntity.addPart("policy", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"policy"))));
            reqEntity.addPart("key", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"key"))));
            reqEntity.addPart("file", (ContentBody)data);
            httppost.setEntity((HttpEntity)reqEntity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            statusCode = response.getStatusLine().getStatusCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), e.toString());
            statusCode = 500;
        }
        return statusCode;
    }

    private static CloseableHttpClient createHttpClientWithNoSSLValidation() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (hostname, session) -> true);
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
    }

    public static String uploadFileToS3(String filePath, JSONObject s3PreSignedURL, LogFormat logFormat) {
        String uploadedFileKey = null;
        try {
            JSONObject fields = (JSONObject)s3PreSignedURL.get((Object)"fields");
            CloseableHttpClient httpclient = MultipartFileUploader.createHttpClientWithNoSSLValidation();
            HttpPost httppost = new HttpPost(String.valueOf(s3PreSignedURL.get((Object)"url")));
            httppost.addHeader("Accept", "application/json");
            File fileToUse = new File(filePath);
            FileBody data = new FileBody(fileToUse);
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("signature", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"signature"))));
            if (fields.containsKey((Object)"x-amz-security-token")) {
                reqEntity.addPart("x-amz-security-token", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"x-amz-security-token"))));
            }
            reqEntity.addPart("AWSAccessKeyId", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"AWSAccessKeyId"))));
            reqEntity.addPart("policy", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"policy"))));
            reqEntity.addPart("key", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"key"))));
            reqEntity.addPart("file", (ContentBody)data);
            httppost.setEntity((HttpEntity)reqEntity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity resEntity = response.getEntity();
            uploadedFileKey = String.valueOf(fields.get((Object)"key")).replace("${filename}", MultipartFileUploader.getFileNameFromFilePath(filePath));
        }
        catch (Exception e) {
            logger.error("Error: ", e);
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), e.toString());
        }
        return uploadedFileKey;
    }

    private static String getFileNameFromFilePath(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        String fileName = path.getFileName().toString();
        return fileName;
    }

    public static void uploadGzipFileToS3(String filePath, JSONObject s3PreSignedURL) {
        try {
            System.out.println(s3PreSignedURL.toJSONString());
            JSONObject fields = (JSONObject)s3PreSignedURL.get((Object)"fields");
            CloseableHttpClient httpclient = MultipartFileUploader.createHttpClientWithNoSSLValidation();
            HttpPost httppost = new HttpPost(String.valueOf(s3PreSignedURL.get((Object)"url")));
            httppost.addHeader("Accept", "application/zip");
            File file = new File(filePath);
            String fileParentDirectory = file.getParent();
            String filename = file.getName();
            int extensionIndex = filename.lastIndexOf(46);
            String filenameWithoutExtension = filename.substring(0, extensionIndex);
            File compressedFile = new File(String.valueOf(fileParentDirectory) + "/" + filenameWithoutExtension + ".zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(compressedFile));
            ZipEntry zipEntry = new ZipEntry(filename);
            zipOutputStream.putNextEntry(zipEntry);
            Files.copy(file.toPath(), zipOutputStream);
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            FileBody fileBody = new FileBody(compressedFile, ContentType.APPLICATION_OCTET_STREAM, compressedFile.getName());
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart("signature", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"signature"))));
            if (fields.containsKey((Object)"x-amz-security-token")) {
                reqEntity.addPart("x-amz-security-token", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"x-amz-security-token"))));
            }
            reqEntity.addPart("AWSAccessKeyId", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"AWSAccessKeyId"))));
            reqEntity.addPart("policy", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"policy"))));
            reqEntity.addPart("key", (ContentBody)new StringBody(String.valueOf(fields.get((Object)"key"))));
            reqEntity.addPart("file", (ContentBody)fileBody);
            httppost.setEntity((HttpEntity)reqEntity);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            System.out.println(response);
            logger.info("file upload response" + response.toString());
            HttpEntity resEntity = response.getEntity();
            logger.info("File uploaded to s3: " + filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

