/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.simple.JSONObject;

public class JsonObjectMapperUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static ObjectWriter objectWriter = objectMapper.writer().withDefaultPrettyPrinter();

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static <T> T getObjectFromJsonString(String json, Class<T> valueType) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes("UTF-8"));
            return (T)objectMapper.readValue((InputStream)inputStream, valueType);
        }
        catch (JsonProcessingException e) {
            System.err.println("Error occurred while processing JSON: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IO error occurred: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T getObjectFromJsonObject(JSONObject json, Class<T> valueType) {
        return JsonObjectMapperUtil.getObjectFromJsonString(json.toJSONString(), valueType);
    }

    public static String getJsonStringFromObject(Object object) {
        String json = "";
        try {
            json = objectWriter.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            System.err.println("Json processing error occurred: " + e.getMessage());
            e.printStackTrace();
        }
        return json;
    }

    public static JSONObject getJsonObjectFromObject(Object object) {
        JSONObject jsonObject = new JSONObject();
        try {
            String jsonString = JsonObjectMapperUtil.getJsonStringFromObject(object);
            jsonObject = JsonUtil.parseToJsonObject(jsonString);
        }
        catch (Exception e) {
            System.err.println("Json processing error occurred: " + e.getMessage());
            e.printStackTrace();
        }
        return jsonObject;
    }
}

