/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FileWritingUtil {
    private static final double MEG = Math.pow(1024.0, 2.0);

    public static String convertJSONArrayToString(JSONArray results, List<String> orderedKeysList) {
        StringBuffer csvContentBuffer = new StringBuffer();
        if (results != null && results.size() > 0) {
            String header = "";
            int numberOfColumns = orderedKeysList.size();
            int counter = 0;
            if (orderedKeysList == null || orderedKeysList.isEmpty()) {
                orderedKeysList = new ArrayList<String>();
                JSONObject row = (JSONObject)results.get(0);
                orderedKeysList = FileWritingUtil.getKeysFromJson(row);
            }
            for (String key : orderedKeysList) {
                if (counter != numberOfColumns - 1) {
                    csvContentBuffer.append(String.valueOf(key) + ",");
                } else {
                    csvContentBuffer.append(String.valueOf(key) + "\n");
                }
                ++counter;
            }
            for (Object result : results) {
                JSONObject row = (JSONObject)result;
                counter = 0;
                for (String key : orderedKeysList) {
                    String data = JSONObject.escape((String)String.valueOf(row.get((Object)key))).replaceAll("\\\\", "").replaceAll("\\\\", "").replaceAll("\"", "\"\"");
                    if (counter != numberOfColumns - 1) {
                        csvContentBuffer.append("\"" + data + "\",");
                    } else {
                        csvContentBuffer.append("\"" + data + "\"\n");
                    }
                    ++counter;
                }
            }
        }
        return csvContentBuffer.toString();
    }

    private static List<String> getKeysFromJson(JSONObject obj) {
        ArrayList<String> OrderedKeysList = new ArrayList<String>();
        if (!obj.isEmpty()) {
            Set keys = obj.keySet();
            OrderedKeysList.addAll(keys);
        }
        return OrderedKeysList;
    }

    public static String jsonArrayWithOrderedJsonStr(JSONArray results, List<String> orderedKeysList) {
        JSONArray sequnceArray = new JSONArray();
        if (results != null && results.size() > 0) {
            String header = "";
            if (orderedKeysList == null || orderedKeysList.isEmpty()) {
                orderedKeysList = new ArrayList<String>();
                JSONObject row = (JSONObject)results.get(0);
                orderedKeysList = FileWritingUtil.getKeysFromJson(row);
            }
            for (Object result : results) {
                LinkedHashMap<String, String> orderedMap = new LinkedHashMap<String, String>();
                JSONObject row = (JSONObject)result;
                for (String key : orderedKeysList) {
                    String data = JSONObject.escape((String)String.valueOf(row.get((Object)key))).replaceAll("\\\\", "").replaceAll("\\\\", "");
                    orderedMap.put(key, data);
                }
                sequnceArray.add(orderedMap);
            }
        }
        return sequnceArray.toString();
    }

    public static void writeToFile(JSONArray content, File file, List<String> orderedKeysList) throws Exception {
        FileWriter writer = new FileWriter(file);
        BufferedWriter bufferedWriter = new BufferedWriter(writer, 4 * (int)MEG);
        bufferedWriter.write(FileWritingUtil.convertJSONArrayToString(content, orderedKeysList));
        bufferedWriter.flush();
        bufferedWriter.close();
    }
}

