/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.initializer.EmbeddedJetty;
import com.dvsum.logger.CustomLogger;
import com.dvsum.model.Configuration;
import com.dvsum.model.ref.RefConfiguration;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.LogReadResult;
import com.dvsum.util.LoggingUtil;
import com.dvsum.util.StatusUtil;
import com.dvsum.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Component;

@Component
public class FileUtil {
    private static final CustomLogger logger = CustomLogger.getLogger(FileUtil.class);

    public static void main(String[] arg) {
        System.out.println(FileUtil.getScriptPath().replace("\\", "\\\\"));
        String path = "D:\\DvSum_Code\\SAWS_Code\\data-intelligence-connector\\scan_output\\279906ad-074e-4acf-a307-4a566249743a\\ANTONIO_XL_ORA_STORE_ADDR_input.json";
        String out = "D:\\DvSum_Code\\SAWS_Code\\data-intelligence-connector\\scan_output\\279906ad-074e-4acf-a307-4a566249743a\\ANTONIO_XL_ORA_STORE_ADDR_input3.json";
        JSONObject json = FileUtil.readFileAsJsonObject(path);
        FileUtil.writeJsonToFile(out, json);
    }

    public static String readDataFromFile(String filepath) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(filepath, new String[0]));
            return new String(encoded);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LogReadResult readBytesFromFile(String filePath, int offset) {
        String content = "";
        int modifiedOffset = 0;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RandomAccessFile file = new RandomAccessFile(filePath, "r");){
                file.seek(offset);
                modifiedOffset = (int)file.length() - offset;
                modifiedOffset = modifiedOffset < 0 ? 0 : modifiedOffset;
                byte[] buffer = new byte[modifiedOffset];
                file.read(buffer);
                content = new String(buffer, StandardCharsets.UTF_8);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.error("Error reading the file : ", e.getMessage());
            e.printStackTrace();
        }
        return new LogReadResult(content, modifiedOffset);
    }

    public static JSONObject readFileAsJsonObject(String filepath) {
        JSONObject json = new JSONObject();
        JSONParser parser = new JSONParser();
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(filepath, new String[0]));
            String content = new String(encoded);
            json = (JSONObject)parser.parse(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public static boolean fileExists(String filepath) {
        Path path = Paths.get(filepath, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public static void renameFile(String fileName, String newName) throws IOException {
        File file = new File(fileName);
        if (file.exists() && !file.isDirectory()) {
            newName = String.valueOf(newName) + new SimpleDateFormat("MM-dd-yyyy").format(new Date());
            File newFile = new File(newName = String.valueOf(newName) + ".log");
            if (newFile.exists()) {
                throw new IOException("file exists");
            }
            boolean success = file.renameTo(newFile);
            if (!success) {
                logger.info("SWAS.log rename to " + newName);
            } else {
                logger.debug("SWAS.log renaming failed");
            }
        }
    }

    public static String getApiToken1() {
        FileSystemResource resource = new FileSystemResource("./ApiKey.txt");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            String token = bufferedReader.readLine().toString();
            bufferedReader.close();
            return CryptographicUtil.encrypt(token);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void changeLogFilePath(String log4jPath, String path) {
        block12: {
            Properties prop = new Properties();
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(log4jPath);
                    prop.setProperty("log4j.appender.logfile", "org.apache.log4j.RollingFileAppender");
                    prop.setProperty("log4j.appender.logfile.Append", "true");
                    prop.setProperty("log4j.appender.logfile.layout", "org.apache.log4j.PatternLayout");
                    prop.setProperty("log4j.appender.logfile.layout.ConversionPattern", "%d{yyyy-MM-dd HH:mm:ss} %-5p %c{1}:%L - %m%n");
                    prop.setProperty("log4j.rootLogger", "WARN, logfile");
                    prop.setProperty("log4j.logger.com.dvsum", "debug,logfile");
                    prop.setProperty("log4j.additivity.com.dvsum", "false");
                    path = path.contains(".log") ? path : String.valueOf(path) + "/SAWS.log";
                    prop.setProperty("log4j.appender.logfile.File", path);
                }
                catch (Exception io) {
                    io.printStackTrace();
                    logger.error(io.getMessage());
                    if (out == null) break block12;
                    try {
                        prop.store(out, null);
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        prop.store(out, null);
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static String getAPIkey() {
        String API_KEY;
        block12: {
            Properties prop = new Properties();
            InputStream input = null;
            API_KEY = null;
            try {
                try {
                    String os = System.getProperty("os.name").toLowerCase();
                    input = os.contains("win") ? new FileInputStream("configuration.properties") : new FileInputStream("./configuration.properties");
                    prop.load(input);
                    API_KEY = prop.getProperty("api.key").toString();
                }
                catch (IOException io) {
                    io.printStackTrace();
                    if (input == null) break block12;
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return API_KEY;
    }

    public static boolean checkIfPropertyExists(String propertyName) {
        Properties prop = new Properties();
        FileInputStream input = null;
        Object property = null;
        try {
            input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
            prop.load(input);
            boolean bl = prop.containsKey(propertyName);
            return bl;
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static String getProperty(String propertyName) {
        String property;
        block12: {
            Properties prop = new Properties();
            FileInputStream input = null;
            property = null;
            try {
                try {
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    prop.load(input);
                    property = prop.getProperty(propertyName).toString().trim();
                }
                catch (IOException io) {
                    io.printStackTrace();
                    if (input == null) break block12;
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return property;
    }

    public static void updateConfiguration(Configuration configuration) {
        block14: {
            Properties prop = new Properties();
            FileInputStream input = null;
            FileOutputStream out = null;
            try {
                try {
                    LoggingUtil.setLogLevel(configuration.getLogLevel());
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    prop.load(input);
                    prop.setProperty("max.database.connection.allowed", configuration.getMaxDatabases().toString());
                    prop.setProperty("api.key", configuration.getSawsKey());
                    String logFilePath = configuration.getLogFilePath() != null ? configuration.getLogFilePath().replaceAll("\\\\", "/") : null;
                    prop.setProperty("logFilePath", logFilePath);
                    StatusUtil.maxjob = configuration.getMaxJobs() != null ? Long.parseLong(configuration.getMaxJobs().toString()) : RefConfiguration.MAX_JOBS;
                    StatusUtil.maxConnection = configuration.getMaxDatabases() != null ? Long.parseLong(configuration.getMaxDatabases().toString()) : RefConfiguration.MAX_CONNECTIONS;
                    prop.setProperty("logLevel", configuration.getLogLevel());
                    out = new FileOutputStream(EmbeddedJetty.CONFIGURATION_PATH);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (out != null) {
                        try {
                            prop.store(out, null);
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        prop.store(out, null);
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    prop.store(out, null);
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setHttpPortsFromConfigFile() {
        block13: {
            logger.info("Setting up saws port");
            Properties prop = new Properties();
            FileInputStream input = null;
            try {
                try {
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    prop.load(input);
                    String port = prop.getProperty("port");
                    if (Util.isNotNullOrEmpty(port)) {
                        EmbeddedJetty.HTTPS_PORT = Integer.parseInt(port);
                    }
                }
                catch (IOException io) {
                    io.printStackTrace();
                    if (input == null) break block13;
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static String getAdminList() {
        String adminList;
        block12: {
            Properties prop = new Properties();
            FileInputStream input = null;
            adminList = null;
            try {
                try {
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    prop.load(input);
                    adminList = prop.getProperty("admin.list").toString();
                }
                catch (Exception io) {
                    io.printStackTrace();
                    if (input == null) break block12;
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return adminList;
    }

    public static String getHttpsPortFromConfigFile() {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
            prop.load(input);
            String port = prop.getProperty("port");
            if (Util.isNotNullOrEmpty(port)) {
                String string = port;
                return string;
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return String.valueOf(EmbeddedJetty.HTTPS_PORT);
    }

    public static String getHttpPortFromConfigFile() {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
            prop.load(input);
            String port = prop.getProperty("httpPort");
            if (Util.isNotNullOrEmpty(port)) {
                String string = port;
                return string;
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return String.valueOf(EmbeddedJetty.HTTP_PORT);
    }

    public static JSONObject getProperties(String filePath, String[] properties) {
        JSONObject slectedProps;
        block14: {
            Properties prop = new Properties();
            FileInputStream input = null;
            slectedProps = new JSONObject();
            try {
                try {
                    input = new FileInputStream(filePath);
                    prop.load(input);
                    String[] stringArray = properties;
                    int n = properties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String selectedProp = stringArray[n2];
                        String propVal = prop.getProperty(selectedProp);
                        if (Util.isNotNullOrEmpty(propVal)) {
                            slectedProps.put((Object)selectedProp, (Object)propVal);
                        }
                        ++n2;
                    }
                }
                catch (Exception ex) {
                    logger.error("File not found. File path: ", filePath);
                    if (input == null) break block14;
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return slectedProps;
    }

    public static String getScriptPath() {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
            prop.load(input);
            String scriptPath = prop.getProperty("scriptPath");
            if (Util.isNotNullOrEmpty(scriptPath)) {
                String string = scriptPath;
                return string;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private static String getConfigProperty(String property) {
        String prop;
        block14: {
            Properties props = new Properties();
            prop = null;
            FileInputStream input = null;
            Integer poolSize = 10;
            try {
                try {
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    props.load(input);
                    prop = props.getProperty(property);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop != null ? prop : "";
    }

    public static String getPropertyWithDefault(String property, String defaultVal) {
        String prop;
        block14: {
            Properties props = new Properties();
            prop = null;
            FileInputStream input = null;
            Integer poolSize = 10;
            try {
                try {
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    props.load(input);
                    prop = props.getProperty(property);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop != null ? prop.trim() : defaultVal.trim();
    }

    public static String getPropertyWithDefault(String configFilePath, String property, String defaultVal) {
        String prop;
        block14: {
            Properties props = new Properties();
            prop = null;
            FileInputStream input = null;
            Integer poolSize = 10;
            try {
                try {
                    input = new FileInputStream(configFilePath);
                    props.load(input);
                    prop = props.getProperty(property);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop != null ? prop : defaultVal;
    }

    public static String getPropertyFromResourceWithDefault(String configFilePath, String property, String defaultVal) {
        String prop;
        block14: {
            Properties props = new Properties();
            prop = null;
            InputStream input = null;
            Integer poolSize = 10;
            try {
                try {
                    input = FileUtil.class.getClassLoader().getResourceAsStream(configFilePath);
                    props.load(input);
                    prop = props.getProperty(property);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return prop != null ? prop : defaultVal;
    }

    public static String getPropValue(Properties props, String key) {
        String propValue = null;
        try {
            propValue = props.getProperty(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return propValue;
    }

    public static void setDefaultConfigurations() {
        block15: {
            logger.info("Setting up default configurations");
            Properties prop = new Properties();
            FileInputStream input = null;
            FileOutputStream out = null;
            try {
                try {
                    File file = new File(EmbeddedJetty.CONFIGURATION_PATH);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    prop.load(input);
                    String excelPreProcessBatPath = String.valueOf(System.getProperty("user.dir").replace("\\", "/")) + "/excelPreProcessor/excelPreProcess.bat";
                    String localFileExportPath = String.valueOf(System.getProperty("user.dir").replace("\\", "/")) + "/exportFiles/";
                    prop.setProperty("saws.upgrade.inprogress", "false");
                    FileUtil.setDefaultProp(prop, "logLevel", "INFO");
                    FileUtil.setDefaultProp(prop, "max.database.connection.allowed", "20");
                    FileUtil.setDefaultProp(prop, "api.key", "");
                    FileUtil.setDefaultProp(prop, "port", "8183");
                    FileUtil.setDefaultProp(prop, "enable.log.sync", "false");
                    FileUtil.setDefaultProp(prop, "reboot.time", "13:00");
                    FileUtil.setDefaultProp(prop, "admin.list", "");
                    FileUtil.setDefaultProp(prop, "logFilePath", "SAWS.log");
                    FileUtil.setDefaultProp(prop, "request.timeout.get", "1800000");
                    FileUtil.setDefaultProp(prop, "request.timeout.post", "1800000");
                    FileUtil.setDefaultProp(prop, "cdata.driver.update.planned", "false");
                    out = new FileOutputStream(EmbeddedJetty.CONFIGURATION_PATH);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (out != null) {
                        try {
                            prop.store(out, " Note: rebootTime property below Will only be effective when saws is running as windows service, \n And rebootTime should be in 24 hours format i.e 15:30 or 02:00 etc");
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        prop.store(out, " Note: rebootTime property below Will only be effective when saws is running as windows service, \n And rebootTime should be in 24 hours format i.e 15:30 or 02:00 etc");
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    prop.store(out, " Note: rebootTime property below Will only be effective when saws is running as windows service, \n And rebootTime should be in 24 hours format i.e 15:30 or 02:00 etc");
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void setDefaultActiveMQConfigurations() {
        block15: {
            Properties prop = new Properties();
            FileInputStream input = null;
            FileOutputStream out = null;
            try {
                try {
                    File file = new File(EmbeddedJetty.ACTIVEMQ_CONFIGURATION_PATH);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    input = new FileInputStream(EmbeddedJetty.ACTIVEMQ_CONFIGURATION_PATH);
                    prop.load(input);
                    String activeMQBasePath = String.valueOf(System.getProperty("user.dir").replace("\\", "/")) + "/activemq/";
                    prop.setProperty("activemq.main.xml.path", String.valueOf(activeMQBasePath) + "conf/activemq.xml");
                    prop.setProperty("activemq.jetty.xml.path", String.valueOf(activeMQBasePath) + "conf/jetty.xml");
                    prop.setProperty("activemq.wrapper32Bit.config.path", String.valueOf(activeMQBasePath) + "bin/win32/wrapper.conf");
                    prop.setProperty("activemq.wrapper64Bit.config.path", String.valueOf(activeMQBasePath) + "bin/win64/wrapper.conf");
                    prop.setProperty("activemq.32bit.installation.script.path", String.valueOf(activeMQBasePath) + "bin/win32/InstallService.bat");
                    prop.setProperty("activemq.64bit.installation.script.path", String.valueOf(activeMQBasePath) + "bin/win64/InstallService.bat");
                    FileUtil.setDefaultProp(prop, "activemq.service.name", "DvSum ActiveMQ");
                    FileUtil.setDefaultProp(prop, "activemq.port.webconsole", "8161");
                    FileUtil.setDefaultProp(prop, "activemq.port.openwire", "61616");
                    FileUtil.setDefaultProp(prop, "activemq.port.amqp", "5677");
                    FileUtil.setDefaultProp(prop, "activemq.port.stomp", "61613");
                    FileUtil.setDefaultProp(prop, "activemq.port.mqtt", "1883");
                    FileUtil.setDefaultProp(prop, "activemq.port.ws", "61614");
                    out = new FileOutputStream(EmbeddedJetty.ACTIVEMQ_CONFIGURATION_PATH);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (out != null) {
                        try {
                            prop.store(out, " Note: rebootTime property below Will only be effective when saws is running as windows service, \n And rebootTime should be in 24 hours format i.e 15:30 or 02:00 etc");
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        prop.store(out, " Note: rebootTime property below Will only be effective when saws is running as windows service, \n And rebootTime should be in 24 hours format i.e 15:30 or 02:00 etc");
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    prop.store(out, " Note: rebootTime property below Will only be effective when saws is running as windows service, \n And rebootTime should be in 24 hours format i.e 15:30 or 02:00 etc");
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void setDefaultProp(Properties prop, String key, String defaultValue) {
        String currentValue = FileUtil.getPropValue(prop, key);
        prop.setProperty(key, Util.isNotNullOrEmpty(currentValue) ? currentValue : defaultValue);
    }

    public static void setSAWSMaintenaceFlagToTrue() {
        FileUtil.setConfigurationProperty("saws.upgrade.inprogress", "true");
    }

    public static void setConfigurationProperty(String key, String value) {
        block14: {
            Properties prop = new Properties();
            FileInputStream input = null;
            FileOutputStream out = null;
            try {
                try {
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    prop.load(input);
                    prop.setProperty(key, value);
                    out = new FileOutputStream(EmbeddedJetty.CONFIGURATION_PATH);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (out != null) {
                        try {
                            prop.store(out, null);
                            out.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        prop.store(out, null);
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    prop.store(out, null);
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JSONObject getSawsConfigurationInfo() {
        JSONObject jsonObject;
        block12: {
            Properties prop = new Properties();
            FileInputStream input = null;
            jsonObject = FileUtil.defaultConfiguration();
            try {
                try {
                    input = new FileInputStream(EmbeddedJetty.CONFIGURATION_PATH);
                    prop.load(input);
                    jsonObject.put((Object)"maxDatabaseConnAllowed", prop.getProperty("max.database.connection.allowed") != null ? prop.getProperty("max.database.connection.allowed") : Integer.valueOf(10));
                    jsonObject.put((Object)"apiKey", (Object)(prop.getProperty("api.key") != null ? prop.getProperty("api.key") : "api.key"));
                    jsonObject.put((Object)"logFilePath", (Object)prop.getProperty("logFilePath"));
                    jsonObject.put((Object)"logLevel", (Object)prop.getProperty("logLevel"));
                    jsonObject.put((Object)"logLevel", (Object)prop.getProperty("logLevel"));
                    jsonObject.put((Object)"enable.log.sync", (Object)prop.getProperty("enable.log.sync"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage());
                    if (input == null) break block12;
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return jsonObject;
    }

    public static String writeToFile(String filePath, String content) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(content);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
        return "SUCCESS";
    }

    public static String writeToFileIfNotExists(String filepath, String content) {
        try {
            Path filePath = Paths.get(filepath, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                Files.createDirectories(Paths.get(filepath, new String[0]).getParent(), new FileAttribute[0]);
                Files.createFile(Paths.get(filepath, new String[0]), new FileAttribute[0]);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(filepath));
            writer.write(content);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
        return "SUCCESS";
    }

    public static String getLogLevel() {
        JSONObject config = FileUtil.getSawsConfigurationInfo();
        String logLevel = String.valueOf(config.get((Object)"logLevel"));
        return logLevel;
    }

    private static JSONObject defaultConfiguration() {
        JSONObject properties = new JSONObject();
        properties.put((Object)"poolSize", (Object)10);
        properties.put((Object)"maxDatabaseConnAllowed", (Object)10);
        properties.put((Object)"logFilePath", null);
        properties.put((Object)"apiKey", null);
        return properties;
    }

    public static boolean isCsv(String fileName) {
        return fileName != null && fileName.toLowerCase().contains(".csv");
    }

    public static boolean isExcel(String fileName) {
        return fileName != null && fileName.toLowerCase().contains(".xls");
    }

    public static String cleanFileName(String inputString) {
        return inputString.trim().replaceAll("[^A-Za-z0-9 ]", "").trim().replaceAll(" +", "-").toLowerCase();
    }

    public static String cleanFileNameForScan(String inputString) {
        return inputString.trim().replace('.', '_').replaceAll("[^A-Za-z0-9_ ]", "").trim().replaceAll(" +", "-").toLowerCase();
    }

    public static void deleteFileIfExists(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void replaceInFile(Path mainXmlPath, String findstr, String replaceStr) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<String> lines = Files.lines(mainXmlPath);){
            List replaced = lines.map(line -> line.replaceAll(findstr, replaceStr)).collect(Collectors.toList());
            Files.write(mainXmlPath, replaced, new OpenOption[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void replaceInFile(Path mainXmlPath, List<String> findList, List<String> replaceList) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<String> lines = Files.lines(mainXmlPath);){
            List replaced = lines.map(line -> {
                String tLine = line;
                int i = 0;
                while (i < findList.size()) {
                    tLine = tLine.replaceAll((String)findList.get(i), (String)replaceList.get(i));
                    ++i;
                }
                return tLine;
            }).collect(Collectors.toList());
            Files.write(mainXmlPath, replaced, new OpenOption[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeJsonToFile(String filepath, JSONObject jsonObj) {
        Path path = Paths.get(filepath, new String[0]);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.append(jsonObj.toJSONString());
                writer.newLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeJsonToFile(String filepath, JSONArray jsonObj) {
        Path path = Paths.get(filepath, new String[0]);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.append(jsonObj.toJSONString());
                writer.newLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeJsonToFileUpdated(String filepath, JSONObject jsonObj) throws IOException {
        logger.debug("Writing file to ->" + jsonObj.toJSONString() + "<- JSON OBJECT " + filepath);
        logger.debug("PATH = " + filepath);
        Path filePath = Paths.get(filepath, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            Files.createDirectories(Paths.get(filepath, new String[0]).getParent(), new FileAttribute[0]);
            Files.createFile(Paths.get(filepath, new String[0]), new FileAttribute[0]);
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.append(jsonObj.toJSONString());
                writer.newLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void recreateFile(String path) throws IOException {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            file.createNewFile();
        } else {
            file.createNewFile();
        }
    }
}

