/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.exception.FileUploadException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.simple.JSONObject;
import org.springframework.web.multipart.MultipartFile;

public class FileUploadUtil {
    public static String upload(String directory, MultipartFile file) throws Exception {
        if (!file.isEmpty()) {
            byte[] bytes = file.getBytes();
            File dir = new File(directory);
            if (!dir.exists()) {
                throw new FileUploadException("Destination folder " + dir.getName() + " does not exist. Please contact your System Administrator or DvSum Support");
            }
            if (!FileUploadUtil.isValidFile(file.getOriginalFilename())) {
                throw new FileUploadException("Invalid file");
            }
            File serverFile = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + file.getOriginalFilename());
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(serverFile));
            stream.write(bytes);
            stream.close();
            return "You successfully uploaded file=" + file.getName();
        }
        return "You failed to upload " + file.getName() + " because the file was empty.";
    }

    private static boolean isValidFile(String fileName) {
        return fileName != null && (fileName.toLowerCase().endsWith(".csv") || fileName.toLowerCase().endsWith(".xlsx") || fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".txt"));
    }

    public static List<JSONObject> getAllFiles(String directoryName) {
        File[] fList;
        File directory = new File(directoryName);
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        File[] fileArray = fList = directory.listFiles();
        int n = fList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                if (FileUploadUtil.isValidFile(file.getName())) {
                    resultList.add(FileUploadUtil.getFileInfo(file));
                }
            } else if (file.isDirectory()) {
                resultList.addAll(FileUploadUtil.getAllFiles(file.getAbsolutePath()));
            }
            ++n2;
        }
        return resultList;
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public static JSONObject getFileInfo(File file) {
        JSONObject fileInfo = new JSONObject();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");
        Date lastMofiedDate = new Date(file.lastModified());
        fileInfo.put((Object)"fileName", (Object)file.getName());
        fileInfo.put((Object)"lastModificationDate", (Object)sdf.format(lastMofiedDate));
        return fileInfo;
    }

    public static void main(String[] args) {
        System.out.println(FileUploadUtil.getAllFiles("D:\\\\File Upload"));
    }
}

