/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.CSVWriter;
import com.jsontocsv.parser.JsonFlattener;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.OrderedJSONObject;

public class CSVWriterUtil {
    private static final CustomLogger logger = CustomLogger.getLogger(CSVWriterUtil.class);

    public static void writeSampleDataToCSV(String runjsonStr, String filePath) {
        JsonFlattener parser = new JsonFlattener();
        CSVWriter writer = new CSVWriter();
        try {
            JSONArray parsed = CSVWriterUtil.getOrderedJsonArray(CSVWriterUtil.getOrderedJsonObject(runjsonStr).get("results"));
            List flatJson = parser.parseArray(parsed);
            writer.writeAsCSV(flatJson, filePath);
            System.out.println(" output file created " + filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
        }
    }

    public static void writeLimitedSampleDataToCSV(String runjsonStr, String filePath, int maxResultLimit) {
        JsonFlattener parser = new JsonFlattener();
        CSVWriter writer = new CSVWriter();
        try {
            JSONArray parsed = CSVWriterUtil.getOrderedJsonArray(CSVWriterUtil.getOrderedJsonObject(runjsonStr).get("results"));
            List flatJson = parser.parseArray(parsed);
            List<LinkedHashMap<String, String>> rowsToWrite = flatJson.subList(0, Math.min(flatJson.size(), maxResultLimit));
            writer.writeAsCSV(rowsToWrite, filePath);
            System.out.println("output file with result limit = " + maxResultLimit + "created " + filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
        }
    }

    public static OrderedJSONObject getOrderedJsonObject(String jsonString) {
        try {
            return new OrderedJSONObject(jsonString);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONArray getOrderedJsonArray(Object jsonArray) {
        return (JSONArray)jsonArray;
    }
}

