/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.util;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileWritingUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.Util;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.io.FileWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class AzureUploaderUtil {
    public static final CustomLogger logger = CustomLogger.getLogger(AzureUploaderUtil.class);

    public static void uploadJson(String data, String filename, String fileType, String accountname, String accountKey, String containerName, String target, String proxy, List<String> orderedKeysList) throws Exception {
        String storageConnectionString = "DefaultEndpointsProtocol=https;AccountName=" + accountname + ";AccountKey=" + accountKey;
        logger.debug("Initiating Azure Blob Storage FileUpload Task............");
        CloudBlobClient blobClient = null;
        CloudBlobContainer container = null;
        File sourceFile = null;
        JsonUtil jsonUtil = new JsonUtil();
        try {
            if (!Util.isNullOrEmpty(data)) {
                JSONParser parser = new JSONParser();
                JSONObject resultJSON = (JSONObject)parser.parse(data);
                JSONArray resultsArray = (JSONArray)resultJSON.get((Object)"results");
                File tempCSV = null;
                FileWriter tempJSON = null;
                CloudStorageAccount storageAccount = CloudStorageAccount.parse((String)storageConnectionString);
                blobClient = storageAccount.createCloudBlobClient();
                container = blobClient.getContainerReference(containerName);
                String tempDir = System.getProperty("java.io.tmpdir");
                if ("CSV".equalsIgnoreCase(fileType)) {
                    long startTime = System.currentTimeMillis();
                    tempCSV = new File(tempDir, String.valueOf(filename) + ".csv");
                    FileWritingUtil.writeToFile(resultsArray, tempCSV, orderedKeysList);
                    long endTime = System.currentTimeMillis();
                    logger.debug("Writing json to csv  time(seconds): " + String.valueOf((endTime - startTime) / 1000L));
                    logger.debug(" temp file " + tempCSV.getAbsolutePath());
                    sourceFile = tempCSV;
                } else {
                    tempJSON = new FileWriter(String.valueOf(tempDir) + filename + ".json");
                    tempJSON.write(FileWritingUtil.jsonArrayWithOrderedJsonStr(resultsArray, orderedKeysList));
                    tempJSON.flush();
                    tempJSON.close();
                    sourceFile = new File(String.valueOf(tempDir) + filename + ".json");
                    logger.info("Uploaded JSON file ........ " + tempDir + filename + ".json");
                }
                JSONObject proxyObj = jsonUtil.parseStringToJsonObject(proxy);
                if ("1".equalsIgnoreCase(String.valueOf(proxyObj.get((Object)"PROXY_ENABLED")))) {
                    String proxyHost = CryptographicUtil.decrypt(String.valueOf(proxyObj.get((Object)"PROXY_HOST")));
                    int proxyPort = Integer.valueOf(String.valueOf(proxyObj.get((Object)"PROXY_PORT")));
                    Proxy httpProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                    OperationContext.setDefaultProxy((Proxy)httpProxy);
                }
                CloudBlobDirectory dir = container.getDirectoryReference(target);
                System.out.println("file Type is" + fileType);
                if (sourceFile != null && sourceFile.exists()) {
                    String fileName = sourceFile.getName();
                    long startTime = System.currentTimeMillis();
                    CloudBlockBlob blob = dir.getBlockBlobReference(sourceFile.getName());
                    if (AzureUploaderUtil.isCSVExcelOrJSON(fileName)) {
                        if ("CSV".equalsIgnoreCase(fileType)) {
                            blob.getProperties().setContentType("text/csv");
                        }
                        if ("EXC".equalsIgnoreCase(fileType)) {
                            blob.getProperties().setContentType("application/vnd.openxml");
                        }
                        if ("JSN".equalsIgnoreCase(fileType)) {
                            System.out.println("setting content Types");
                            blob.getProperties().setContentType("application/json");
                        }
                        System.out.println("setting content Types");
                        blob.uploadFromFile(sourceFile.getAbsolutePath());
                        logger.debug("\tAzureblobstorage: " + fileName + " Uploaded!");
                        long endTime = System.currentTimeMillis();
                        logger.debug("upload to azure time(seconds): " + String.valueOf((endTime - startTime) / 1000L));
                    }
                }
                if (tempCSV != null) {
                    tempCSV.delete();
                }
                if (sourceFile != null) {
                    sourceFile.delete();
                }
            } else {
                logger.info("There is no data to export to azure");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception", e);
            throw new Exception(e.getMessage());
        }
    }

    public static boolean isCSVExcelOrJSON(String fileName) {
        return fileName != null && (AzureUploaderUtil.isCSV(fileName) || AzureUploaderUtil.isExcel(fileName) || AzureUploaderUtil.isJSON(fileName));
    }

    public static boolean isCSV(String fileName) {
        return fileName != null && fileName.toLowerCase().contains(".csv");
    }

    public static boolean isJSON(String fileName) {
        return fileName != null && fileName.toLowerCase().contains(".json");
    }

    public static boolean isExcel(String fileName) {
        return fileName != null && (fileName.toLowerCase().contains(".xls") || fileName.toLowerCase().contains(".xlsx") || fileName.toLowerCase().contains(".xlsm") || fileName.contains(".xlsb"));
    }
}

