/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.JsonUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.simple.JSONObject;

public class TaskMetadataService {
    String taskId = this.getTaskID();
    private static final CustomLogger logger = CustomLogger.getLogger(TaskMetadataService.class);

    public String getTaskID() {
        String taskId = "";
        try {
            String metadataUrl = System.getenv("TASK_METADATA_URL");
            System.out.println("METADATA URL = " + metadataUrl);
            URL url = new URL(metadataUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                String strResponse = response.toString();
                System.out.println("Task ID STRING RESPONSE: " + strResponse);
                JSONObject jsonResponse = JsonUtil.parseToJsonObject(strResponse);
                String taskArn = (String)jsonResponse.get((Object)"TaskARN");
                String[] splittedTaskArn = taskArn.split("/", 3);
                System.out.println("Splitted Task ARN [0] = " + splittedTaskArn[0]);
                taskId = splittedTaskArn[2];
                System.out.println("TASK ID = " + taskId);
            } else {
                System.out.println("HTTP request failed with response code: " + responseCode);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            logger.debug("EXCEPTION WHILE GETTING TASK ID");
            e.printStackTrace();
        }
        return taskId;
    }
}

