/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.dataSource.DataSource;
import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.services.DataSourceConnectionService;
import com.dvsum.util.Util;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SourceService {
    private static final CustomLogger logger = CustomLogger.getLogger(SourceService.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    private DataSourceConnectionService connectionService;

    public String performTestConnection(JSONObject connectionInfo, LogFormat logFormat) {
        try {
            String query;
            String sourceType = String.valueOf(connectionInfo.get((Object)"source_type"));
            DataSource dataSource = this.dataSourceFactory.getDataSource(sourceType, connectionInfo, false, logFormat);
            dataSource.connect();
            if (RefDBType.isDatabricks(sourceType)) {
                this.connectionService.connectWithNativeDatabricks(connectionInfo, logFormat);
            }
            if (Util.isNotNullOrEmpty(query = String.valueOf(dataSource.getTestConnectionString()))) {
                List<Map<String, Object>> res = dataSource.performTestConnection(query);
                dataSource.disconnect();
                return !CollectionUtils.isEmpty(res) && res.size() > 0 ? "SUCCESS" : "ERROR";
            }
            return "SUCCESS";
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), e);
            return "ERROR";
        }
    }
}

