/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.model.ref.RefScanType;
import com.dvsum.model.scan.Catalog;
import com.dvsum.model.scan.ProfileTable;
import com.dvsum.services.DataSourceConnectionService;
import com.dvsum.services.ExecutorServiceHandler;
import com.dvsum.services.TaskMetadataService;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.util.SelfSignedHttps;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class ScanSourceService {
    private static final CustomLogger logger = CustomLogger.getLogger(ScanSourceService.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    private DataSourceConnectionService connectionService;
    @Value(value="${get.job.ids.api}")
    private String FETCH_JOB_URL;
    @Value(value="${return.control.to.sfn.api}")
    private String RETRUN_CONTROL_TO_SFN_URL;
    @Value(value="${https.cert.type}")
    private String certType;
    @Value(value="${base.url}")
    private String baseURL;
    @Value(value="${start.scan.job.api}")
    private String RUN_JOB_API;
    @Value(value="${post.data.api}")
    private String RULE_EXEC_DETAILS_API;
    @Value(value="${https.cert.type}")
    private String CERT_TYPE;
    @Value(value="${post.crawler_status.api}")
    private String crawlerStatusURL;
    @Value(value="${post.update_serialization_lib_for_s3.api}")
    private String updateSerializationLibURL;
    @Value(value="${https.cert.type}")
    private String httpsCertType;
    @Value(value="${is.cloud.saws}")
    private static String IS_CLOUD_SAWS;

    @Async
    public void executeScanJob(String jobId, String API_KEY, ExecutorService executorService) {
        block12: {
            LogFormat logFormat = new LogFormat();
            logger.debug("Executing Job : " + jobId);
            long startTime = System.currentTimeMillis();
            Object dvttdRecords = null;
            try {
                try {
                    JsonUtil jsonUtil = new JsonUtil();
                    String scanJobMetaData = this.getScanJobMetadata(jobId, API_KEY);
                    if (Util.isNotNullOrEmpty(scanJobMetaData)) {
                        JSONObject scanSourceMetaData = jsonUtil.parseStringToJsonObject(scanJobMetaData);
                        String sourceId = String.valueOf(scanSourceMetaData.get((Object)"source_id"));
                        String sourceName = String.valueOf(scanSourceMetaData.get((Object)"sourceName"));
                        String executionId = String.valueOf(scanSourceMetaData.get((Object)"execution_id"));
                        String isCDataSrc = String.valueOf(scanSourceMetaData.get((Object)"is_cdata_src"));
                        String scanType = String.valueOf(scanSourceMetaData.get((Object)"scan_type"));
                        JSONArray tableFilters = (JSONArray)scanSourceMetaData.get((Object)"table_names_filter");
                        JSONObject s3PreSignedURLInfo = (JSONObject)scanSourceMetaData.get((Object)"s3_pre_signed_post_url");
                        tableFilters = tableFilters == null ? new JSONArray() : tableFilters;
                        logFormat.setLogFormat("scan", scanSourceMetaData);
                        logger.info(logFormat.getFormattedLog(), "***************** Processing on Gateway started for Execution id: " + executionId + "  ********************");
                        this.create_output_directory(executionId, logFormat);
                        JSONArray catalogInfo = this.executeCatalogQueries(scanSourceMetaData, jobId, logFormat);
                        JSONArray modifiedCatalogInfo = this.getFilteredCatalogInfo(catalogInfo, scanSourceMetaData, scanType, tableFilters, logFormat);
                        JSONObject catalogResults = this.convertArrayToObject(modifiedCatalogInfo, logFormat);
                        if (catalogResults.containsKey((Object)"COLS_META") && catalogResults.containsKey((Object)"TBLS_META")) {
                            JSONObject tablesProfile = this.tablesProfileJSON(catalogResults, isCDataSrc, scanSourceMetaData, logFormat);
                            logger.info(logFormat.getFormattedLog(), "Total number of tables found for execution_id: " + executionId + " = " + tablesProfile.size());
                            if (RefScanType.isCatalogOnly(scanType)) {
                                this.executeCatalogOnlyFlow(tablesProfile, executionId, s3PreSignedURLInfo, logFormat);
                            } else {
                                this.executeProfileQueries(scanSourceMetaData, jobId, tablesProfile, executorService, logFormat);
                            }
                        } else if (catalogResults.containsKey((Object)"Error")) {
                            catalogResults.put((Object)"is_errored", (Object)true);
                            catalogResults.put((Object)"error_msg", (Object)String.valueOf(catalogResults.get((Object)"Error")));
                            catalogResults.put((Object)"error_type", (Object)"catalog");
                            catalogResults.put((Object)"execution_id", (Object)executionId);
                            this.loadScanErrorsToS3(catalogResults, scanSourceMetaData, logFormat);
                        }
                        ExecutorServiceHandler.shutDownExecutorService(jobId);
                        String is_cloud_saws = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
                        String taskId = "";
                        if (is_cloud_saws.equalsIgnoreCase("true")) {
                            TaskMetadataService taskMetadataService = new TaskMetadataService();
                            taskId = taskMetadataService.taskId;
                        }
                        this.returnControlToStepFunction(scanSourceMetaData, API_KEY, taskId);
                        long endTime = System.currentTimeMillis();
                        float executionTime = (endTime - startTime) / 1000L;
                        logger.info(logFormat.getFormattedLog(), "Total Execution Time for Execution Id : " + executionId + " is : " + executionTime);
                        logger.info(logFormat.getFormattedLog(), "***************** Processing on Gateway completed for Execution id: " + executionId + " ********************");
                        break block12;
                    }
                    logger.error(logFormat, "Scan source metadata is null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(logFormat.getFormattedLog(), "Error ", e);
                    System.setProperty("IsJobRunning", "false");
                }
            }
            finally {
                System.setProperty("IsJobRunning", "false");
            }
        }
    }

    private void executeCatalogOnlyFlow(JSONObject tablesProfile, String executionId, JSONObject S3PreSignedURLInfo2, LogFormat logFormat) {
        if (tablesProfile != null || !tablesProfile.isEmpty()) {
            tablesProfile.keySet().forEach(key -> {
                JSONObject profileJson = (JSONObject)tablesProfile.get(key);
                String tableName = String.valueOf(profileJson.get((Object)"table_name"));
                String schemaName = String.valueOf(profileJson.get((Object)"table_schem"));
                String tableNameWithSchema = Util.isNotNullOrEmpty(schemaName) && !tableName.startsWith(String.valueOf(schemaName) + ".") ? String.valueOf(schemaName) + "." + tableName : tableName;
                this.uploadTableJsonToS3(profileJson, executionId, tableNameWithSchema, S3PreSignedURLInfo2, logFormat);
            });
        }
    }

    public static boolean isCloudSaws() {
        return IS_CLOUD_SAWS != null && IS_CLOUD_SAWS.equalsIgnoreCase("true");
    }

    private void uploadTableJsonToS3(JSONObject profileJson, String executionId, String tableNameWithSchema, JSONObject S3PreSignedURLInfo2, LogFormat logFormat) {
        String baseFilePath = "./scan_output/" + executionId + "/";
        String jsonFilePath = String.valueOf(baseFilePath) + FileUtil.cleanFileNameForScan(tableNameWithSchema) + "_input.json";
        FileUtil.writeJsonToFile(jsonFilePath, profileJson);
        MultipartFileUploader.uploadFileToS3(jsonFilePath, S3PreSignedURLInfo2, logFormat);
        logger.info(logFormat.getFormattedLog(), "Metadata file uploaded to S3.", ScanSourceService.isCloudSaws() ? "" : "File path :" + jsonFilePath);
    }

    private void saveCatalogInfoInS3(JSONArray catalogInfo, String fileName, JSONObject scanSourceMetaData, LogFormat logFormat) {
        try {
            String executionId = String.valueOf(scanSourceMetaData.get((Object)"execution_id"));
            JSONObject s3PreSignedURLInfo = (JSONObject)scanSourceMetaData.get((Object)"s3_pre_signed_post_url");
            String baseFilePath = "./scan_output/" + executionId + "/";
            String jsonFilePath = String.valueOf(baseFilePath) + fileName;
            FileUtil.writeJsonToFile(jsonFilePath, catalogInfo);
            MultipartFileUploader.uploadFileToS3(jsonFilePath, s3PreSignedURLInfo, logFormat);
            logger.info(logFormat.getFormattedLog(), "Catalog metadata file uploaded to S3.", ScanSourceService.isCloudSaws() ? "" : "File path :" + jsonFilePath);
        }
        catch (Exception e) {
            logger.error("Error while saving catalog information in S3. ", e);
            e.printStackTrace();
        }
    }

    private void returnControlToStepFunction(JSONObject scanSourceMeta, String API_KEY, String taskId) throws Exception {
        System.out.println(" Return control to step function .... ");
        JSONObject payload = new JSONObject();
        JSONObject payloadObj = new JSONObject();
        payloadObj.put((Object)"execution_id", (Object)String.valueOf(scanSourceMeta.get((Object)"execution_id")));
        payloadObj.put((Object)"task_id", (Object)taskId);
        payload.put((Object)"Payload", (Object)payloadObj);
        JSONObject output = new JSONObject();
        output.put((Object)"output", (Object)payload.toJSONString());
        output.put((Object)"taskToken", (Object)String.valueOf(scanSourceMeta.get((Object)"task_token")));
        Thread.sleep(5000L);
        TLSHttpsRequestor.postJsonData(this.RETRUN_CONTROL_TO_SFN_URL, output.toJSONString(), API_KEY);
    }

    private void preExecutionCallForDatasource(JSONObject scanSourceMetaData, LogFormat logFormat) {
        try {
            String sourceType = (String)scanSourceMetaData.get((Object)"source_type");
            if (sourceType.equals("AS3")) {
                this.executeCrawler(scanSourceMetaData, logFormat);
            } else if (RefDBType.isDatabricks(sourceType)) {
                this.connectionService.connectWithNativeDatabricks((JSONObject)scanSourceMetaData.get((Object)"connection_config"), logFormat);
            }
        }
        catch (Exception e) {
            logger.error(logFormat.getFormattedLog(), "Error ", e);
            e.printStackTrace();
        }
    }

    private void executeCrawler(JSONObject scanSourceMetaData, LogFormat logFormat) throws Exception {
        String crawlerState = null;
        JSONObject connectionConfig = scanSourceMetaData.get((Object)"connection_config") != null ? (JSONObject)scanSourceMetaData.get((Object)"connection_config") : new JSONObject();
        Boolean useGlueCrawler = connectionConfig.get((Object)"useGlueCrawler") != null ? (Boolean)connectionConfig.get((Object)"useGlueCrawler") : false;
        if (useGlueCrawler.booleanValue()) {
            String accessKey = (String)connectionConfig.get((Object)"accessKey");
            String secretKey = (String)connectionConfig.get((Object)"secretKey");
            String region = (String)connectionConfig.get((Object)"region");
            String crawlerName = (String)connectionConfig.get((Object)"glueCrawler");
            String API_key = FileUtil.getAPIkey();
            JSONObject json_obj = new JSONObject();
            json_obj.put((Object)"region", (Object)region);
            json_obj.put((Object)"crawler-name", (Object)crawlerName);
            while (true) {
                String response = TLSHttpsRequestor.executePost(this.crawlerStatusURL, json_obj.toJSONString(), API_key, accessKey, secretKey, logFormat);
                JSONParser parser = new JSONParser();
                JSONObject resp_json = (JSONObject)parser.parse(response);
                JSONObject body = (JSONObject)resp_json.get((Object)"body");
                crawlerState = (String)body.get((Object)"State");
                logger.info(logFormat.getFormattedLog(), "Crawler state : " + crawlerState);
                if (crawlerState.equalsIgnoreCase("Ready")) {
                    logger.info(logFormat.getFormattedLog(), "Crawler is ready");
                    break;
                }
                Thread.sleep(10000L);
            }
        }
    }

    private JSONArray executeCatalogQueries(JSONObject scanSourceMetaData, String jobId, LogFormat logFormat) throws Exception {
        this.preExecutionCallForDatasource(scanSourceMetaData, logFormat);
        Catalog catalog = new Catalog(scanSourceMetaData, this.dataSourceFactory, logFormat);
        Object[] executeCatalogQueriesRes = catalog.executeCatalogQueries();
        JSONArray catalogInfo = (JSONArray)executeCatalogQueriesRes[0];
        ExecutorService executorService = (ExecutorService)executeCatalogQueriesRes[1];
        ExecutorServiceHandler.addExecutorService(jobId, executorService);
        return catalogInfo;
    }

    private void executeProfileQueries(JSONObject scanSourceMetaData, String jobId, JSONObject tablesProfile, ExecutorService mainExecutorService, LogFormat logFormat) throws Exception {
        Integer poolSize = Integer.parseInt(FileUtil.getPropertyWithDefault("max.database.connection.allowed", "10"));
        poolSize = (int)Math.round(Math.floor(poolSize / 2));
        ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
        ExecutorServiceHandler.addExecutorService(jobId, mainExecutorService);
        int totalTableCount = tablesProfile.size();
        AtomicInteger remainingTableCount = new AtomicInteger(tablesProfile.size());
        tablesProfile.keySet().forEach(key -> {
            JSONObject tableProfile = (JSONObject)tablesProfile.get(key);
            ProfileTable profileTable = new ProfileTable(scanSourceMetaData, this.dataSourceFactory, tableProfile, mainExecutorService, totalTableCount, remainingTableCount, this.updateSerializationLibURL, logFormat);
            executorService.execute(profileTable);
        });
        executorService.shutdown();
        this.waitForExecutorServiceToTerminate(executorService);
    }

    private JSONObject tablesProfileJSON(JSONObject catalogResults, String isCDataSrc, JSONObject scanSourceMetaData, LogFormat logFormat) {
        JSONObject tables = new JSONObject();
        JSONArray tablesMeta = (JSONArray)catalogResults.get((Object)"TBLS_META");
        JSONArray colsMeta = (JSONArray)catalogResults.get((Object)"COLS_META");
        this.saveCatalogInfoInS3(tablesMeta, "table_catalog_metadata.json", scanSourceMetaData, logFormat);
        this.saveCatalogInfoInS3(colsMeta, "column_catalog_metadata.json", scanSourceMetaData, logFormat);
        this.addTables(tables, tablesMeta, logFormat);
        this.addColumns(tables, colsMeta, logFormat);
        if (catalogResults.get((Object)"CONS_META") != null) {
            JSONArray consMeta = (JSONArray)catalogResults.get((Object)"CONS_META");
            this.saveCatalogInfoInS3(consMeta, "constraint_catalog_metadata.json", scanSourceMetaData, logFormat);
            this.addConstraints(tables, (JSONArray)catalogResults.get((Object)"CONS_META"), logFormat);
        }
        if ("true".equalsIgnoreCase(isCDataSrc) && catalogResults.get((Object)"CONS_META_FOREIGN") != null) {
            JSONArray consForeignMeta = (JSONArray)catalogResults.get((Object)"CONS_META_FOREIGN");
            this.saveCatalogInfoInS3(consForeignMeta, "constraint_foreign_catalog_metadata.json", scanSourceMetaData, logFormat);
            this.addConstraints(tables, (JSONArray)catalogResults.get((Object)"CONS_META_FOREIGN"), logFormat);
        }
        return tables;
    }

    private void addTables(JSONObject tables, JSONArray table_results, LogFormat logFormat) {
        for (Object table_result : table_results) {
            try {
                JSONObject table_result_json = (JSONObject)table_result;
                String table_name = table_result_json.get((Object)"table_name").toString();
                String table_schema = String.valueOf(table_result_json.get((Object)"table_schem"));
                if ("INFORMATION_SCHEMA".equalsIgnoreCase(table_schema)) continue;
                table_result_json.put((Object)"cons", (Object)new JSONObject());
                table_result_json.put((Object)"cols", (Object)new JSONObject());
                tables.put((Object)(String.valueOf(table_schema) + "_" + table_name.toLowerCase()), (Object)table_result_json);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(logFormat.getFormattedLog(), "Error ", e);
            }
        }
    }

    private void addColumns(JSONObject tables, JSONArray cols_results, LogFormat logFormat) {
        for (Object cols_result : cols_results) {
            String table_name = null;
            String table_schema = null;
            try {
                JSONObject table;
                JSONObject cols;
                String modifiedTableNameWithSchema;
                JSONObject cols_result_json = (JSONObject)cols_result;
                table_name = String.valueOf(cols_result_json.get((Object)"table_name"));
                table_schema = String.valueOf(cols_result_json.get((Object)"table_schem"));
                if ("INFORMATION_SCHEMA".equalsIgnoreCase(table_schema)) continue;
                String column_name = null;
                if (cols_result_json.get((Object)"col_name") != null) {
                    column_name = cols_result_json.get((Object)"col_name").toString();
                }
                if (cols_result_json.get((Object)"column_name") != null) {
                    column_name = cols_result_json.get((Object)"column_name").toString();
                    cols_result_json.put((Object)"col_name", (Object)column_name);
                }
                if (!tables.containsKey((Object)(modifiedTableNameWithSchema = String.valueOf(table_schema) + "_" + table_name.toLowerCase())) || (cols = (JSONObject)(table = (JSONObject)tables.get((Object)modifiedTableNameWithSchema)).get((Object)"cols")) == null) continue;
                cols.put((Object)column_name, (Object)cols_result_json);
            }
            catch (Exception e) {
                logger.error(logFormat.getFormattedLog(), "add colum error: " + table_name, e);
            }
        }
    }

    private void addConstraints(JSONObject tables, JSONArray cons_results, LogFormat logFormat) {
        for (Object cols_result : cons_results) {
            JSONObject cons_result = (JSONObject)cols_result;
            String table_name = "";
            String table_schema = "";
            try {
                JSONObject cons_result_json = cons_result;
                if (cons_result_json.containsKey((Object)"table_name")) {
                    table_name = cons_result_json.get((Object)"table_name").toString();
                } else if (cons_result_json.containsKey((Object)"fktable_name")) {
                    table_name = cons_result_json.get((Object)"fktable_name").toString();
                }
                if (cons_result_json.containsKey((Object)"table_schem")) {
                    table_schema = String.valueOf(cons_result_json.get((Object)"table_schem"));
                } else if (cons_result_json.containsKey((Object)"fktable_schem")) {
                    table_schema = String.valueOf(cons_result_json.get((Object)"fktable_schem"));
                }
                String constraintsKey = "constraint_name";
                if (cons_result_json.containsKey((Object)"constraint_name")) {
                    constraintsKey = "constraint_name";
                } else if (cons_result_json.containsKey((Object)"fk_name")) {
                    constraintsKey = "fk_name";
                } else if (cons_result_json.containsKey((Object)"pk_name")) {
                    constraintsKey = "pk_name";
                }
                String colKey = "col_name";
                if (cons_result_json.containsKey((Object)"col_name")) {
                    colKey = "col_name";
                } else if (cons_result_json.containsKey((Object)"fkcolumn_name")) {
                    colKey = "fkcolumn_name";
                } else if (cons_result_json.containsKey((Object)"column_name")) {
                    colKey = "column_name";
                }
                String constraint_name = cons_result_json.get((Object)constraintsKey).toString();
                String column_name = cons_result_json.get((Object)colKey).toString();
                JSONObject table = (JSONObject)tables.get((Object)(String.valueOf(table_schema) + "_" + table_name.toLowerCase()));
                JSONObject cons = (JSONObject)table.get((Object)"cons");
                if (cons == null) continue;
                cons.put((Object)(String.valueOf(column_name) + "_" + constraint_name), (Object)cons_result_json);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error ", e);
                if (cons_result == null) continue;
                logger.error("add constraints error: " + cons_result.toJSONString());
            }
        }
    }

    private JSONArray getFilteredCatalogInfo(JSONArray catalogInfo, JSONObject scanSourceMetadata, String scanType, JSONArray tableFilters, LogFormat logFormat) {
        JSONObject catalogResults = new JSONObject();
        JSONArray filteredCatalogResults = new JSONArray();
        JSONArray modifiedCatalogInfo = (JSONArray)catalogInfo.clone();
        JSONObject connectionConfig = (JSONObject)scanSourceMetadata.get((Object)"connection_config");
        if (!connectionConfig.containsKey((Object)"schema_names")) {
            return catalogInfo;
        }
        String schemaNames = (String)connectionConfig.get((Object)"schema_names");
        String[] schemaArr = schemaNames.split(",");
        for (Object result : catalogInfo) {
            JSONObject resultJSON = (JSONObject)result;
            try {
                String runStatus = String.valueOf(resultJSON.get((Object)"runStatus"));
                if ("0".equalsIgnoreCase(runStatus)) {
                    JSONObject runJson = (JSONObject)resultJSON.getOrDefault((Object)"runJson", (Object)new JSONObject());
                    JSONArray resultJson = (JSONArray)runJson.getOrDefault((Object)"results", (Object)new JSONArray());
                    if (resultJson == null || resultJson.isEmpty() || !String.valueOf(resultJSON.getOrDefault((Object)"queryType", (Object)"")).equalsIgnoreCase("TBLS_META")) continue;
                    for (Object tableObj : resultJson) {
                        JSONObject tableJson = (JSONObject)tableObj;
                        String tableSchem = (String)tableJson.get((Object)"table_schem");
                        String tableName = (String)tableJson.get((Object)"table_name");
                        String[] stringArray = schemaArr;
                        int n = schemaArr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String schema = stringArray[n2];
                            if (Util.isNullOrEmpty(schema = StringUtils.strip((String)schema, (String)"'"))) {
                                return catalogInfo;
                            }
                            if (tableSchem.equalsIgnoreCase(schema)) {
                                String tableNameWithSchema;
                                String string = tableNameWithSchema = tableName.startsWith(String.valueOf(tableSchem) + ".") ? tableName : String.valueOf(tableSchem) + "." + tableName;
                                if (RefScanType.isFullScan(scanType) || RefScanType.isCatalogOnly(scanType)) {
                                    filteredCatalogResults.add((Object)tableJson);
                                } else if (RefScanType.isProfileOnly(scanType) && !tableFilters.isEmpty() && tableFilters.toJSONString().toLowerCase().contains(tableNameWithSchema.toLowerCase())) {
                                    filteredCatalogResults.add((Object)tableJson);
                                }
                            }
                            ++n2;
                        }
                    }
                    catalogResults.put((Object)"TBLS_META", (Object)filteredCatalogResults);
                    ((JSONObject)resultJSON.get((Object)"runJson")).replace((Object)"results", (Object)filteredCatalogResults);
                    ((JSONObject)resultJSON.get((Object)"runJson")).replace((Object)"runResult", (Object)filteredCatalogResults.size());
                    modifiedCatalogInfo.remove(result);
                    modifiedCatalogInfo.add((Object)resultJSON);
                    continue;
                }
                if (!resultJSON.containsKey((Object)"runError")) continue;
                String runError = String.valueOf(resultJSON.get((Object)"runError"));
                catalogResults.put((Object)"Error", (Object)runError);
            }
            catch (Exception e) {
                logger.error(logFormat.getFormattedLog(), resultJSON.toJSONString());
                logger.error(logFormat.getFormattedLog(), e);
                e.printStackTrace();
            }
        }
        return modifiedCatalogInfo;
    }

    private JSONObject convertArrayToObject(JSONArray catalogInfo, LogFormat logFormat) {
        JSONObject catalogResults = new JSONObject();
        for (Object result : catalogInfo) {
            JSONObject resultJSON = (JSONObject)result;
            try {
                String runStatus = String.valueOf(resultJSON.get((Object)"runStatus"));
                if ("0".equalsIgnoreCase(runStatus)) {
                    JSONObject runJson = (JSONObject)resultJSON.getOrDefault((Object)"runJson", (Object)new JSONObject());
                    JSONArray arr = (JSONArray)runJson.getOrDefault((Object)"results", (Object)new JSONArray());
                    if (String.valueOf(resultJSON.get((Object)"queryType")).equalsIgnoreCase("COLS_META")) {
                        catalogResults.put((Object)"COLS_META", (Object)arr);
                        continue;
                    }
                    if (String.valueOf(resultJSON.get((Object)"queryType")).equalsIgnoreCase("CONS_META_FOREIGN")) {
                        catalogResults.put((Object)"CONS_META_FOREIGN", (Object)arr);
                        continue;
                    }
                    if (String.valueOf(resultJSON.get((Object)"queryType")).equalsIgnoreCase("TBLS_META")) {
                        catalogResults.put((Object)"TBLS_META", (Object)arr);
                        continue;
                    }
                    if (!String.valueOf(resultJSON.get((Object)"queryType")).equalsIgnoreCase("CONS_META")) continue;
                    catalogResults.put((Object)"CONS_META", (Object)arr);
                    continue;
                }
                String runError = String.valueOf(resultJSON.get((Object)"runError"));
                catalogResults.put((Object)"Error", (Object)runError);
            }
            catch (Exception e) {
                logger.error(logFormat.getFormattedLog(), resultJSON.toJSONString());
                logger.error(logFormat.getFormattedLog(), e);
                e.printStackTrace();
            }
        }
        return catalogResults;
    }

    private Boolean isCatalogSuccess(JSONArray catalogInfo) {
        Boolean isCatalgSuccess = true;
        for (Object result : catalogInfo) {
            JSONObject resultJSON = (JSONObject)result;
            String runStatus = String.valueOf(resultJSON.get((Object)"runStatus"));
            if (!"-1".equalsIgnoreCase(runStatus)) continue;
            isCatalgSuccess = false;
        }
        return isCatalgSuccess;
    }

    private void waitForExecutorServiceToTerminate(ExecutorService executorService) {
        while (!executorService.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public String getScanJobMetadata(String jobId, String API_KEY) {
        String jobDetails = TLSHttpsRequestor.executePostScanSource(this.RUN_JOB_API, jobId, API_KEY);
        return Util.isNotNullOrEmpty(jobDetails) && (!jobDetails.contains("error") || !jobDetails.contains("Forbidden")) ? jobDetails : "";
    }

    public String getScanJobs(String API_KEY) {
        if (Util.isNotNullOrEmpty(API_KEY)) {
            String resp = this.isCASignedCertConfigured(this.httpsCertType) ? TLSHttpsRequestor.executeGet(this.FETCH_JOB_URL, new Object[0], new Object[0], API_KEY) : SelfSignedHttps.executeGetRequest(this.FETCH_JOB_URL, new Object[0], new Object[0], API_KEY);
            return !Util.isNullOrEmpty(resp) && !resp.contains("error") ? resp : "";
        }
        logger.info("API Key is missing in configuration file");
        System.out.println("API Key is missing in configuration file");
        return null;
    }

    private boolean isCASignedCertConfigured(String CertType) {
        return "caSigned".equalsIgnoreCase(CertType);
    }

    private void create_output_directory(String executionId, LogFormat logFormat) {
        try {
            File dir = new File("./scan_output/" + executionId);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), e);
        }
    }

    private void loadScanErrorsToS3(JSONObject errorObj, JSONObject scanSourceMeta, LogFormat logFormat) {
        logger.debug(logFormat.getFormattedLog(), "Loading scan error to s3");
        String executionId = String.valueOf(scanSourceMeta.get((Object)"execution_id"));
        String baseFilePath = "./scan_output/" + executionId + "/";
        String fileName = "error_output.json";
        String jsonFilePath = String.valueOf(baseFilePath) + fileName;
        FileUtil.writeJsonToFile(jsonFilePath, errorObj);
        JSONObject s3PreSignedURLInfo = (JSONObject)scanSourceMeta.get((Object)"s3_pre_signed_post_url");
        MultipartFileUploader.uploadFileToS3(jsonFilePath, s3PreSignedURLInfo, logFormat);
    }
}

