/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.dto.FileInfo;
import com.dvsum.exception.FileUploadException;
import com.dvsum.logger.CustomLogger;
import com.dvsum.util.Util;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Component
public class FileUploadService {
    private static final int BUFFER_SIZE = 4096;
    private static final CustomLogger logger = CustomLogger.getLogger(FileUploadService.class);

    public String unzip(String destDirectory, MultipartFile zipFile, String templateFileName, String executeScript, String updateProps) throws Exception {
        ArrayList<FileInfo> uploadedFiles = new ArrayList<FileInfo>();
        try (ZipInputStream zipInputStream = null;){
            File destDir = new File(destDirectory);
            if (!destDir.exists()) {
                throw new FileUploadException("Destination folder " + destDir.getName() + " does not exist. Please contact your System Administrator or DvSum Support");
            }
            zipInputStream = new ZipInputStream(zipFile.getInputStream());
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                String filePath = String.valueOf(destDirectory) + File.separator + entry.getName();
                if (entry.isDirectory()) {
                    throw new FileUploadException("The zip file uploaded has errors. Only zip files without sub-folders can be added");
                }
                this.extractFile(zipInputStream, filePath, entry.getName(), templateFileName, executeScript, updateProps);
                uploadedFiles.add(this.getFileInfo(entry.getName()));
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
        return ((Object)uploadedFiles).toString();
    }

    private void extractFile(ZipInputStream zipIn, String filePath, String fileName, String templateFileName, String executeScript, String updateProps) throws IOException {
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(filePath));
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                ((BufferedOutputStream)bos).write(bytesIn, 0, read);
            }
            String string = Util.isNullOrEmpty(templateFileName) ? fileName : templateFileName;
        }
    }

    public String upload(String directory, MultipartFile file, String templateFileName, String executeScript, String updateProps) throws Exception {
        FileInfo uploadedFiles;
        block6: {
            uploadedFiles = null;
            Object resp = null;
            try (FilterOutputStream stream = null;){
                if (file.isEmpty()) break block6;
                byte[] bytes = file.getBytes();
                File dir = new File(directory);
                if (!dir.exists()) {
                    throw new FileUploadException("Destination folder " + dir.getName() + " does not exist. Please contact your System Administrator or DvSum Support");
                }
                if (this.isValidFile(file.getOriginalFilename())) {
                    File uploadedFile = new File(String.valueOf(dir.getAbsolutePath()) + File.separator + file.getOriginalFilename());
                    stream = new BufferedOutputStream(new FileOutputStream(uploadedFile));
                    stream.write(bytes);
                    uploadedFiles = this.getFileInfo(file.getOriginalFilename());
                    logger.debug("Uploaded " + file.getOriginalFilename() + " to " + uploadedFile.getAbsolutePath());
                    String string = Util.isNullOrEmpty(templateFileName) ? file.getOriginalFilename() : templateFileName;
                    break block6;
                }
                logger.info(" Invalid File ");
                throw new FileUploadException("Invalid file");
            }
        }
        return uploadedFiles.toString();
    }

    private boolean isValidFile(String fileName) {
        return fileName != null && (fileName.toLowerCase().endsWith(".csv") || fileName.toLowerCase().endsWith(".xlsx") || fileName.toLowerCase().endsWith(".xls") || fileName.toLowerCase().endsWith(".xlsm") || fileName.toLowerCase().endsWith(".xlsd") || fileName.toLowerCase().endsWith(".zip") || fileName.toLowerCase().endsWith(".txt") || fileName.toLowerCase().endsWith(".pdf"));
    }

    public List<FileInfo> getAllFiles(String directoryName, List<FileInfo> resultList) {
        try {
            System.out.println(" dir " + directoryName);
            File directory = new File(directoryName);
            String preprocessdirectory = String.valueOf(directoryName) + "\\ExcelPreProcessProps\\";
            File[] fList = directory.listFiles() != null ? directory.listFiles() : new File[]{};
            System.out.println(fList);
            File[] fileArray = fList;
            int n = fList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    if (this.isValidFile(file.getName())) {
                        String propFileName = String.valueOf(FilenameUtils.removeExtension((String)file.getName().toUpperCase())) + "_preProcess.properties";
                        File propsFile = new File(String.valueOf(preprocessdirectory) + propFileName);
                        resultList.add(this.getFileInfo(file, propsFile.exists(), propsFile.length()));
                    }
                } else if (file.isDirectory()) {
                    this.isPreserveExcelDir(file.getPath());
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public boolean isPreserveExcelDir(String filePath) {
        return filePath != null && filePath.contains("preservedExcel");
    }

    public void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    public FileInfo getFileInfo(File file, boolean exists, Long size) {
        return new FileInfo(file.getName(), Util.getUniqueId(), new Date(file.lastModified()), exists, size);
    }

    public FileInfo getFileInfo(String name) {
        return new FileInfo(name, Util.getUniqueId(), new Date(), false, 0L);
    }
}

