/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.logger.CustomLogger;
import com.dvsum.util.FileUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ExecutorServiceHandler {
    private static final CustomLogger logger = CustomLogger.getLogger(ExecutorServiceHandler.class);
    private static Map<String, ExecutorService> jobExecutorServiceMap = new ConcurrentHashMap<String, ExecutorService>();

    public static void addExecutorService(String jobId, ExecutorService executorService) {
        jobExecutorServiceMap.put(jobId, executorService);
        logger.info("Added executor service for Job", jobId);
    }

    public static void removeExecutorService(String jobId) {
        jobExecutorServiceMap.remove(jobId);
        logger.info("Deleted executor service for Job", jobId);
    }

    public static ExecutorService createExecutorService(String jobId) {
        Integer poolSize = Integer.parseInt(FileUtil.getPropertyWithDefault("max.database.connection.allowed", "10"));
        ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
        ExecutorServiceHandler.addExecutorService(jobId, executorService);
        return executorService;
    }

    public static void shutDownExecutorService(String jobId) {
        logger.info("Request received to Shutdown job :", jobId);
        ExecutorService executorService = jobExecutorServiceMap.get(jobId);
        if (executorService != null) {
            logger.info("Shutdown init ", jobId);
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    executorService.shutdownNow();
                    logger.info("Shutdown Done ", jobId);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ExecutorServiceHandler.removeExecutorService(jobId);
        } else {
            logger.error("ExecutorService not found for job ID: ", jobId);
        }
    }

    public static String getExistingJobIds() {
        String jobIds = null;
        if (!jobExecutorServiceMap.isEmpty()) {
            jobIds = String.join((CharSequence)",", jobExecutorServiceMap.keySet());
        }
        return jobIds;
    }
}

