/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.dataSource.DataSource;
import com.dvsum.dataSource.DatabricksNativeSource;
import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.InMemoryProps;
import com.dvsum.model.ref.RefDBType;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.TLSHttpsRequestor;
import com.dvsum.util.Util;
import com.dvsum.websocket.ConnectionManager;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataSourceConnectionService {
    private static final CustomLogger logger = CustomLogger.getLogger(DataSourceConnectionService.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Value(value="${url.verifier_code}")
    private String verifierCodeUrl;
    @Value(value="${post.metadata_query.api}")
    private String metadataQueryUrl;
    private static final String PARENT_DIR = String.valueOf(System.getProperty("user.dir")) + File.separator + "cdata" + File.separator;

    public String performTestConnection(JSONObject data, LogFormat logFormat) {
        try {
            DataSource dataSource = this.dataSourceFactory.getDataSource(String.valueOf(data.get((Object)"sourceType")), data, false, logFormat);
            dataSource.connect();
            dataSource.disconnect();
            return "SUCCESS";
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error Trace : ", e);
            return "ERROR";
        }
    }

    private String getOauthTokenAccessURL(String loginURL) {
        if (loginURL.endsWith("/")) {
            return String.valueOf(loginURL) + "services/oauth2/token";
        }
        return String.valueOf(loginURL) + "/services/oauth2/token";
    }

    public JSONObject getVerifierCode(JSONObject data) {
        JSONObject result = new JSONObject();
        try {
            String useSandbox;
            String clientId = String.valueOf(data.get((Object)"clientId"));
            String secretKey = String.valueOf(data.get((Object)"secretKey"));
            String connectionPrefix = String.valueOf(data.get((Object)"connectionPrefix"));
            String driverClassName = String.valueOf(data.get((Object)"driverClassName"));
            String sourceId = String.valueOf(data.get((Object)"sourceId"));
            String sourceType = String.valueOf(data.get((Object)"sourceType"));
            String connectionId = String.valueOf(data.get((Object)"connectionId"));
            Class.forName(driverClassName);
            Properties props = new Properties();
            props.setProperty("InitiateOAuth", "OFF");
            props.setProperty("OAuthClientId", clientId);
            props.setProperty("OAuthClientSecret", secretKey);
            props.setProperty("OEMKey", InMemoryProps.CDATA_OEM_KEY);
            if (sourceType.equals("ZHO")) {
                props.setProperty("API Domain", "https://www.zohoapis.com");
            }
            if ("SLF".equalsIgnoreCase(sourceType) && "true".equalsIgnoreCase(useSandbox = String.valueOf(data.get((Object)"useSandbox")))) {
                String loginURL = String.valueOf(data.get((Object)"loginURL"));
                props.setProperty("useSandbox", "true");
                props.setProperty("LoginURL", loginURL);
                props.setProperty("OAuthAccessTokenURL", this.getOauthTokenAccessURL(loginURL));
            }
            props.setProperty("Logfile", String.valueOf(PARENT_DIR) + "log.txt");
            props.setProperty("Verbosity", "1");
            Connection conn = DriverManager.getConnection(String.valueOf(connectionPrefix) + ":", props);
            CallableStatement cstmt = conn.prepareCall("GetOAuthAuthorizationURL");
            cstmt.setString("CallbackURL", this.verifierCodeUrl);
            cstmt.setString("State", connectionId);
            cstmt.execute();
            ResultSet rs = cstmt.getResultSet();
            rs.next();
            result.put((Object)"status", (Object)"SUCCESS");
            result.put((Object)"url", (Object)rs.getString(1));
            rs.close();
            cstmt.close();
            conn.close();
            return result;
        }
        catch (Exception e) {
            result.put((Object)"status", (Object)"FAILED");
            result.put((Object)"error", (Object)e.getLocalizedMessage());
            logger.error("exception: ", e);
            e.printStackTrace();
            return result;
        }
    }

    public JSONObject authenticate(JSONObject data) {
        String status = "FAILED";
        String authSettings = "";
        JSONObject response = new JSONObject();
        try {
            try {
                String useSandbox;
                String clientId = String.valueOf(data.get((Object)"clientId"));
                String secretKey = String.valueOf(data.get((Object)"secretKey"));
                String connectionPrefix = String.valueOf(data.get((Object)"connectionPrefix"));
                String driverClassName = String.valueOf(data.get((Object)"driverClassName"));
                String sourceId = String.valueOf(data.get((Object)"sourceId"));
                String sourceType = String.valueOf(data.get((Object)"sourceType"));
                String verifierCode = String.valueOf(data.get((Object)"verifierCode"));
                String settingsLocation = String.valueOf(PARENT_DIR) + "auth-" + sourceId + ".txt";
                FileUtil.deleteFileIfExists(settingsLocation);
                Class.forName(driverClassName);
                Properties props = new Properties();
                props.setProperty("OAuthClientId", clientId);
                props.setProperty("OAuthClientSecret", secretKey);
                props.setProperty("OEMKey", InMemoryProps.CDATA_OEM_KEY);
                props.setProperty("OAuthVerifier", verifierCode);
                props.setProperty("OAuthSettingsLocation", settingsLocation);
                props.setProperty("InitiateOAuth", "REFRESH");
                props.setProperty("CallbackURL", this.verifierCodeUrl);
                props.setProperty("Logfile", String.valueOf(PARENT_DIR) + "/logs/cdata-logs.txt");
                props.setProperty("Verbosity", "1");
                props.setProperty("SessionTimeout", "0");
                props.setProperty("Other", "ConnectOnOpen=True;");
                if ("SLF".equalsIgnoreCase(sourceType) && "true".equalsIgnoreCase(useSandbox = String.valueOf(data.get((Object)"useSandbox")))) {
                    String loginURL = String.valueOf(data.get((Object)"loginURL"));
                    props.setProperty("useSandbox", "true");
                    props.setProperty("LoginURL", loginURL);
                    props.setProperty("OAuthAccessTokenURL", this.getOauthTokenAccessURL(loginURL));
                }
                System.out.println("SETTINGS LOCATION = " + settingsLocation.toString());
                System.out.println("Verifier Code  = " + props.getProperty("OAuthVerifier"));
                Connection conn = DriverManager.getConnection(String.valueOf(connectionPrefix) + ":", props);
                conn.close();
                authSettings = this.getSettingsFileContent(settingsLocation);
                status = "SUCCESS";
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("exception: ", e);
                response.put((Object)"status", (Object)status);
                response.put((Object)"authSettings", (Object)authSettings);
            }
        }
        finally {
            response.put((Object)"status", (Object)status);
            response.put((Object)"authSettings", (Object)authSettings);
        }
        return response;
    }

    public String getSettingsFileContent(String filePath) {
        String response = "";
        try {
            File settingsFile = new File(filePath);
            System.out.println("Settings File exists or not ? " + settingsFile.exists());
            if (settingsFile.exists()) {
                response = FileUtil.readDataFromFile(filePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response = e.getMessage().toString();
        }
        return response;
    }

    public JSONObject getGBQDatasets(String biqQueryJWT) {
        JSONObject response;
        try {
            byte[] valueDecoded = Base64.decodeBase64((String)biqQueryJWT);
            biqQueryJWT = new String(valueDecoded);
            String authFilePath = String.valueOf(PARENT_DIR) + "auth-temp.txt";
            ObjectMapper mapper = new ObjectMapper();
            Map jwtMap = (Map)mapper.readValue(biqQueryJWT, Map.class);
            Class.forName("cdata.jdbc.googlebigquery.GoogleBigQueryDriver");
            Properties props = new Properties();
            props.setProperty("ProjectId", (String)jwtMap.get("project_id"));
            props.setProperty("AuthScheme", "OAuthJWT");
            props.setProperty("InitiateOAuth", "GETANDREFRESH");
            props.setProperty("OAuthJWTCertType", "GOOGLEJSONBLOB");
            props.setProperty("OAuthJWTCert", biqQueryJWT);
            props.setProperty("OAuthSettingsLocation", authFilePath);
            props.setProperty("Timeout", "10");
            props.setProperty("OEMKey", InMemoryProps.CDATA_OEM_KEY);
            props.setProperty("Logfile", String.valueOf(PARENT_DIR) + "log.txt");
            props.setProperty("Verbosity", "1");
            props.setProperty("Other", "ConnectOnOpen=True;");
            File authFile = new File(authFilePath);
            if (authFile.exists()) {
                authFile.delete();
            }
            Connection connection = DriverManager.getConnection("jdbc:googlebigquery:", props);
            Statement st = connection.createStatement();
            st.executeUpdate("RESET SCHEMA CACHE");
            ResultSet rs = st.executeQuery("Select * from Datasets");
            rs.next();
            response = new JsonUtil().ResultSet2JSONObject(rs, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
            response = new JSONObject();
            response.put((Object)"exception", (Object)e.getMessage());
        }
        return response;
    }

    public String getMetadataQuery(JSONObject connectionJson, int srcId, LogFormat logFormat) {
        String query = "";
        try {
            String API_key = FileUtil.getAPIkey();
            String metadataQueryUrlModified = this.metadataQueryUrl.replace("{srcId}", String.valueOf(srcId));
            String queryResponse = TLSHttpsRequestor.executePost(metadataQueryUrlModified, connectionJson.toJSONString(), API_key, logFormat);
            JSONArray queryResponseArray = JsonUtil.parseToJsonArray(queryResponse);
            JSONObject responseObject = (JSONObject)queryResponseArray.get(0);
            query = (String)responseObject.get((Object)"TARGET_QUERY");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), "Error Trace : ", e);
        }
        return query;
    }

    public JSONObject getDatabases(String data, int srcId, LogFormat logFormat) {
        JSONObject response = new JSONObject();
        try {
            JSONObject connectionJson = JsonUtil.parseToJsonObject(data);
            String query = this.getMetadataQuery(connectionJson, srcId, logFormat);
            response = this.getQueryResultsFromJDBC(query, connectionJson, logFormat);
            String sourceType = (String)connectionJson.get((Object)"source_type");
            if (RefDBType.isDatabricks(sourceType)) {
                this.sendGetDatabasesResponseToWebsocket(response, connectionJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), " Error Trace : ", e);
        }
        return response;
    }

    public JSONObject getSchemas(String data, int srcId, LogFormat logFormat) {
        JSONObject response = new JSONObject();
        try {
            JSONObject connectionJson = JsonUtil.parseToJsonObject(data);
            String query = this.getMetadataQuery(connectionJson, srcId, logFormat);
            if (query.contains("$DB_NAME$")) {
                String db_name = (String)connectionJson.get((Object)"db_name");
                query = query.replace("$DB_NAME$", db_name);
            }
            response = this.getQueryResultsFromJDBC(query, connectionJson, logFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), " Error Trace : ", e);
        }
        return response;
    }

    public JSONObject getQueryResultsFromJDBC(String query, JSONObject connectionJson, LogFormat logFormat) {
        JSONObject response;
        block4: {
            response = new JSONObject();
            try {
                String sourceType = (String)connectionJson.get((Object)"source_type");
                if (RefDBType.isDatabricks(sourceType)) {
                    this.connectWithNativeDatabricks(connectionJson, logFormat);
                }
                DataSource dataSource = this.dataSourceFactory.getDataSource(String.valueOf(sourceType), connectionJson, false, logFormat);
                dataSource.connect();
                logger.info(logFormat.getFormattedLog(), "Connection successful.");
                Connection connection = dataSource.connection;
                Statement st = connection.createStatement();
                ResultSet rs = st.executeQuery(query);
                boolean results_exist = rs.next();
                if (!results_exist) {
                    throw new Exception("Result Set is empty.");
                }
                response = new JsonUtil().ResultSet2JSONObject(rs, false);
                dataSource.disconnect();
                logger.info(logFormat.getFormattedLog(), "Connection terminated.");
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(logFormat.getFormattedLog(), "ERROR TRACE : ", e);
                String sourceType = (String)connectionJson.get((Object)"source_type");
                if (!sourceType.equalsIgnoreCase("ORC") || !e.getMessage().contains("table or view does not exist")) break block4;
                response.put((Object)"resultCount", (Object)1);
                response.put((Object)"keysOrder", (Object)new String[]{"SCHEMA_NAME"});
                JSONObject result = new JSONObject();
                result.put((Object)"schema_name", (Object)connectionJson.get((Object)"db_login").toString().toUpperCase());
                response.put((Object)"results", (Object)new JSONObject[]{result});
                response.put((Object)"errors", (Object)new String[0]);
            }
        }
        return response;
    }

    public void connectWithNativeDatabricks(JSONObject connectionJson, LogFormat logFormat) throws Exception {
        if (!"AzureServicePrincipal".equalsIgnoreCase(String.valueOf(connectionJson.get((Object)"AuthScheme"))) || connectionJson.containsKey((Object)"OAuthSecret") && Util.isNotNullOrEmpty(String.valueOf(connectionJson.get((Object)"OAuthSecret")))) {
            DataSource dataSourceNative = this.dataSourceFactory.getDataSource("DBN", connectionJson, false, logFormat);
            DatabricksNativeSource databricksSource = (DatabricksNativeSource)dataSourceNative;
            databricksSource.connect();
            if (databricksSource.isWarehousesExistsInHttpPath().booleanValue()) {
                databricksSource.executeSampleQuery();
            }
            dataSourceNative.disconnect();
        }
    }

    private void sendGetDatabasesResponseToWebsocket(JSONObject response, JSONObject connectionJson) {
        response.put((Object)"browser_websocket_connection_id", connectionJson.get((Object)"browser_websocket_connection_id"));
        if (!response.isEmpty() && response.containsKey((Object)"results") && !((JSONArray)response.get((Object)"results")).isEmpty()) {
            response.put((Object)"status_code", (Object)200);
        } else {
            response.put((Object)"status_code", (Object)500);
        }
        JSONObject websocketMessage = new JSONObject();
        websocketMessage.put((Object)"context", (Object)"authenticate");
        websocketMessage.put((Object)"source", (Object)"dvsumConnector");
        websocketMessage.put((Object)"type", (Object)"getDatabases");
        websocketMessage.put((Object)"message", (Object)response);
        logger.info("Sending websocket message...", websocketMessage.toJSONString());
        ConnectionManager.sendWebsocketMessageWithRetry(websocketMessage);
    }
}

