/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.logger.CustomLogger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service
public class DataRetentionManagerService {
    private static final CustomLogger logger = CustomLogger.getLogger(DataRetentionManagerService.class);

    public static void main(String[] args) {
        String rootDirectoryPath = "./scan_output";
        int retentionPeriodInDays = 8;
        DataRetentionManagerService dataRetentionManagerService = new DataRetentionManagerService();
        dataRetentionManagerService.deleteImmediateSubdirectoriesOlderThan(rootDirectoryPath, retentionPeriodInDays);
    }

    public void deleteImmediateSubdirectoriesOlderThan(String rootDirectoryPath, int retentionPeriodInDays) {
        File rootDirectory = new File(rootDirectoryPath);
        if (!rootDirectory.exists() || !rootDirectory.isDirectory()) {
            logger.error("Invalid root directory path.");
            return;
        }
        File[] subdirectories = rootDirectory.listFiles(File::isDirectory);
        if (subdirectories != null) {
            File[] fileArray = subdirectories;
            int n = subdirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File subdirectory = fileArray[n2];
                if (this.isOlderThan(subdirectory, retentionPeriodInDays)) {
                    this.deleteDirectory(subdirectory);
                }
                ++n2;
            }
        }
    }

    private boolean isOlderThan(File directory, int retentionPeriodInDays) {
        long currentTime = System.currentTimeMillis();
        try {
            Path directoryPath = directory.toPath();
            BasicFileAttributes attrs = Files.readAttributes(directoryPath, BasicFileAttributes.class, new LinkOption[0]);
            Date creationDate = new Date(attrs.creationTime().toMillis());
            long diffInMillies = currentTime - creationDate.getTime();
            long diffInDays = diffInMillies / 86400000L;
            return diffInDays > (long)retentionPeriodInDays;
        }
        catch (Exception e) {
            logger.error("Error occurred while checking directory: " + directory.getAbsolutePath() + ". " + e.getMessage());
            return false;
        }
    }

    private void deleteDirectory(File directory) {
        if (!directory.exists()) {
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                } else if (!file.delete()) {
                    logger.error("Unable to delete file: " + file.getAbsolutePath());
                }
                ++n2;
            }
        }
        if (!directory.delete()) {
            logger.error("Unable to delete directory: " + directory.getAbsolutePath());
        } else {
            logger.info("Deleted directory: " + directory.getAbsolutePath());
        }
    }
}

