/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.services;

import com.dvsum.factory.DataSourceFactory;
import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.DefaultDatatypeMap;
import com.dvsum.util.FileUtil;
import com.dvsum.util.GzipUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.util.Util;
import com.dvsum.websocket.ConnectionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class AnalyticsQueryExecutorService {
    private static final CustomLogger logger = CustomLogger.getLogger(AnalyticsQueryExecutorService.class);
    @Autowired
    private DataSourceFactory dataSourceFactory;

    public void executeQueries(JSONObject queriesMetadata, LogFormat logFormat) {
        logger.info(logFormat.getFormattedLog(), "Executing analytics query");
        JSONObject websocketMessage = new JSONObject();
        String queryId = "";
        String queryText = "";
        String browserConnectionId = "";
        String isCloudSAWS = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
        int retryCount = 0;
        String authToken = "";
        String sourceId = "";
        String analysisId = "";
        String questionText = "";
        String verbose = "";
        String refNodeId = "";
        try {
            JSONObject connectionInfo = (JSONObject)queriesMetadata.get((Object)"connection_config");
            authToken = queriesMetadata.containsKey((Object)"auth_token") ? String.valueOf(queriesMetadata.get((Object)"auth_token")) : "";
            retryCount = queriesMetadata.containsKey((Object)"retry_count") ? Integer.parseInt(String.valueOf(queriesMetadata.get((Object)"retry_count"))) : 0;
            JSONArray queriesList = (JSONArray)queriesMetadata.get((Object)"queries");
            String executionId = String.valueOf(queriesMetadata.get((Object)"execution_id"));
            queryId = String.valueOf(queriesMetadata.get((Object)"query_id"));
            queryText = String.valueOf(queriesMetadata.get((Object)"query_text"));
            questionText = String.valueOf(queriesMetadata.get((Object)"question_text"));
            String sawsId = String.valueOf(queriesMetadata.get((Object)"saws_id"));
            browserConnectionId = String.valueOf(queriesMetadata.get((Object)"browser_connection_id"));
            JSONObject S3PreSignedURLInfo2 = (JSONObject)queriesMetadata.get((Object)"s3_pre_signed_post_url");
            sourceId = String.valueOf(queriesMetadata.get((Object)"source_id"));
            analysisId = String.valueOf(queriesMetadata.get((Object)"analysis_id"));
            verbose = String.valueOf(queriesMetadata.get((Object)"verbose"));
            refNodeId = Util.isNotNullOrEmpty(String.valueOf(queriesMetadata.get((Object)"ref_node_id"))) ? String.valueOf(queriesMetadata.get((Object)"ref_node_id")) : "";
            String accountId = String.valueOf(queriesMetadata.get((Object)"account_id"));
            String baseFilePath = "./data_analysis/" + queryId + "/";
            String isCdataSrc = String.valueOf(queriesMetadata.get((Object)"is_cdata_src"));
            String sourceType = String.valueOf(queriesMetadata.get((Object)"source_type"));
            String verboseS3Url = String.valueOf(queriesMetadata.get((Object)"verbose_s3_url"));
            Integer resultLimit = Integer.valueOf(String.valueOf(queriesMetadata.get((Object)"result_limit")));
            JSONObject datatypeMap = new JSONObject();
            if (queriesMetadata.get((Object)"datatype_map") != null) {
                datatypeMap = (JSONObject)queriesMetadata.get((Object)"datatype_map");
            } else {
                logger.debug(logFormat.getFormattedLog(), "Datatype Map is Null. Setting Default Datatype Map");
                datatypeMap = DefaultDatatypeMap.getDatatypeMap();
            }
            List<Future<JSONObject>> queryResults = this.submitQueries(isCdataSrc, sourceType, connectionInfo, queriesList, queryId, logFormat);
            JSONArray queriesResultsJSON = this.processQueryResults(queryResults, logFormat);
            Map<String, String> outputFilesMetadata = this.writeQueryResultsToOutputFiles(queriesResultsJSON, baseFilePath, isCloudSAWS, resultLimit, datatypeMap, logFormat);
            if ("false".equalsIgnoreCase(isCloudSAWS)) {
                logger.info(logFormat.getFormattedLog(), "On-Prem Gateway : Storing output files in local file system");
            } else {
                logger.info(logFormat.getFormattedLog(), "Cloud Gateway : Uploading output files to S3");
                outputFilesMetadata = this.uploadFilesToS3(S3PreSignedURLInfo2, outputFilesMetadata, logFormat);
            }
            websocketMessage = this.prepareWebsocketMessage(outputFilesMetadata, isCloudSAWS, browserConnectionId, sawsId, queryId, queryText, questionText, retryCount, authToken, sourceId, analysisId, verbose, refNodeId, verboseS3Url, logFormat);
        }
        catch (Exception e) {
            logger.error(logFormat.getFormattedLog(), "Error while executing analytics queries. Error = ", e);
            JSONObject message = new JSONObject();
            message.put((Object)"status_code", (Object)500);
            message.put((Object)"error_message", (Object)e.getMessage());
            message.put((Object)"query_id", (Object)queryId);
            message.put((Object)"query_text", (Object)queryText);
            message.put((Object)"browser_connection_id", (Object)browserConnectionId);
            message.put((Object)"is_cloud_saws", (Object)isCloudSAWS);
            message.put((Object)"retry_count", (Object)retryCount);
            message.put((Object)"auth_token", (Object)authToken);
            message.put((Object)"source_id", (Object)sourceId);
            message.put((Object)"analysis_id", (Object)analysisId);
            message.put((Object)"question_text", (Object)questionText);
            message.put((Object)"verbose", (Object)verbose);
            message.put((Object)"ref_node_id", (Object)refNodeId);
            websocketMessage = this.buildWebsocketPayload(message);
        }
        ConnectionManager.sendWebsocketMessageWithRetry(websocketMessage);
    }

    private List<Future<JSONObject>> submitQueries(String isCdataSrc, String sourceType, JSONObject connectionInfo, JSONArray queriesList, String queryId, LogFormat logFormat) {
        ArrayList<Future<JSONObject>> queryResults = new ArrayList<Future<JSONObject>>();
        Integer poolSize = Integer.parseInt(FileUtil.getPropertyWithDefault("max.database.connection.allowed", "10"));
        ExecutorService executorService = Executors.newFixedThreadPool(poolSize);
        for (Object query : queriesList) {
            try {
                JSONObject queryObj = (JSONObject)query;
                JSONObject newConnection = new JSONObject();
                newConnection.putAll((Map)connectionInfo);
                newConnection.put((Object)"runQuery", (Object)String.valueOf(queryObj.get((Object)"query_sql")));
                newConnection.put((Object)"query_metadata", (Object)queryObj.toJSONString());
                newConnection.put((Object)"queryType", (Object)"ANL");
                newConnection.put((Object)"source_type", (Object)sourceType);
                newConnection.put((Object)"is_cdata_src", (Object)isCdataSrc);
                newConnection.put((Object)"is_analytics_query", (Object)"true");
                newConnection.put((Object)"query_id", (Object)queryId);
                QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, newConnection, false, logFormat);
                Future futureResult = executorService.submit(queryExecutor);
                queryResults.add(futureResult);
            }
            catch (Exception e) {
                logger.error(logFormat.getFormattedLog(), "Error", e);
                throw e;
            }
        }
        return queryResults;
    }

    private JSONArray processQueryResults(List<Future<JSONObject>> queryResults, LogFormat logFormat) throws Exception {
        JSONArray queriesJSONResults = new JSONArray();
        for (Future<JSONObject> queryResult : queryResults) {
            try {
                if (queryResult.get() == null || queryResult.get().isEmpty()) continue;
                queriesJSONResults.add((Object)queryResult.get());
            }
            catch (Exception e) {
                logger.error(logFormat.getFormattedLog(), "Error:", e);
                throw e;
            }
        }
        return queriesJSONResults;
    }

    private Map<String, String> writeQueryResultsToOutputFiles(JSONArray queryResults, String baseFilePath, String isCloudSaws, Integer resultLimit, JSONObject datatypeMap, LogFormat logFormat) {
        HashMap<String, String> filesMetadata = new HashMap<String, String>();
        String outputFilePath10kJson = String.valueOf(baseFilePath) + "output_10k.json";
        String outputFilePathProfileJson = String.valueOf(baseFilePath) + "profile.json";
        int totalCount = 0;
        int resultCount = 0;
        for (Object result : queryResults) {
            try {
                JSONObject resultJSON = (JSONObject)result;
                String runJsonStr = null;
                runJsonStr = !"-1".equalsIgnoreCase(String.valueOf(resultJSON.get((Object)"runStatus"))) ? String.valueOf(resultJSON.get((Object)"runJson")) : this.getErrorResponse(runJsonStr, resultJSON, logFormat);
                if (runJsonStr == null || runJsonStr.equalsIgnoreCase("null")) {
                    runJsonStr = this.getErrorResponse(runJsonStr, resultJSON, logFormat);
                }
                JSONObject query_metadata = JsonUtil.parseToJsonObject(String.valueOf(resultJSON.get((Object)"query_metadata")));
                String ouputFormate = String.valueOf(query_metadata.get((Object)"output_formate"));
                String queryType = String.valueOf(query_metadata.get((Object)"query_type"));
                Integer seqId = Integer.valueOf(String.valueOf(query_metadata.get((Object)"seq_id")));
                if ("analytics_query".equalsIgnoreCase(queryType)) {
                    JSONObject runJson = JsonUtil.parseToJsonObject(runJsonStr);
                    resultCount = runJson.get((Object)"resultCount") != null ? Integer.valueOf(String.valueOf(runJson.get((Object)"resultCount"))) : 0;
                    filesMetadata.put("result_count", String.valueOf(resultCount));
                    JSONArray resultsJsonArray = (JSONArray)runJson.get((Object)"results");
                    String textToWrite = resultsJsonArray.toJSONString();
                    if ("false".equalsIgnoreCase(isCloudSaws)) {
                        textToWrite = CryptographicUtil.encrypt(textToWrite);
                    }
                    FileUtil.writeToFileIfNotExists(outputFilePath10kJson, textToWrite);
                    filesMetadata.put("output_10k_json", outputFilePath10kJson);
                    JSONObject profileJSON = this.createProfileJSON((JSONArray)runJson.get((Object)"keysOrder"), resultsJsonArray, datatypeMap, logFormat);
                    FileUtil.writeJsonToFile(outputFilePathProfileJson, profileJSON);
                    filesMetadata.put("profile_json", outputFilePathProfileJson);
                    continue;
                }
                if (!"count_query".equalsIgnoreCase(queryType)) continue;
                totalCount = this.getCountFromJsonString(runJsonStr, logFormat);
                filesMetadata.put("total_count", String.valueOf(totalCount));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return filesMetadata;
    }

    public static JSONArray mapColumnTypeIds(JSONArray columnTypeJsonArray, JSONObject datatypeMap) {
        JSONArray customColumnTypeJsonArray = new JSONArray();
        columnTypeJsonArray.forEach(colObject -> {
            JSONObject colJson = (JSONObject)colObject;
            String colType = String.valueOf(colJson.get((Object)"colType"));
            String customColType = AnalyticsQueryExecutorService.mapToCustomColumnTypeIds(colType, datatypeMap);
            colJson.replace((Object)"colType", (Object)customColType);
            customColumnTypeJsonArray.add((Object)colJson);
        });
        return customColumnTypeJsonArray;
    }

    private static String mapToCustomColumnTypeIds(String resultSetColumnType, JSONObject datatypeMap) {
        String colTypeId = "STR";
        resultSetColumnType = resultSetColumnType.toUpperCase();
        if (datatypeMap != null && datatypeMap.containsKey((Object)resultSetColumnType)) {
            colTypeId = (String)datatypeMap.get((Object)resultSetColumnType);
        }
        return colTypeId;
    }

    private static String getColumnTypeByColumnTypeId(String colTypeId) {
        String colType = null;
        switch (colTypeId) {
            case "DTE": {
                colType = "Date";
                break;
            }
            case "DTM": {
                colType = "Datetime";
                break;
            }
            case "NUM": {
                colType = "Integer";
                break;
            }
            case "DEC": {
                colType = "Decimal";
                break;
            }
            case "BOL": {
                colType = "Boolean";
                break;
            }
            case "TIM": {
                colType = "Time";
                break;
            }
            case "BLB": {
                colType = "Blob";
                break;
            }
            case "STR": {
                colType = "String";
                break;
            }
            default: {
                colType = "String";
            }
        }
        return colType;
    }

    private JSONArray createColSeqArray(JSONArray profileJSONArray) {
        JSONArray colSeqArray = new JSONArray();
        int i = 0;
        while (i < profileJSONArray.size()) {
            JSONObject profileObject = (JSONObject)profileJSONArray.get(i);
            JSONObject colSeq = new JSONObject();
            colSeq.put((Object)"seq_id", profileObject.get((Object)"COL_ID"));
            colSeq.put((Object)"name", profileObject.get((Object)"COL_NAME"));
            colSeq.put((Object)"data_type", profileObject.get((Object)"COL_DATA_TYPE_ID"));
            colSeqArray.add((Object)colSeq);
            ++i;
        }
        return colSeqArray;
    }

    private JSONObject createProfileJSON(JSONArray columnsMetadata, JSONArray resultsJSONArray, JSONObject datatypeMap, LogFormat logFormat) {
        JSONArray metadataWithCustomColumnTypeIds = AnalyticsQueryExecutorService.mapColumnTypeIds(columnsMetadata, datatypeMap);
        JSONObject profileJsonFinal = new JSONObject();
        try {
            JSONArray profileJsonArray = new JSONArray();
            metadataWithCustomColumnTypeIds.forEach(colObject -> {
                JSONObject colJson = (JSONObject)colObject;
                profileJsonArray.add((Object)this.generateSingleProfileJsonObject(colJson, logFormat));
            });
            profileJsonFinal.put((Object)"col_seq", (Object)this.createColSeqArray(profileJsonArray));
            profileJsonFinal.put((Object)"data", (Object)profileJsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), "Error while creating Profile JSON. \nError = " + e.getLocalizedMessage());
        }
        return profileJsonFinal;
    }

    private JSONObject generateSingleProfileJsonObject(JSONObject colJson, LogFormat logFormat) {
        JSONObject profileJson = new JSONObject();
        try {
            int colId = Integer.valueOf(String.valueOf(colJson.get((Object)"colId")));
            String columnName = String.valueOf(colJson.get((Object)"colName"));
            String columnDataTypeId = String.valueOf(colJson.get((Object)"colType"));
            profileJson.put((Object)"COL_ID", (Object)colId);
            profileJson.put((Object)"COL_NAME", (Object)columnName);
            profileJson.put((Object)"COL_TITLE", (Object)columnName);
            profileJson.put((Object)"COL_DATA_TYPE_ID", (Object)columnDataTypeId);
            profileJson.put((Object)"COL_DATA_TYPE", (Object)AnalyticsQueryExecutorService.getColumnTypeByColumnTypeId(columnDataTypeId));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), "Error while creating Profile JSON Object. \nError = " + e.getLocalizedMessage());
        }
        return profileJson;
    }

    private int getCountFromJsonString(String jsonString, LogFormat logFormat) {
        int totalCount = 0;
        try {
            JSONObject runJson = JsonUtil.parseToJsonObject(jsonString);
            JSONArray resultsJsonArray = (JSONArray)runJson.get((Object)"results");
            JSONObject countObject = (JSONObject)resultsJsonArray.get(0);
            totalCount = Integer.valueOf(String.valueOf(countObject.get((Object)"count")));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), "Error while getting count from JSON String. \n ERROR = " + e.getLocalizedMessage());
        }
        return totalCount;
    }

    private JSONObject prepareWebsocketMessage(Map<String, String> filesMetadata, String isCloudSAWS, String browserConnectionId, String sawsId, String queryId, String queryText, String questionText, int retryCount, String authToken, String sourceId, String analysisId, String verbose, String refNodeId, String verboseS3Url, LogFormat logFormat) {
        JSONObject websocketMessage = new JSONObject();
        try {
            JSONObject message = new JSONObject();
            message.put((Object)"sample_records_json", (Object)filesMetadata.get("output_10k_json"));
            message.put((Object)"profile_json", (Object)filesMetadata.get("profile_json"));
            message.put((Object)"is_cloud_saws", (Object)isCloudSAWS);
            message.put((Object)"browser_connection_id", (Object)browserConnectionId);
            message.put((Object)"saws_id", (Object)sawsId);
            message.put((Object)"query_id", (Object)queryId);
            message.put((Object)"is_last_msg", (Object)true);
            message.put((Object)"status_code", (Object)(filesMetadata.get("output_10k_json") != null ? 200 : 500));
            message.put((Object)"error_message", (Object)"");
            message.put((Object)"query_text", (Object)queryText);
            message.put((Object)"total_records", (Object)filesMetadata.get("result_count"));
            message.put((Object)"tbl_record_count", (Object)filesMetadata.get("total_count"));
            message.put((Object)"retry_count", (Object)retryCount);
            message.put((Object)"auth_token", (Object)authToken);
            message.put((Object)"source_id", (Object)sourceId);
            message.put((Object)"analysis_id", (Object)analysisId);
            message.put((Object)"question_text", (Object)questionText);
            message.put((Object)"verbose", (Object)verbose);
            message.put((Object)"ref_node_id", (Object)refNodeId);
            message.put((Object)"verbose_s3_url", (Object)verboseS3Url);
            websocketMessage = this.buildWebsocketPayload(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), "Error while creating Websocket Message. \n Error = " + e.getLocalizedMessage());
        }
        return websocketMessage;
    }

    private JSONObject buildWebsocketPayload(JSONObject message) {
        JSONObject websocketMessage = new JSONObject();
        websocketMessage.put((Object)"action", (Object)"sendMessage");
        websocketMessage.put((Object)"source", (Object)"dvsumConnector");
        websocketMessage.put((Object)"message", (Object)message);
        return websocketMessage;
    }

    private String getErrorResponse(String jsonString, JSONObject resultJson, LogFormat logFormat) {
        logger.info(logFormat.getFormattedLog(), "loading error file table: ");
        JSONObject sampleDatajJson = new JSONObject();
        JSONArray resultsArray = new JSONArray();
        JSONObject errorJSON = new JSONObject();
        errorJSON.put((Object)"error", (Object)String.valueOf(resultJson.get((Object)"runError")));
        resultsArray.add((Object)errorJSON);
        sampleDatajJson.put((Object)"results", (Object)resultsArray);
        jsonString = sampleDatajJson.toJSONString();
        return jsonString;
    }

    private String getKeyFromPreSignedUrl(JSONObject s3PreSignedURL, String filePath, LogFormat logFormat) {
        String finalKey = "";
        try {
            String fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            JSONObject fields = (JSONObject)s3PreSignedURL.get((Object)"fields");
            String key = String.valueOf(fields.get((Object)"key"));
            finalKey = key.substring(0, key.lastIndexOf("/") + 1).concat(fileName);
        }
        catch (Exception e) {
            logger.error(logFormat.getFormattedLog(), "Error while getting key from Presigned URL.\n Error = " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return finalKey;
    }

    public static String compressJsonFile(String jsonFilePath) {
        String gzFilePath = jsonFilePath.trim().concat(".gz");
        GzipUtil.convertJsonToGz(jsonFilePath, gzFilePath);
        return gzFilePath;
    }

    private Map<String, String> uploadFilesToS3(JSONObject S3PreSignedURLInfo2, Map<String, String> filesMetadata, LogFormat logFormat) {
        TreeMap<String, String> sortedFiles = new TreeMap<String, String>(filesMetadata);
        try {
            for (Map.Entry entry : sortedFiles.entrySet()) {
                String key = (String)entry.getKey();
                String outputFilePath = (String)entry.getValue();
                if (!"profile_json".equalsIgnoreCase(key) && !"output_10k_json".equalsIgnoreCase(key)) continue;
                String compressedFilePath = AnalyticsQueryExecutorService.compressJsonFile(outputFilePath);
                MultipartFileUploader.uploadFileToS3(compressedFilePath, S3PreSignedURLInfo2, logFormat);
                logger.info("File uploaded to S3. File Path :", compressedFilePath);
                filesMetadata.replace(key, this.getKeyFromPreSignedUrl(S3PreSignedURLInfo2, compressedFilePath, logFormat));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(logFormat.getFormattedLog(), "Error while uploading files to S3. \n ERROR = " + e.getLocalizedMessage());
        }
        return filesMetadata;
    }
}

