/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.schedule;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.util.IOUtils;
import com.dvsum.logger.CustomLogger;
import com.dvsum.model.SawsAddress;
import com.dvsum.util.CryptographicUtil;
import com.dvsum.util.FileUtil;
import com.dvsum.util.PropsWithPlaceholderUtil;
import com.dvsum.util.SelfSignedHttps;
import com.dvsum.util.TLSHttpsRequestor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class S3BucketLogTask {
    private static final CustomLogger logger = CustomLogger.getLogger(S3BucketLogTask.class);
    private String getAccountUrl;
    private String httpsHandShakeCert;
    private String S3_ACCESS_KEY;
    private String S3_SECRET_KEY;
    private String BUCKET_NAME;
    private String BUCKET_KEY;
    private String S3_LOG_DIRECTORY_DATE_FORMAT;
    private String currentLogFile;
    private static final String SUFFIX = "/";
    private String folderName = "";
    private SawsAddress sawsAddress;
    private AWSCredentials credentials;
    private AmazonS3Client s3client;

    public void initialize() throws FileNotFoundException, IOException {
        this.initProps();
        if (this.sawsAddress == null) {
            this.sawsAddress = this.getCurrentSawsAddress();
        }
        if (this.sawsAddress != null) {
            this.S3_ACCESS_KEY = this.sawsAddress.getS3AccessKey() != null ? CryptographicUtil.decrypt(this.sawsAddress.getS3AccessKey()) : this.S3_ACCESS_KEY;
            this.S3_SECRET_KEY = this.sawsAddress.getS3SecretKey() != null ? CryptographicUtil.decrypt(this.sawsAddress.getS3SecretKey()) : this.S3_SECRET_KEY;
            this.folderName = String.valueOf(this.sawsAddress.getSawsLogFolder()) + SUFFIX + this.sawsAddress.getAccountId() + SUFFIX + this.sawsAddress.getSawsName();
            this.BUCKET_NAME = this.sawsAddress.getBucketName();
        }
        if (this.credentials == null && this.S3_ACCESS_KEY != null && this.S3_SECRET_KEY != null) {
            this.credentials = new BasicAWSCredentials(this.S3_ACCESS_KEY, this.S3_SECRET_KEY);
        }
        if (this.s3client == null && this.credentials != null) {
            this.s3client = new AmazonS3Client(this.credentials);
        }
        Date currentDate = new Date();
        String s3DateFormat = new SimpleDateFormat(this.S3_LOG_DIRECTORY_DATE_FORMAT).format(currentDate);
        this.BUCKET_KEY = "SAWS_" + s3DateFormat + ".log";
    }

    public void initProps() throws FileNotFoundException, IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        PropsWithPlaceholderUtil appProps = S3BucketLogTask.getFileProperties(classLoader.getResourceAsStream("application.properties"));
        PropsWithPlaceholderUtil log4jProps = S3BucketLogTask.getFileProperties(classLoader.getResourceAsStream("log4j-custom.properties"));
        PropsWithPlaceholderUtil s3Props = S3BucketLogTask.getFileProperties(classLoader.getResourceAsStream("aws-s3.properties"));
        PropsWithPlaceholderUtil urlsProps = S3BucketLogTask.getFileProperties(classLoader.getResourceAsStream("polling-urls.properties"));
        this.getAccountUrl = urlsProps.getString("get.user.account.id");
        this.httpsHandShakeCert = appProps.getString("httpsHandShakeCert");
        this.S3_LOG_DIRECTORY_DATE_FORMAT = s3Props.getString("s3.logs.file.date.format");
        this.currentLogFile = log4jProps.getString("log4j.appender.logfile.rollingPolicy.ActiveFileName");
    }

    public static PropsWithPlaceholderUtil getFileProperties(String propsClassPath) throws FileNotFoundException, IOException {
        PropsWithPlaceholderUtil appProps = new PropsWithPlaceholderUtil();
        appProps.load(new FileInputStream(propsClassPath));
        return appProps;
    }

    public static PropsWithPlaceholderUtil getFileProperties(InputStream is) throws FileNotFoundException, IOException {
        PropsWithPlaceholderUtil appProps = new PropsWithPlaceholderUtil();
        appProps.load(is);
        return appProps;
    }

    public void run() throws FileNotFoundException, IOException {
        this.initialize();
        if (this.sawsAddress != null) {
            this.appendObject((AmazonS3)this.s3client, this.currentLogFile, this.BUCKET_NAME, this.BUCKET_KEY);
        }
    }

    public void run(File file) throws FileNotFoundException, IOException {
        this.initialize();
        if (this.sawsAddress != null) {
            String filePath;
            String fileName = filePath = file.getPath();
            int dirIdx = fileName.lastIndexOf("\\");
            String oldBucketKey = this.BUCKET_KEY;
            if (dirIdx > -1) {
                fileName = fileName.substring(dirIdx + 1);
            }
            this.BUCKET_KEY = fileName;
            this.appendObject((AmazonS3)this.s3client, filePath, this.BUCKET_NAME, this.BUCKET_KEY);
            this.BUCKET_KEY = oldBucketKey;
        }
    }

    public SawsAddress getCurrentSawsAddress() {
        String token = FileUtil.getAPIkey();
        if (this.httpsHandShakeCert != null) {
            String responseString;
            String string = responseString = "caSigned".equalsIgnoreCase(this.httpsHandShakeCert) ? TLSHttpsRequestor.executeGet(this.getAccountUrl, new Object[]{token}, new Object[]{"token"}) : SelfSignedHttps.executeGetRequest(this.getAccountUrl, new Object[]{token}, new Object[]{"token"});
            if (responseString != null && responseString.length() > 0 && !responseString.contains("DvSum Error")) {
                try {
                    SawsAddress sawsAddress = (SawsAddress)new ObjectMapper().readValue(responseString, SawsAddress.class);
                    return sawsAddress;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void appendObject(AmazonS3 s3client, String filePath, String bucketName, String bucketKey) throws FileNotFoundException, IOException {
        S3Object s3Object = this.getS3Object(s3client, bucketName, bucketKey);
        File file = new File(filePath);
        S3ObjectInputStream s3ObjectStream = s3Object.getObjectContent();
        ObjectMetadata s3ObjectMetadata = s3Object.getObjectMetadata();
        long s3ObjectLength = s3ObjectMetadata.getContentLength();
        byte[] appendableBytes = this.getStreamChunkFromStream(file, s3ObjectLength);
        ByteArrayInputStream appendableStream = new ByteArrayInputStream(appendableBytes);
        if (appendableBytes.length > 0) {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            InputStream finalStream = null;
            if (file.length() < s3ObjectLength) {
                metadata.setContentLength((long)appendableBytes.length);
                finalStream = appendableStream;
            } else if (file.length() > s3ObjectLength) {
                metadata.setContentLength((long)appendableBytes.length + s3ObjectLength);
                SequenceInputStream sis = new SequenceInputStream((InputStream)s3ObjectStream, appendableStream);
                finalStream = sis;
            }
            if ((long)appendableBytes.length != s3ObjectLength) {
                String fileName = String.valueOf(this.folderName) + SUFFIX + bucketKey;
                PutObjectRequest request = new PutObjectRequest(bucketName, fileName, finalStream, metadata);
                s3client.putObject(request);
            }
        }
        s3Object.close();
    }

    public byte[] getStreamChunkFromStream(File file, Long s3ObjectLength) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bs = this.getStreamBytes(is);
        int startIndex = s3ObjectLength.intValue();
        byte[] finalBytes = new byte[]{};
        if (bs.length > startIndex) {
            byte[] appendable = Arrays.copyOfRange(bs, startIndex, bs.length);
            byte[] newLine = "\n".getBytes();
            finalBytes = new byte[appendable.length + newLine.length];
            System.arraycopy(newLine, 0, finalBytes, 0, newLine.length);
            System.arraycopy(appendable, 0, finalBytes, newLine.length, appendable.length);
        } else if (bs.length < startIndex) {
            finalBytes = bs;
        }
        return finalBytes;
    }

    public InputStream getStreamWithNewLineAtEnd(InputStream is) throws IOException {
        int size = is.available();
        if (1 == size) {
            return is;
        }
        byte[] newLine = "\n".getBytes();
        return new SequenceInputStream(is, new ByteArrayInputStream(newLine));
    }

    public byte[] getBytesChunkFromStream(File file, InputStream appendWith) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bs = this.getStreamBytes(is);
        byte[] bs1 = this.getStreamBytes(appendWith);
        int startIndex = bs1.length;
        byte[] appendable = Arrays.copyOfRange(bs, startIndex, bs.length);
        byte[] finalBytes = new byte[appendable.length + bs1.length];
        System.arraycopy(bs1, 0, finalBytes, 0, bs1.length);
        System.arraycopy(appendable, 0, finalBytes, bs1.length, appendable.length);
        return finalBytes;
    }

    public InputStream getByteStream(byte[] buf) {
        return new ByteArrayInputStream(buf);
    }

    public byte[] getStreamBytes(InputStream is) throws IOException {
        return IOUtils.toByteArray((InputStream)is);
    }

    public int getStreamLength(InputStream is) throws IOException {
        byte[] bs = this.getStreamBytes(is);
        return bs.length;
    }

    public String getStreamText(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        do {
            line = reader.readLine();
            sb.append(line);
        } while (line != null);
        return sb.toString();
    }

    public S3Object getS3Object(AmazonS3 s3client, String bucketName, String bucketKey) {
        String fileName = String.valueOf(this.folderName) + SUFFIX + bucketKey;
        boolean isObjectExist = this.doesS3ObjectExist(s3client, bucketName, bucketKey, fileName);
        if (!isObjectExist) {
            this.createFolder(s3client, bucketName, this.folderName);
            this.uploadEmptyFile(s3client, bucketName, fileName);
        }
        if (!(isObjectExist = this.doesS3ObjectExist(s3client, bucketName, bucketKey, fileName))) {
            this.uploadEmptyFile(s3client, bucketName, fileName);
        }
        GetObjectRequest objectRequest = new GetObjectRequest(bucketName, fileName);
        S3Object s3Object = s3client.getObject(objectRequest);
        return s3Object;
    }

    public void uploadFile(AmazonS3 s3client, String bucketName, String fileName, File file) {
        s3client.putObject(new PutObjectRequest(bucketName, fileName, file));
    }

    public void deleteFile(AmazonS3 s3client, String bucketName, String fileName) {
        s3client.deleteObject(bucketName, fileName);
    }

    public void createFolder(AmazonS3 s3client, String bucketName, String folderName) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, String.valueOf(folderName) + SUFFIX, (InputStream)emptyContent, metadata);
        s3client.putObject(putObjectRequest);
    }

    public void uploadEmptyFile(AmazonS3 s3client, String bucketName, String fileName) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, fileName, (InputStream)emptyContent, metadata);
        s3client.putObject(putObjectRequest);
    }

    public void deleteBucket(AmazonS3 s3client, String bucketName) {
        s3client.deleteBucket(bucketName);
    }

    public void deleteFolder(String bucketName, String folderName, AmazonS3 client) {
        List fileList = client.listObjects(bucketName, folderName).getObjectSummaries();
        for (S3ObjectSummary file : fileList) {
            client.deleteObject(bucketName, file.getKey());
        }
        client.deleteObject(bucketName, folderName);
    }

    public boolean doesS3ObjectExist(AmazonS3 s3client, String bucketName, String bucketKey, String fileName) {
        try {
            return s3client.doesObjectExist(bucketName, fileName);
        }
        catch (Exception e) {
            logger.error("Exception: ", e);
            return false;
        }
    }
}

