/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.logger.CustomLogger;
import org.json.simple.JSONObject;

public class TableProfileOutput {
    private static final CustomLogger logger = CustomLogger.getLogger(TableProfileOutput.class);
    private String recordCount;
    private String sampleUrl;

    public TableProfileOutput(String recordCount, String sampleUrl) {
        this.recordCount = recordCount;
        this.sampleUrl = sampleUrl;
    }

    public TableProfileOutput(JSONObject jsonObject) {
        if (jsonObject != null) {
            this.recordCount = this.getStringValue(jsonObject, "tbl_record_cnt");
            this.sampleUrl = this.getStringValue(jsonObject, "tbl_sample_url");
        }
    }

    private String getStringValue(JSONObject jsonObject, String key) {
        Object value = jsonObject.get((Object)key);
        return value != null ? String.valueOf(value) : null;
    }

    public String getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(String recordCount) {
        this.recordCount = recordCount;
    }

    public String getSampleUrl() {
        return this.sampleUrl;
    }

    public void setSampleUrl(String sampleUrl) {
        this.sampleUrl = sampleUrl;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"tbl_record_cnt", (Object)this.recordCount);
        json.put((Object)"tbl_sample_url", (Object)this.sampleUrl);
        return json;
    }
}

