/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.logger.LogFormat;
import com.dvsum.model.QueryExecutor;
import com.dvsum.model.ref.RefQueryType;
import com.dvsum.rule.BaseProfileQueries;
import com.dvsum.rule.BaseRule;
import com.dvsum.rule.ColumnDetail;
import com.dvsum.rule.ColumnProfileOutput;
import com.dvsum.rule.Connector;
import com.dvsum.rule.NodeExecutionMetadata;
import com.dvsum.rule.ProfileNode;
import com.dvsum.rule.ProfileQueries;
import com.dvsum.rule.Source;
import com.dvsum.rule.TableProfileOutput;
import com.dvsum.rule.TemplateQueries;
import com.dvsum.util.FileUtil;
import com.dvsum.util.JsonUtil;
import com.dvsum.util.MultipartFileUploader;
import com.dvsum.util.Util;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ProfileRule
extends BaseRule {
    private static final CustomLogger logger = CustomLogger.getLogger(ProfileRule.class);

    public ProfileRule(ExecutorService executorService, ProfileNode node, List<Source> sources, Connector connector, String executionId, JSONObject s3PreSignedURLInfo, LogFormat logFormat) {
        super(executorService, node, sources, connector, executionId, s3PreSignedURLInfo, logFormat);
        this.baseFilePath = "./dq_analysis/" + this.executionId + "/";
    }

    @Override
    public void executeQueries() {
        ProfileNode profileNode = (ProfileNode)this.node;
        this.submitQueries(profileNode);
        this.getQueryResults();
        this.processQueryResults();
        this.dumpWebsocketMessageToS3(this.node.toJSON(), String.valueOf(this.getModifiedFileName(((ProfileNode)this.node).getTableName())) + "_output.json");
        this.sendMessageToWebsocket();
    }

    @Override
    protected void processQueryResults() {
        ProfileNode profileNode = (ProfileNode)this.node;
        TableProfileOutput tableProfileOutput = this.generateTableProfileOutput();
        profileNode.setTblPrfOutput(tableProfileOutput);
        for (ColumnDetail columnDetail : profileNode.getColDetails()) {
            logger.info(this.logFormat.getFormattedLog(), "Processing results for column : ", columnDetail.getColName());
            ColumnProfileOutput columnProfileOutput = this.generateColumnProfileOutput(columnDetail);
            if (!columnDetail.getIsColumnMasked().booleanValue()) {
                this.executeQueryAndGetHistogramResults(columnProfileOutput, columnDetail);
            }
            columnDetail.setPrfOutput(columnProfileOutput);
            if (columnDetail.getPrfStatus().equalsIgnoreCase("-1")) continue;
            columnDetail.setPrfStatus("0");
        }
    }

    public void executeQueryAndGetHistogramResults(ColumnProfileOutput columnProfileOutput, ColumnDetail columnDetail) {
        try {
            ProfileNode profileNode = (ProfileNode)this.node;
            ProfileQueries profileQueries = profileNode.getTemplateQueries().getProfileQueries();
            BaseProfileQueries baseProfileQueries = profileQueries.getQueries(columnDetail.getColDataType());
            this.executeColumnHistogramQuery(baseProfileQueries.getHistograms(), profileNode.getTableName(), columnDetail, columnProfileOutput);
            this.getQueryResults();
            JSONObject columnProfileOutputJson = this.getColumnProfileOutputJson("data_profile.num_stats.histograms", columnDetail);
            columnProfileOutput.setHist((JSONObject)columnProfileOutputJson.get((Object)"data_profile.num_stats.histograms"));
        }
        catch (Exception e) {
            logger.error(this.logFormat.getFormattedLog(), "Error found while executing column base profile queries. Error = ", e.getMessage());
        }
    }

    public void executeColumnHistogramQuery(String query, String tableName, ColumnDetail columnDetail, ColumnProfileOutput columnProfileOutput) {
        if (Util.isNullOrEmpty(query)) {
            return;
        }
        logger.info(this.logFormat.getFormattedLog(), "Executing ", "data_profile.num_stats.histograms", " for ", columnDetail.getColName());
        String updatedQuery = TemplateQueries.getUpdatedHistogramQuery(query, tableName, columnDetail.getColName(), columnProfileOutput.getMinValue(), columnProfileOutput.getMaxValue());
        Source source = Source.findSourceById(columnDetail.getSrcId(), this.sources);
        JSONObject connConfig = source.getConnConfigForQueryExecutor(columnDetail.getColName(), columnDetail.getColId(), "data_profile.num_stats.histograms", updatedQuery);
        this.submitQueryToExecute(connConfig);
    }

    public ColumnProfileOutput generateColumnProfileOutput(ColumnDetail columnDetail) {
        JSONObject columnProfileOutputJson = new JSONObject();
        ColumnProfileOutput columnProfileOutput = null;
        try {
            columnProfileOutputJson.putAll((Map)this.getColumnProfileOutputJson("BASE_PRF", columnDetail));
            if (!columnDetail.getIsColumnMasked().booleanValue()) {
                columnProfileOutputJson.putAll((Map)this.getColumnProfileOutputJson("data_profile.cat_stats.categories", columnDetail));
                columnProfileOutputJson.putAll((Map)this.getColumnProfileOutputJson("data_profile.pattern_stats.patterns", columnDetail));
            }
            columnProfileOutput = new ColumnProfileOutput(columnProfileOutputJson);
            if (columnDetail.getIsColumnMasked().booleanValue()) {
                columnProfileOutput.setMaxValue("XXX");
                columnProfileOutput.setMinValue("XXX");
            }
        }
        catch (Exception e) {
            logger.error("Error found while generating column profile output. Error = ", e.getMessage());
        }
        return columnProfileOutput;
    }

    public JSONObject getColumnProfileOutputJson(String queryType, ColumnDetail columnDetail) throws Exception {
        JSONObject outputJson = new JSONObject();
        JSONObject queryResultsJson = this.findQueryResultsByQueryType(queryType, columnDetail.getColId());
        if (QueryExecutor.checkRunStatus(queryResultsJson)) {
            JSONArray queryResults = QueryExecutor.getRunJson(queryResultsJson);
            JSONObject modifiedQueryResults = this.modifyProfileResults(queryType, queryResults, columnDetail);
            outputJson.put((Object)queryType, (Object)modifiedQueryResults);
        } else {
            if (RefQueryType.isBaseProfileQuery(queryType)) {
                logger.error(this.logFormat.getFormattedLog(), "Profiling failed for column :", columnDetail.getColName());
                columnDetail.setPrfErrorMsg(QueryExecutor.getRunError(queryResultsJson));
                columnDetail.setPrfStatus(QueryExecutor.getRunStatus(queryResultsJson));
                throw new Exception("Profiling failed for column :" + columnDetail.getColName());
            }
            logger.error(this.logFormat.getFormattedLog(), queryType, "query failed for column :", columnDetail.getColName());
        }
        return outputJson;
    }

    public JSONObject modifyProfileResults(String queryType, JSONArray queryResults, ColumnDetail columnDetail) {
        JSONObject modifiedQueryResults = new JSONObject();
        switch (queryType) {
            case "BASE_PRF": {
                modifiedQueryResults = (JSONObject)queryResults.get(0);
                break;
            }
            case "data_profile.cat_stats.categories": {
                modifiedQueryResults = this.convertProfilingResultsArrayToJson(queryResults, columnDetail);
                break;
            }
            case "data_profile.pattern_stats.patterns": {
                modifiedQueryResults = this.convertProfilingResultsArrayToJson(queryResults, columnDetail);
                break;
            }
            case "data_profile.num_stats.histograms": {
                modifiedQueryResults = this.convertProfilingResultsArrayToJson(queryResults, columnDetail);
                break;
            }
            default: {
                logger.info("Query type not valid. Query type : ", queryType);
            }
        }
        return modifiedQueryResults;
    }

    public JSONObject convertProfilingResultsArrayToJson(JSONArray queryResults, ColumnDetail columnDetail) {
        JSONObject modifiedQueryResults = new JSONObject();
        queryResults.forEach(profileResult -> {
            JSONObject colResult = (JSONObject)profileResult;
            String colValue = String.valueOf(colResult.get((Object)this.getModifiedKey(columnDetail.getColName())));
            int valCount = Integer.valueOf(String.valueOf(colResult.get((Object)"cnt")));
            modifiedQueryResults.put((Object)colValue, (Object)valCount);
        });
        return modifiedQueryResults;
    }

    public TableProfileOutput generateTableProfileOutput() {
        JSONObject sampleRecordsQueryResultsJson = this.findQueryResultsByQueryType("sample_query");
        String sampleUrl = this.getSampleUrlFromSampleResultsJson(sampleRecordsQueryResultsJson);
        JSONObject baseTableQueryResultsJson = this.findQueryResultsByQueryType("base_table_profile");
        String recordCount = this.getRecordCountFromBaseTableResults(baseTableQueryResultsJson);
        TableProfileOutput tableProfileOutput = new TableProfileOutput(recordCount, sampleUrl);
        return tableProfileOutput;
    }

    public String getRecordCountFromBaseTableResults(JSONObject baseTableQueryResultsJson) {
        String requiredRecordCount = "0";
        if (!QueryExecutor.checkRunStatus(baseTableQueryResultsJson)) {
            String error = QueryExecutor.getRunError(baseTableQueryResultsJson);
            logger.error(this.logFormat.getFormattedLog(), "Base table profile query failed. Error :", error);
            requiredRecordCount = "0";
        } else {
            JSONArray queryResults = QueryExecutor.getRunJson(baseTableQueryResultsJson);
            for (Object queryResultObj : queryResults) {
                JSONObject queryResultJson = (JSONObject)queryResultObj;
                if (!queryResultJson.containsKey((Object)"num_rows")) continue;
                requiredRecordCount = String.valueOf(queryResultJson.get((Object)"num_rows"));
                break;
            }
        }
        return requiredRecordCount;
    }

    public String getSampleUrlFromSampleResultsJson(JSONObject sampleQueryResultsJson) {
        String requiredSampleUrl = null;
        if (QueryExecutor.getRunStatus(sampleQueryResultsJson).equalsIgnoreCase("-1")) {
            String error = QueryExecutor.getRunError(sampleQueryResultsJson);
            logger.error(this.logFormat.getFormattedLog(), "Sample Data query failed. Error :", error);
        } else {
            JSONArray queryResults = QueryExecutor.getRunJson(sampleQueryResultsJson);
            String tableName = String.valueOf(sampleQueryResultsJson.get((Object)"name"));
            requiredSampleUrl = this.SampleDataUploadHandler(queryResults, tableName);
        }
        return requiredSampleUrl;
    }

    public String SampleDataUploadHandler(JSONArray results, String tableName) {
        String isCloudSAWS = FileUtil.getPropertyWithDefault("is.cloud.saws", "false");
        String fileName = String.valueOf(this.getModifiedFileName(tableName)) + "_sample_data.json";
        String queryOutputFilePath = String.valueOf(this.baseFilePath) + fileName;
        FileUtil.writeToFileIfNotExists(queryOutputFilePath, this.encryptText(results.toJSONString()));
        String filePathToReturn = queryOutputFilePath;
        if ("false".equalsIgnoreCase(isCloudSAWS)) {
            logger.info(this.logFormat.getFormattedLog(), "On-Prem SAWS : Storing query output files in local file system");
        } else {
            logger.info(this.logFormat.getFormattedLog(), "Cloud SAWS : Uploading query output files to S3");
            String compressedQueryOutputFilePath = JsonUtil.compressJsonFile(queryOutputFilePath);
            MultipartFileUploader.uploadFileToS3(compressedQueryOutputFilePath, this.s3PreSignedURLInfo, this.logFormat);
            filePathToReturn = NodeExecutionMetadata.getModifiedKeyFromS3PresignedPostUrl(this.s3PreSignedURLInfo, ProfileRule.extractFileNameFromPath(compressedQueryOutputFilePath));
        }
        return filePathToReturn;
    }

    public void submitQueries(ProfileNode profileNode) {
        this.executeSampleQuery(profileNode.getTemplateQueries().getSampleQuery(), profileNode);
        this.executeBaseTableProfileQuery(profileNode.getTemplateQueries().getBaseTableProfile(), profileNode);
        for (ColumnDetail columnDetail : profileNode.getColDetails()) {
            logger.info(this.logFormat.getFormattedLog(), "Profiling started for ", columnDetail.getColName());
            this.executeColumnBaseProfileQueries(profileNode, columnDetail);
        }
    }

    public void executeColumnBaseProfileQuery(String query, String queryType, String tableName, ColumnDetail columnDetail, Source source) {
        if (query == null) {
            return;
        }
        logger.info(this.logFormat.getFormattedLog(), "Executing ", queryType, " for ", columnDetail.getColName());
        String updatedQuery = TemplateQueries.getUpdatedQuery(query, tableName, columnDetail.getColName(), null);
        JSONObject connConfig = source.getConnConfigForQueryExecutor(columnDetail.getColName(), columnDetail.getColId(), queryType, updatedQuery);
        this.submitQueryToExecute(connConfig);
    }

    public void executeColumnBaseProfileQueries(ProfileNode profileNode, ColumnDetail columnDetail) {
        logger.info(this.logFormat.getFormattedLog(), "Executing Base Profile Queries for Column : ", columnDetail.getColName());
        try {
            Source source = Source.findSourceById(columnDetail.getSrcId(), this.sources);
            ProfileQueries profileQueries = profileNode.getTemplateQueries().getProfileQueries();
            BaseProfileQueries baseProfileQueries = profileQueries.getQueries(columnDetail.getColDataType());
            this.executeColumnBaseProfileQuery(baseProfileQueries.getBasePrf(), "BASE_PRF", profileNode.getTableName(), columnDetail, source);
            if (!columnDetail.getIsColumnMasked().booleanValue()) {
                this.executeColumnBaseProfileQuery(baseProfileQueries.getCategories(), "data_profile.cat_stats.categories", profileNode.getTableName(), columnDetail, source);
                this.executeColumnBaseProfileQuery(baseProfileQueries.getPatterns(), "data_profile.pattern_stats.patterns", profileNode.getTableName(), columnDetail, source);
            }
        }
        catch (Exception e) {
            logger.error(this.logFormat.getFormattedLog(), "Error found while executing column base profile queries. Error = ", e.getMessage());
        }
    }

    public void executeBaseTableProfileQuery(String query, ProfileNode profileNode) {
        logger.info(this.logFormat.getFormattedLog(), "Executing Base Table Profile Query for Table : ", profileNode.getTableName());
        Source source = Source.findSourceById(profileNode.getSrcId(), this.sources);
        query = TemplateQueries.getUpdatedQuery(query, profileNode.getTableName(), null, null);
        JSONObject connConfig = source.getConnConfigForQueryExecutor(profileNode.getTableName(), profileNode.getTableId(), "base_table_profile", query);
        this.submitQueryToExecute(connConfig);
    }

    public void executeSampleQuery(String query, ProfileNode profileNode) {
        logger.info(this.logFormat.getFormattedLog(), "Executing Sample Data Query for Table : ", profileNode.getTableName());
        Source source = Source.findSourceById(profileNode.getSrcId(), this.sources);
        query = TemplateQueries.getUpdatedQuery(query, profileNode.getTableName(), "*", profileNode.getColDetails());
        JSONObject connConfig = source.getConnConfigForQueryExecutor(profileNode.getTableName(), profileNode.getTableId(), "sample_query", query);
        this.submitQueryToExecute(connConfig);
    }

    public Future<JSONObject> submitQueryToExecute(JSONObject connConfig) {
        Future queryResultsFuture = null;
        try {
            QueryExecutor queryExecutor = new QueryExecutor(this.dataSourceFactory, connConfig, false, this.logFormat);
            queryResultsFuture = this.executorService.submit(queryExecutor);
            this.futureResults.add(queryResultsFuture);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryResultsFuture;
    }

    protected JSONObject getQueryResultsFromFuture(Future<JSONObject> queryResults) {
        JSONObject queryResultsJson = new JSONObject();
        try {
            if (queryResults.get() != null && !queryResults.get().isEmpty()) {
                queryResultsJson = queryResults.get();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryResultsJson;
    }
}

