/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.logger.CustomLogger;
import com.dvsum.rule.ColumnDetail;
import com.dvsum.rule.Node;
import com.dvsum.rule.SqlQuery;
import com.dvsum.rule.TableProfileOutput;
import com.dvsum.rule.TemplateQueries;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ProfileNode
extends Node {
    private static final CustomLogger logger = CustomLogger.getLogger(ProfileNode.class);
    protected String tableId;
    protected String tableName;
    protected List<ColumnDetail> colDetails;
    protected TemplateQueries templateQueries;
    protected TableProfileOutput tblPrfOutput;

    public ProfileNode(String srcId, Long nodeId, String ruleId, String nodeType, String operation, String ruleType, List<SqlQuery> sqlQueries, Boolean isSeqRequired, String jobId, Boolean isJobOnline, String uiWebsocketId, String tableId, String tblName, TableProfileOutput tblPrfOutput) {
        super(srcId, nodeId, ruleId, nodeType, operation, ruleType, sqlQueries, isSeqRequired, jobId, isJobOnline, uiWebsocketId);
        this.tableId = tableId;
        this.tableName = tblName;
        this.tblPrfOutput = tblPrfOutput;
    }

    public ProfileNode(JSONObject nodeJson) {
        super(nodeJson);
        JSONArray colDetailsJsonArray = (JSONArray)nodeJson.get((Object)"col_details");
        this.colDetails = ColumnDetail.getColumnDetailsFromJsonArray(colDetailsJsonArray);
        JSONObject templateQueriesJson = (JSONObject)nodeJson.get((Object)"tmplt_queries");
        this.templateQueries = new TemplateQueries(templateQueriesJson);
        this.tableId = String.valueOf(nodeJson.get((Object)"tbl_id"));
        this.tableName = nodeJson.containsKey((Object)"tbl_name") ? (String)nodeJson.get((Object)"tbl_name") : null;
        JSONObject tblPrfOutputJson = (JSONObject)nodeJson.get((Object)"tbl_prf_output");
        if (tblPrfOutputJson != null) {
            this.tblPrfOutput = new TableProfileOutput(String.valueOf(tblPrfOutputJson.get((Object)"tbl_record_cnt")), String.valueOf(tblPrfOutputJson.get((Object)"tbl_sample_url")));
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put((Object)"tbl_id", (Object)this.tableId);
        json.put((Object)"tbl_name", (Object)this.tableName);
        JSONArray colDetailsArray = new JSONArray();
        for (ColumnDetail columnDetail : this.colDetails) {
            colDetailsArray.add((Object)columnDetail.toJSON());
        }
        json.put((Object)"col_details", (Object)colDetailsArray);
        json.put((Object)"tbl_prf_output", this.tblPrfOutput != null ? this.tblPrfOutput.toJSON() : null);
        return json;
    }

    public String getTableId() {
        return this.tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnDetail> getColDetails() {
        return this.colDetails;
    }

    public void setColDetails(List<ColumnDetail> colDetails) {
        this.colDetails = colDetails;
    }

    public TemplateQueries getTemplateQueries() {
        return this.templateQueries;
    }

    public void setTemplateQueries(TemplateQueries templateQueries) {
        this.templateQueries = templateQueries;
    }

    public TableProfileOutput getTblPrfOutput() {
        return this.tblPrfOutput;
    }

    public void setTblPrfOutput(TableProfileOutput tblPrfOutput) {
        this.tblPrfOutput = tblPrfOutput;
    }
}

