/*
 * Decompiled with CFR 0.152.
 */
package com.dvsum.rule;

import com.dvsum.rule.Connector;
import com.dvsum.rule.Node;
import com.dvsum.rule.Source;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class NodeExecutionMetadata {
    private List<Node> nodes;
    private List<Source> sources;
    private List<Connector> connectors;
    private String jobId;
    private String taskToken;
    private String executionId;
    private JSONObject s3PreSignedPostUrl;
    private String uiWebsocketId;
    private Boolean isJobOnline;

    public NodeExecutionMetadata(List<Node> nodes, List<Source> sources, List<Connector> connectors, String jobId, String taskToken, String executionId, JSONObject s3PreSignedPostUrl, String uiWebsocketId, Boolean isJobOnline) {
        this.nodes = nodes;
        this.sources = sources;
        this.connectors = connectors;
        this.jobId = jobId;
        this.taskToken = taskToken;
        this.executionId = executionId;
        this.s3PreSignedPostUrl = s3PreSignedPostUrl;
        this.uiWebsocketId = uiWebsocketId;
        this.isJobOnline = isJobOnline;
    }

    public NodeExecutionMetadata(JSONObject nodeExecutionMetadata) {
        JSONArray nodesJsonArray = (JSONArray)nodeExecutionMetadata.get((Object)"nodes");
        this.nodes = Node.getNodesFromJsonArray(nodesJsonArray);
        JSONArray sourcesJson = (JSONArray)nodeExecutionMetadata.get((Object)"sources");
        this.sources = Source.getSourcesFromJson(sourcesJson);
        JSONArray connectorDetailsArray = (JSONArray)nodeExecutionMetadata.get((Object)"connector_details");
        this.connectors = Connector.getConnectorsFromJson(connectorDetailsArray);
        this.jobId = String.valueOf(nodeExecutionMetadata.get((Object)"job_id"));
        this.taskToken = (String)nodeExecutionMetadata.get((Object)"task_token");
        this.executionId = (String)nodeExecutionMetadata.get((Object)"execution_id");
        this.s3PreSignedPostUrl = (JSONObject)nodeExecutionMetadata.get((Object)"s3_pre_signed_post_url");
        this.uiWebsocketId = (String)nodeExecutionMetadata.get((Object)"ui_websocket_id");
        this.isJobOnline = nodeExecutionMetadata.get((Object)"is_job_online") != null ? (Boolean)nodeExecutionMetadata.get((Object)"is_job_online") : null;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> nodes) {
        this.nodes = nodes;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    public List<Connector> getConnectorDetails() {
        return this.connectors;
    }

    public void setConnectorDetails(List<Connector> connectors) {
        this.connectors = connectors;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getTaskToken() {
        return this.taskToken;
    }

    public void setTaskToken(String taskToken) {
        this.taskToken = taskToken;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public JSONObject getS3PreSignedPostUrl() {
        return this.s3PreSignedPostUrl;
    }

    public void setS3PreSignedPostUrl(JSONObject s3PreSignedPostUrl) {
        this.s3PreSignedPostUrl = s3PreSignedPostUrl;
    }

    public String getUiWebsocketId() {
        return this.uiWebsocketId;
    }

    public void setUiWebsocketId(String uiWebsocketId) {
        this.uiWebsocketId = uiWebsocketId;
    }

    public Boolean getIsJobOnline() {
        return this.isJobOnline;
    }

    public void setIsJobOnline(Boolean isJobOnline) {
        this.isJobOnline = isJobOnline;
    }

    public static String getModifiedKeyFromS3PresignedPostUrl(JSONObject s3PreSignedPostUrl, String fileName) {
        JSONObject fields = (JSONObject)s3PreSignedPostUrl.get((Object)"fields");
        String key = String.valueOf(fields.get((Object)"key"));
        return key.replace("${filename}", fileName);
    }
}

